/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.task.builder;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeStaticMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeType;
import org.apache.iotdb.db.pipe.agent.task.PipeDataNodeTask;
import org.apache.iotdb.db.pipe.agent.task.execution.PipeConnectorSubtaskExecutor;
import org.apache.iotdb.db.pipe.agent.task.execution.PipeProcessorSubtaskExecutor;
import org.apache.iotdb.db.pipe.agent.task.execution.PipeSubtaskExecutorManager;
import org.apache.iotdb.db.pipe.agent.task.stage.PipeTaskConnectorStage;
import org.apache.iotdb.db.pipe.agent.task.stage.PipeTaskExtractorStage;
import org.apache.iotdb.db.pipe.agent.task.stage.PipeTaskProcessorStage;
import org.apache.iotdb.db.pipe.extractor.dataregion.DataRegionListeningFilter;
import org.apache.iotdb.db.subscription.task.stage.SubscriptionTaskConnectorStage;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeDataNodeTaskBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeDataNodeTaskBuilder.class);
    private final PipeStaticMeta pipeStaticMeta;
    private final int regionId;
    private final PipeTaskMeta pipeTaskMeta;
    private static final PipeProcessorSubtaskExecutor PROCESSOR_EXECUTOR = PipeSubtaskExecutorManager.getInstance().getProcessorExecutor();
    private static final Map<PipeType, PipeConnectorSubtaskExecutor> CONNECTOR_EXECUTOR_MAP = new EnumMap<PipeType, PipeConnectorSubtaskExecutor>(PipeType.class);
    protected final Map<String, String> systemParameters = new HashMap<String, String>();

    public PipeDataNodeTaskBuilder(PipeStaticMeta pipeStaticMeta, int regionId, PipeTaskMeta pipeTaskMeta) {
        this.pipeStaticMeta = pipeStaticMeta;
        this.regionId = regionId;
        this.pipeTaskMeta = pipeTaskMeta;
        this.generateSystemParameters();
    }

    public PipeDataNodeTask build() {
        PipeParameters extractorParameters = this.blendUserAndSystemParameters(this.pipeStaticMeta.getExtractorParameters());
        PipeParameters connectorParameters = this.blendUserAndSystemParameters(this.pipeStaticMeta.getConnectorParameters());
        this.checkConflict(extractorParameters, connectorParameters);
        PipeTaskExtractorStage extractorStage = new PipeTaskExtractorStage(this.pipeStaticMeta.getPipeName(), this.pipeStaticMeta.getCreationTime(), extractorParameters, this.regionId, this.pipeTaskMeta);
        PipeType pipeType = this.pipeStaticMeta.getPipeType();
        PipeTaskConnectorStage connectorStage = PipeType.SUBSCRIPTION.equals((Object)pipeType) ? new SubscriptionTaskConnectorStage(this.pipeStaticMeta.getPipeName(), this.pipeStaticMeta.getCreationTime(), connectorParameters, this.regionId, CONNECTOR_EXECUTOR_MAP.get(pipeType)) : new PipeTaskConnectorStage(this.pipeStaticMeta.getPipeName(), this.pipeStaticMeta.getCreationTime(), connectorParameters, this.regionId, CONNECTOR_EXECUTOR_MAP.get(pipeType));
        PipeTaskProcessorStage processorStage = new PipeTaskProcessorStage(this.pipeStaticMeta.getPipeName(), this.pipeStaticMeta.getCreationTime(), this.blendUserAndSystemParameters(this.pipeStaticMeta.getProcessorParameters()), this.regionId, extractorStage.getEventSupplier(), connectorStage.getPipeConnectorPendingQueue(), PROCESSOR_EXECUTOR, this.pipeTaskMeta, this.pipeStaticMeta.getConnectorParameters().getStringOrDefault(Arrays.asList("connector.format", "sink.format"), "hybrid").equals("tablet"), PipeType.SUBSCRIPTION.equals((Object)pipeType));
        return new PipeDataNodeTask(this.pipeStaticMeta.getPipeName(), this.regionId, extractorStage, processorStage, connectorStage);
    }

    private void generateSystemParameters() {
        if (!(this.pipeTaskMeta.getProgressIndex() instanceof MinimumProgressIndex)) {
            this.systemParameters.put("__system.restart", Boolean.TRUE.toString());
        }
    }

    private PipeParameters blendUserAndSystemParameters(PipeParameters userParameters) {
        HashMap<String, String> blendedParameters = new HashMap<String, String>(userParameters.getAttribute());
        blendedParameters.putAll(this.systemParameters);
        return new PipeParameters(blendedParameters);
    }

    private void checkConflict(PipeParameters extractorParameters, PipeParameters connectorParameters) {
        Pair<Boolean, Boolean> insertionDeletionListeningOptionPair;
        try {
            boolean shouldTerminatePipeOnAllHistoricalEventsConsumed;
            insertionDeletionListeningOptionPair = DataRegionListeningFilter.parseInsertionDeletionListeningOptionPair(extractorParameters);
            if (extractorParameters.hasAnyAttributes(new String[]{"extractor.mode.snapshot", "source.mode.snapshot"})) {
                shouldTerminatePipeOnAllHistoricalEventsConsumed = extractorParameters.getBooleanOrDefault(Arrays.asList("extractor.mode.snapshot", "source.mode.snapshot"), false);
            } else {
                String extractorModeValue = extractorParameters.getStringOrDefault(Arrays.asList("extractor.mode", "source.mode"), "live");
                boolean bl = shouldTerminatePipeOnAllHistoricalEventsConsumed = extractorModeValue.equalsIgnoreCase("snapshot") || extractorModeValue.equalsIgnoreCase("query");
            }
            if (!((Boolean)insertionDeletionListeningOptionPair.right).booleanValue() && !shouldTerminatePipeOnAllHistoricalEventsConsumed) {
                return;
            }
        }
        catch (IllegalPathException e) {
            LOGGER.warn("PipeDataNodeTaskBuilder failed to parse 'inclusion' and 'exclusion' parameters: {}", (Object)e.getMessage(), (Object)e);
            return;
        }
        Boolean isRealtime = connectorParameters.getBooleanByKeys(new String[]{"connector.realtime-first", "sink.realtime-first"});
        if (isRealtime == null) {
            connectorParameters.addAttribute("connector.realtime-first", "false");
            if (((Boolean)insertionDeletionListeningOptionPair.right).booleanValue()) {
                LOGGER.info("PipeDataNodeTaskBuilder: When 'inclusion' contains 'data.delete', 'realtime-first' is defaulted to 'false' to prevent sync issues after deletion.");
            } else {
                LOGGER.info("PipeDataNodeTaskBuilder: When extractor uses snapshot model, 'realtime-first' is defaulted to 'false' to prevent premature halt before transfer completion.");
            }
            return;
        }
        if (isRealtime.booleanValue()) {
            if (((Boolean)insertionDeletionListeningOptionPair.right).booleanValue()) {
                LOGGER.warn("PipeDataNodeTaskBuilder: When 'inclusion' includes 'data.delete', 'realtime-first' set to 'true' may result in data synchronization issues after deletion.");
            } else {
                LOGGER.warn("PipeDataNodeTaskBuilder: When extractor uses snapshot model, 'realtime-first' set to 'true' may cause prevent premature halt before transfer completion.");
            }
        }
    }

    static {
        CONNECTOR_EXECUTOR_MAP.put(PipeType.USER, PipeSubtaskExecutorManager.getInstance().getConnectorExecutor());
        CONNECTOR_EXECUTOR_MAP.put(PipeType.SUBSCRIPTION, PipeSubtaskExecutorManager.getInstance().getSubscriptionExecutor());
        CONNECTOR_EXECUTOR_MAP.put(PipeType.CONSENSUS, PipeSubtaskExecutorManager.getInstance().getConsensusExecutor());
    }
}

