/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.utils;

import org.apache.iotdb.rpc.TSStatusCode;

public class RetryUtils {
    public static final int MAX_RETRIES = 3;

    public static boolean needRetryForConsensus(int statusCode) {
        return statusCode == TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode() || statusCode == TSStatusCode.SYSTEM_READ_ONLY.getStatusCode() || statusCode == TSStatusCode.WRITE_PROCESS_REJECT.getStatusCode();
    }

    public static <T, E extends Exception> T retryOnException(CallableWithException<T, E> callable) throws E {
        int attempt = 0;
        while (true) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                if (++attempt < 3) continue;
                throw e;
            }
            break;
        }
    }

    private RetryUtils() {
    }

    public static interface CallableWithException<T, E extends Exception> {
        public T call() throws E;
    }
}

