/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;

public class CreateTraining
extends Statement {
    private final String modelId;
    private final String modelType;
    private Map<String, String> parameters;
    private String existingModelId = null;
    private List<QualifiedName> targetTables;
    private List<String> targetDbs;
    private List<List<Long>> targetTimeRanges;
    private boolean useAllData = false;

    public CreateTraining(String modelId, String modelType) {
        super(null);
        this.modelId = modelId;
        this.modelType = modelType;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateTraining(this, context);
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void setExistingModelId(String existingModelId) {
        this.existingModelId = existingModelId;
    }

    public void setTargetDbs(List<String> targetDbs) {
        this.targetDbs = targetDbs;
    }

    public void setTargetTables(List<QualifiedName> targetTables) {
        this.targetTables = targetTables;
    }

    public void setUseAllData(boolean useAllData) {
        this.useAllData = useAllData;
    }

    public List<String> getTargetDbs() {
        return this.targetDbs;
    }

    public List<QualifiedName> getTargetTables() {
        return this.targetTables;
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getModelType() {
        return this.modelType;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getExistingModelId() {
        return this.existingModelId;
    }

    public boolean isUseAllData() {
        return this.useAllData;
    }

    public void setTargetTimeRanges(List<List<Long>> targetTimeRanges) {
        this.targetTimeRanges = targetTimeRanges;
    }

    public List<List<Long>> getTargetTimeRanges() {
        return this.targetTimeRanges;
    }

    @Override
    public List<? extends Node> getChildren() {
        return null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.modelId, this.modelType, this.existingModelId, this.parameters, this.targetTimeRanges, this.useAllData);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CreateTraining)) {
            return false;
        }
        CreateTraining createTraining = (CreateTraining)obj;
        return this.modelId.equals(createTraining.modelId) && this.modelType.equals(createTraining.modelType) && Objects.equals(this.existingModelId, createTraining.existingModelId) && Objects.equals(this.parameters, createTraining.parameters) && Objects.equals(this.targetTimeRanges, createTraining.targetTimeRanges) && this.useAllData == createTraining.useAllData;
    }

    @Override
    public String toString() {
        return "CreateTraining{modelId='" + this.modelId + '\'' + ", modelType='" + this.modelType + '\'' + ", parameters=" + this.parameters + ", existingModelId='" + this.existingModelId + '\'' + ", targetTables=" + this.targetTables + ", targetDbs=" + this.targetDbs + ", targetTimeRanges=" + this.targetTimeRanges + ", useAllData=" + this.useAllData + '}';
    }
}

