/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.ir;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ArithmeticBinaryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BetweenPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BooleanLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FunctionCall;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IfExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IsNotNullPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IsNullPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LikePredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LogicalExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LongLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NotExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NullIfExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SearchedCaseExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SimpleCaseExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SymbolReference;
import org.apache.tsfile.utils.Pair;

public class GlobalTimePredicateExtractVisitor
extends AstVisitor<Pair<Expression, Boolean>, Context> {
    private static final String NOT_SUPPORTED = "visit() not implemented for %s in GlobalTimePredicateExtract.";

    public static Pair<Expression, Boolean> extractGlobalTimeFilter(Expression predicate, String timeColumnName) {
        return (Pair)new GlobalTimePredicateExtractVisitor().process(predicate, new Context(true, true, timeColumnName));
    }

    protected Pair<Expression, Boolean> visitExpression(Pair<Expression, Boolean> node, Context context) {
        throw new IllegalStateException(String.format(NOT_SUPPORTED, node.getClass()));
    }

    @Override
    protected Pair<Expression, Boolean> visitLogicalExpression(LogicalExpression node, Context context) {
        if (node.getOperator() == LogicalExpression.Operator.AND) {
            ArrayList<Pair<Expression, Boolean>> resultPairs = new ArrayList<Pair<Expression, Boolean>>();
            for (Expression term : node.getTerms()) {
                resultPairs.add((Pair)this.process(term, context));
            }
            ArrayList<Expression> newTimeFilterTerms = new ArrayList<Expression>();
            ArrayList<Expression> newValueFilterTerms = new ArrayList<Expression>();
            if (context.canRewrite) {
                this.getNewTimeValueExpressions(node, resultPairs, newTimeFilterTerms, newValueFilterTerms);
            }
            if (!newTimeFilterTerms.isEmpty()) {
                node.setTerms(newValueFilterTerms);
                return new Pair((Object)(newTimeFilterTerms.size() == 1 ? (Expression)newTimeFilterTerms.get(0) : new LogicalExpression(LogicalExpression.Operator.AND, newTimeFilterTerms)), (Object)(!newValueFilterTerms.isEmpty() ? 1 : 0));
            }
            return new Pair(null, (Object)true);
        }
        if (node.getOperator() == LogicalExpression.Operator.OR) {
            ArrayList<Pair<Expression, Boolean>> resultPairs = new ArrayList<Pair<Expression, Boolean>>();
            for (Expression term : node.getTerms()) {
                resultPairs.add((Pair<Expression, Boolean>)((Pair)this.process(term, new Context(false, false, context.timeColumnName))));
            }
            ArrayList newTimeFilterTerms = new ArrayList();
            ArrayList<Expression> newValueFilterTerms = new ArrayList<Expression>();
            this.getNewTimeValueExpressions(node, resultPairs, newTimeFilterTerms, newValueFilterTerms);
            if (newTimeFilterTerms.size() == node.getTerms().size()) {
                if (context.isFirstOr && newValueFilterTerms.isEmpty()) {
                    node.setTerms(Collections.singletonList(BooleanLiteral.TRUE_LITERAL));
                }
                return new Pair((Object)(newTimeFilterTerms.size() == 1 ? (Expression)newTimeFilterTerms.get(0) : new LogicalExpression(LogicalExpression.Operator.OR, newTimeFilterTerms)), (Object)(!newValueFilterTerms.isEmpty() ? 1 : 0));
            }
            return new Pair(null, (Object)true);
        }
        throw new IllegalStateException("Illegal state in visitLogicalExpression");
    }

    private void getNewTimeValueExpressions(LogicalExpression node, List<Pair<Expression, Boolean>> resultPairs, List<Expression> newTimeFilterTerms, List<Expression> newValueFilterTerms) {
        for (int i = 0; i < resultPairs.size(); ++i) {
            Pair<Expression, Boolean> pair = resultPairs.get(i);
            if (pair.left != null) {
                newTimeFilterTerms.add((Expression)pair.left);
                if (!((Boolean)pair.right).booleanValue()) continue;
                newValueFilterTerms.add(node.getTerms().get(i));
                continue;
            }
            newValueFilterTerms.add(node.getTerms().get(i));
        }
    }

    @Override
    protected Pair<Expression, Boolean> visitComparisonExpression(ComparisonExpression node, Context context) {
        Expression rightExpression;
        Expression leftExpression = node.getLeft();
        if (GlobalTimePredicateExtractVisitor.checkIsTimeFilter(leftExpression, context.timeColumnName, rightExpression = node.getRight()) || GlobalTimePredicateExtractVisitor.checkIsTimeFilter(rightExpression, context.timeColumnName, leftExpression)) {
            return new Pair((Object)node, (Object)false);
        }
        return new Pair(null, (Object)true);
    }

    @Override
    protected Pair<Expression, Boolean> visitIsNullPredicate(IsNullPredicate node, Context context) {
        return new Pair(null, (Object)true);
    }

    @Override
    protected Pair<Expression, Boolean> visitIsNotNullPredicate(IsNotNullPredicate node, Context context) {
        return new Pair(null, (Object)true);
    }

    @Override
    protected Pair<Expression, Boolean> visitFunctionCall(FunctionCall node, Context context) {
        return new Pair(null, (Object)true);
    }

    @Override
    protected Pair<Expression, Boolean> visitLikePredicate(LikePredicate node, Context context) {
        return new Pair(null, (Object)true);
    }

    @Override
    protected Pair<Expression, Boolean> visitBetweenPredicate(BetweenPredicate node, Context context) {
        Expression firstExpression = node.getValue();
        Expression secondExpression = node.getMin();
        Expression thirdExpression = node.getMax();
        boolean isTimeFilter = false;
        if (GlobalTimePredicateExtractVisitor.isTimeColumn(firstExpression, context.timeColumnName)) {
            isTimeFilter = GlobalTimePredicateExtractVisitor.checkBetweenConstantSatisfy(secondExpression, thirdExpression);
        }
        if (isTimeFilter) {
            return new Pair((Object)node, (Object)false);
        }
        return new Pair(null, (Object)true);
    }

    @Override
    protected Pair<Expression, Boolean> visitInPredicate(InPredicate node, Context context) {
        if (GlobalTimePredicateExtractVisitor.isTimeColumn(node.getValue(), context.timeColumnName)) {
            return new Pair((Object)node, (Object)false);
        }
        return new Pair(null, (Object)true);
    }

    @Override
    protected Pair<Expression, Boolean> visitNotExpression(NotExpression node, Context context) {
        Pair result = (Pair)this.process(node.getValue(), new Context(context.canRewrite, context.isFirstOr, context.timeColumnName));
        if (result.left != null) {
            return new Pair((Object)new NotExpression((Expression)result.left), (Object)((Boolean)result.right));
        }
        return new Pair(null, (Object)true);
    }

    @Override
    protected Pair<Expression, Boolean> visitArithmeticBinary(ArithmeticBinaryExpression node, Context context) {
        throw new IllegalStateException(String.format(NOT_SUPPORTED, node.getClass()));
    }

    @Override
    protected Pair<Expression, Boolean> visitSimpleCaseExpression(SimpleCaseExpression node, Context context) {
        throw new IllegalStateException(String.format(NOT_SUPPORTED, node.getClass()));
    }

    @Override
    protected Pair<Expression, Boolean> visitSearchedCaseExpression(SearchedCaseExpression node, Context context) {
        throw new IllegalStateException(String.format(NOT_SUPPORTED, node.getClass()));
    }

    @Override
    protected Pair<Expression, Boolean> visitIfExpression(IfExpression node, Context context) {
        throw new IllegalStateException(String.format(NOT_SUPPORTED, node.getClass()));
    }

    @Override
    protected Pair<Expression, Boolean> visitNullIfExpression(NullIfExpression node, Context context) {
        throw new IllegalStateException(String.format(NOT_SUPPORTED, node.getClass()));
    }

    public static boolean isTimeColumn(Expression e, String timeColumnName) {
        return e instanceof SymbolReference && ((SymbolReference)e).getName().equalsIgnoreCase(timeColumnName);
    }

    private static boolean checkIsTimeFilter(Expression timeExpression, String timeColumnName, Expression valueExpression) {
        return GlobalTimePredicateExtractVisitor.isTimeColumn(timeExpression, timeColumnName) && valueExpression instanceof LongLiteral;
    }

    private static boolean checkBetweenConstantSatisfy(Expression e1, Expression e2) {
        return e1 instanceof LongLiteral && e2 instanceof LongLiteral && ((LongLiteral)e1).getParsedValue() <= ((LongLiteral)e2).getParsedValue();
    }

    public static class Context {
        boolean canRewrite;
        boolean isFirstOr;
        String timeColumnName;

        public Context(boolean canRewrite, boolean isFirstOr, String timeColumnName) {
            this.canRewrite = canRewrite;
            this.isFirstOr = isFirstOr;
            this.timeColumnName = timeColumnName;
        }
    }
}

