/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.window.function.value;

import org.apache.iotdb.db.queryengine.execution.operator.process.window.function.value.ValueWindowFunction;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.Partition;
import org.apache.tsfile.block.column.ColumnBuilder;

public class LeadFunction
extends ValueWindowFunction {
    private final int channel;
    private final Integer offset;
    private final Integer defaultVal;
    private final boolean ignoreNull;

    public LeadFunction(int channel, Integer offset, Integer defaultVal, boolean ignoreNull) {
        this.channel = channel;
        this.offset = offset == null ? 1 : offset;
        this.defaultVal = defaultVal;
        this.ignoreNull = ignoreNull;
    }

    @Override
    public void transform(Partition partition, ColumnBuilder builder, int index, int frameStart, int frameEnd) {
        int pos;
        int length = partition.getPositionCount();
        if (this.ignoreNull) {
            int nonNullCount = 0;
            for (pos = index + 1; pos < length && (partition.isNull(this.channel, pos) || ++nonNullCount != this.offset); ++pos) {
            }
        } else {
            pos = index + this.offset;
        }
        if (pos < length) {
            if (!partition.isNull(this.channel, pos)) {
                partition.writeTo(builder, this.channel, pos);
            } else {
                builder.appendNull();
            }
        } else if (this.defaultVal != null) {
            builder.writeObject((Object)this.defaultVal);
        } else {
            builder.appendNull();
        }
    }

    @Override
    public boolean needFrame() {
        return false;
    }
}

