/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin;

import java.io.IOException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.udf.builtin.UDTFEqualSizeBucketSample;
import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.udf.api.access.RowWindow;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingSizeWindowAccessStrategy;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.exception.UDFInputSeriesDataTypeNotValidException;
import org.apache.iotdb.udf.api.exception.UDFParameterNotValidException;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.tsfile.enums.TSDataType;

public class UDTFEqualSizeBucketAggSample
extends UDTFEqualSizeBucketSample {
    private String aggMethodType;
    private Aggregator aggregator;

    @Override
    public void validate(UDFParameterValidator validator) throws MetadataException, UDFException {
        super.validate(validator);
        this.aggMethodType = validator.getParameters().getStringOrDefault("type", "avg").toLowerCase();
        validator.validate(type -> "avg".equals(type) || "max".equals(type) || "min".equals(type) || "sum".equals(type) || "extreme".equals(type) || "variance".equals(type), "Illegal aggregation method. Aggregation type should be avg, min, max, sum, extreme, variance.", (Object)this.aggMethodType);
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws UDFParameterNotValidException {
        TSDataType outputDataType = this.dataType;
        if ("avg".equals(this.aggMethodType) || "variance".equals(this.aggMethodType)) {
            outputDataType = TSDataType.DOUBLE;
        }
        configurations.setAccessStrategy((AccessStrategy)new SlidingSizeWindowAccessStrategy(this.bucketSize)).setOutputDataType(UDFDataTypeTransformer.transformToUDFDataType(outputDataType));
        switch (this.aggMethodType) {
            case "avg": {
                this.aggregator = new AvgAggregator();
                break;
            }
            case "min": {
                this.aggregator = new MinAggregator();
                break;
            }
            case "max": {
                this.aggregator = new MaxAggregator();
                break;
            }
            case "sum": {
                this.aggregator = new SumAggregator();
                break;
            }
            case "extreme": {
                this.aggregator = new ExtremeAggregator();
                break;
            }
            case "variance": {
                this.aggregator = new VarianceAggregator();
                break;
            }
            default: {
                throw new UDFParameterNotValidException("Illegal aggregation method. Aggregation type should be avg, min, max, sum, extreme, variance.");
            }
        }
    }

    public void transform(RowWindow rowWindow, PointCollector collector) throws IOException, UDFParameterNotValidException {
        switch (this.dataType) {
            case INT32: {
                this.aggregator.aggregateInt(rowWindow, collector);
                break;
            }
            case INT64: {
                this.aggregator.aggregateLong(rowWindow, collector);
                break;
            }
            case FLOAT: {
                this.aggregator.aggregateFloat(rowWindow, collector);
                break;
            }
            case DOUBLE: {
                this.aggregator.aggregateDouble(rowWindow, collector);
                break;
            }
            default: {
                throw new UDFInputSeriesDataTypeNotValidException(0, UDFDataTypeTransformer.transformToUDFDataType(this.dataType), new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE});
            }
        }
    }

    private static class AvgAggregator
    implements Aggregator {
        private AvgAggregator() {
        }

        @Override
        public void aggregateInt(RowWindow rowWindow, PointCollector collector) throws IOException {
            long time = rowWindow.getRow(0).getTime();
            int windowSize = rowWindow.windowSize();
            double sum = 0.0;
            for (int i = 0; i < windowSize; ++i) {
                sum += (double)rowWindow.getRow(i).getInt(0);
            }
            collector.putDouble(time, sum / (double)windowSize);
        }

        @Override
        public void aggregateLong(RowWindow rowWindow, PointCollector collector) throws IOException {
            long time = rowWindow.getRow(0).getTime();
            int windowSize = rowWindow.windowSize();
            double sum = 0.0;
            for (int i = 0; i < windowSize; ++i) {
                sum += (double)rowWindow.getRow(i).getLong(0);
            }
            collector.putDouble(time, sum / (double)windowSize);
        }

        @Override
        public void aggregateFloat(RowWindow rowWindow, PointCollector collector) throws IOException {
            long time = rowWindow.getRow(0).getTime();
            int windowSize = rowWindow.windowSize();
            double sum = 0.0;
            for (int i = 0; i < windowSize; ++i) {
                sum += (double)rowWindow.getRow(i).getFloat(0);
            }
            collector.putDouble(time, sum / (double)windowSize);
        }

        @Override
        public void aggregateDouble(RowWindow rowWindow, PointCollector collector) throws IOException {
            long time = rowWindow.getRow(0).getTime();
            int windowSize = rowWindow.windowSize();
            double sum = 0.0;
            for (int i = 0; i < windowSize; ++i) {
                sum += rowWindow.getRow(i).getDouble(0);
            }
            collector.putDouble(time, sum / (double)windowSize);
        }
    }

    private static interface Aggregator {
        public void aggregateInt(RowWindow var1, PointCollector var2) throws IOException;

        public void aggregateLong(RowWindow var1, PointCollector var2) throws IOException;

        public void aggregateFloat(RowWindow var1, PointCollector var2) throws IOException;

        public void aggregateDouble(RowWindow var1, PointCollector var2) throws IOException;
    }

    private static class MinAggregator
    implements Aggregator {
        private MinAggregator() {
        }

        @Override
        public void aggregateInt(RowWindow rowWindow, PointCollector collector) throws IOException {
            long time = rowWindow.getRow(0).getTime();
            int windowSize = rowWindow.windowSize();
            int minValue = rowWindow.getRow(0).getInt(0);
            for (int i = 1; i < windowSize; ++i) {
                int value = rowWindow.getRow(i).getInt(0);
                if (minValue <= value) continue;
                minValue = value;
            }
            collector.putInt(time, minValue);
        }

        @Override
        public void aggregateLong(RowWindow rowWindow, PointCollector collector) throws IOException {
            long time = rowWindow.getRow(0).getTime();
            int windowSize = rowWindow.windowSize();
            long minValue = rowWindow.getRow(0).getLong(0);
            for (int i = 1; i < windowSize; ++i) {
                long value = rowWindow.getRow(i).getLong(0);
                if (minValue <= value) continue;
                minValue = value;
            }
            collector.putLong(time, minValue);
        }

        @Override
        public void aggregateFloat(RowWindow rowWindow, PointCollector collector) throws IOException {
            long time = rowWindow.getRow(0).getTime();
            int windowSize = rowWindow.windowSize();
            float minValue = rowWindow.getRow(0).getFloat(0);
            for (int i = 1; i < windowSize; ++i) {
                float value = rowWindow.getRow(i).getFloat(0);
                if (!(minValue > value)) continue;
                minValue = value;
            }
            collector.putFloat(time, minValue);
        }

        @Override
        public void aggregateDouble(RowWindow rowWindow, PointCollector collector) throws IOException {
            long time = rowWindow.getRow(0).getTime();
            int windowSize = rowWindow.windowSize();
            double minValue = rowWindow.getRow(0).getDouble(0);
            for (int i = 1; i < windowSize; ++i) {
                double value = rowWindow.getRow(i).getDouble(0);
                if (!(minValue > value)) continue;
                minValue = value;
            }
            collector.putDouble(time, minValue);
        }
    }

    private static class MaxAggregator
    implements Aggregator {
        private MaxAggregator() {
        }

        @Override
        public void aggregateInt(RowWindow rowWindow, PointCollector collector) throws IOException {
            long time = rowWindow.getRow(0).getTime();
            int windowSize = rowWindow.windowSize();
            int maxValue = rowWindow.getRow(0).getInt(0);
            for (int i = 1; i < windowSize; ++i) {
                int value = rowWindow.getRow(i).getInt(0);
                if (maxValue >= value) continue;
                maxValue = value;
            }
            collector.putInt(time, maxValue);
        }

        @Override
        public void aggregateLong(RowWindow rowWindow, PointCollector collector) throws IOException {
            long time = rowWindow.getRow(0).getTime();
            int windowSize = rowWindow.windowSize();
            long maxValue = rowWindow.getRow(0).getLong(0);
            for (int i = 1; i < windowSize; ++i) {
                long value = rowWindow.getRow(i).getLong(0);
                if (maxValue >= value) continue;
                maxValue = value;
            }
            collector.putLong(time, maxValue);
        }

        @Override
        public void aggregateFloat(RowWindow rowWindow, PointCollector collector) throws IOException {
            long time = rowWindow.getRow(0).getTime();
            int windowSize = rowWindow.windowSize();
            float maxValue = rowWindow.getRow(0).getFloat(0);
            for (int i = 1; i < windowSize; ++i) {
                float value = rowWindow.getRow(i).getFloat(0);
                if (!(maxValue < value)) continue;
                maxValue = value;
            }
            collector.putFloat(time, maxValue);
        }

        @Override
        public void aggregateDouble(RowWindow rowWindow, PointCollector collector) throws IOException {
            long time = rowWindow.getRow(0).getTime();
            int windowSize = rowWindow.windowSize();
            double maxValue = rowWindow.getRow(0).getDouble(0);
            for (int i = 1; i < windowSize; ++i) {
                double value = rowWindow.getRow(i).getDouble(0);
                if (!(maxValue < value)) continue;
                maxValue = value;
            }
            collector.putDouble(time, maxValue);
        }
    }

    private static class SumAggregator
    implements Aggregator {
        private SumAggregator() {
        }

        @Override
        public void aggregateInt(RowWindow rowWindow, PointCollector collector) throws IOException {
            long time = rowWindow.getRow(0).getTime();
            int windowSize = rowWindow.windowSize();
            int sum = 0;
            for (int i = 0; i < windowSize; ++i) {
                sum += rowWindow.getRow(i).getInt(0);
            }
            collector.putInt(time, sum);
        }

        @Override
        public void aggregateLong(RowWindow rowWindow, PointCollector collector) throws IOException {
            long time = rowWindow.getRow(0).getTime();
            int windowSize = rowWindow.windowSize();
            long sum = 0L;
            for (int i = 0; i < windowSize; ++i) {
                sum += rowWindow.getRow(i).getLong(0);
            }
            collector.putLong(time, sum);
        }

        @Override
        public void aggregateFloat(RowWindow rowWindow, PointCollector collector) throws IOException {
            long time = rowWindow.getRow(0).getTime();
            int windowSize = rowWindow.windowSize();
            float sum = 0.0f;
            for (int i = 0; i < windowSize; ++i) {
                sum += rowWindow.getRow(i).getFloat(0);
            }
            collector.putFloat(time, sum);
        }

        @Override
        public void aggregateDouble(RowWindow rowWindow, PointCollector collector) throws IOException {
            long time = rowWindow.getRow(0).getTime();
            int windowSize = rowWindow.windowSize();
            double sum = 0.0;
            for (int i = 0; i < windowSize; ++i) {
                sum += rowWindow.getRow(i).getDouble(0);
            }
            collector.putDouble(time, sum);
        }
    }

    private static class ExtremeAggregator
    implements Aggregator {
        private ExtremeAggregator() {
        }

        @Override
        public void aggregateInt(RowWindow rowWindow, PointCollector collector) throws IOException {
            long time = rowWindow.getRow(0).getTime();
            int windowSize = rowWindow.windowSize();
            int extreme = 0;
            for (int i = 0; i < windowSize; ++i) {
                int value;
                int origin = rowWindow.getRow(i).getInt(0);
                int n = value = origin > 0 ? origin : -origin;
                if (extreme >= value) continue;
                extreme = origin;
            }
            collector.putInt(time, extreme);
        }

        @Override
        public void aggregateLong(RowWindow rowWindow, PointCollector collector) throws IOException {
            long time = rowWindow.getRow(0).getTime();
            int windowSize = rowWindow.windowSize();
            long extreme = 0L;
            for (int i = 0; i < windowSize; ++i) {
                long value;
                long origin = rowWindow.getRow(i).getLong(0);
                long l = value = origin > 0L ? origin : -origin;
                if (extreme >= value) continue;
                extreme = origin;
            }
            collector.putLong(time, extreme);
        }

        @Override
        public void aggregateFloat(RowWindow rowWindow, PointCollector collector) throws IOException {
            long time = rowWindow.getRow(0).getTime();
            int windowSize = rowWindow.windowSize();
            float extreme = 0.0f;
            for (int i = 0; i < windowSize; ++i) {
                float value;
                float origin = rowWindow.getRow(i).getFloat(0);
                float f = value = origin > 0.0f ? origin : -origin;
                if (!(extreme < value)) continue;
                extreme = origin;
            }
            collector.putFloat(time, extreme);
        }

        @Override
        public void aggregateDouble(RowWindow rowWindow, PointCollector collector) throws IOException {
            long time = rowWindow.getRow(0).getTime();
            int windowSize = rowWindow.windowSize();
            double extreme = 0.0;
            for (int i = 0; i < windowSize; ++i) {
                double value;
                double origin = rowWindow.getRow(i).getDouble(0);
                double d = value = origin > 0.0 ? origin : -origin;
                if (!(extreme < value)) continue;
                extreme = origin;
            }
            collector.putDouble(time, extreme);
        }
    }

    private static class VarianceAggregator
    implements Aggregator {
        private VarianceAggregator() {
        }

        @Override
        public void aggregateInt(RowWindow rowWindow, PointCollector collector) throws IOException {
            int i;
            long time = rowWindow.getRow(0).getTime();
            int windowSize = rowWindow.windowSize();
            double avg = 0.0;
            double sum = 0.0;
            for (i = 0; i < windowSize; ++i) {
                avg += (double)rowWindow.getRow(i).getInt(0);
            }
            avg /= (double)windowSize;
            for (i = 0; i < windowSize; ++i) {
                double delta = (double)rowWindow.getRow(i).getInt(0) - avg;
                sum += delta * delta;
            }
            collector.putDouble(time, sum / (double)windowSize);
        }

        @Override
        public void aggregateLong(RowWindow rowWindow, PointCollector collector) throws IOException {
            int i;
            long time = rowWindow.getRow(0).getTime();
            int windowSize = rowWindow.windowSize();
            double avg = 0.0;
            double sum = 0.0;
            for (i = 0; i < windowSize; ++i) {
                avg += (double)rowWindow.getRow(i).getLong(0);
            }
            avg /= (double)windowSize;
            for (i = 0; i < windowSize; ++i) {
                double delta = (double)rowWindow.getRow(i).getLong(0) - avg;
                sum += delta * delta;
            }
            collector.putDouble(time, sum / (double)windowSize);
        }

        @Override
        public void aggregateFloat(RowWindow rowWindow, PointCollector collector) throws IOException {
            int i;
            long time = rowWindow.getRow(0).getTime();
            int windowSize = rowWindow.windowSize();
            double avg = 0.0;
            double sum = 0.0;
            for (i = 0; i < windowSize; ++i) {
                avg += (double)rowWindow.getRow(i).getFloat(0);
            }
            avg /= (double)windowSize;
            for (i = 0; i < windowSize; ++i) {
                double delta = (double)rowWindow.getRow(i).getFloat(0) - avg;
                sum += delta * delta;
            }
            collector.putDouble(time, sum / (double)windowSize);
        }

        @Override
        public void aggregateDouble(RowWindow rowWindow, PointCollector collector) throws IOException {
            int i;
            long time = rowWindow.getRow(0).getTime();
            int windowSize = rowWindow.windowSize();
            double avg = 0.0;
            double sum = 0.0;
            for (i = 0; i < windowSize; ++i) {
                avg += rowWindow.getRow(i).getDouble(0);
            }
            avg /= (double)windowSize;
            for (i = 0; i < windowSize; ++i) {
                double delta = rowWindow.getRow(i).getDouble(0) - avg;
                sum += delta * delta;
            }
            collector.putDouble(time, sum / (double)windowSize);
        }
    }
}

