/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.WeakValueCache;

public abstract class RaftId {
    static final UUID ZERO_UUID = new UUID(0L, 0L);
    static final ByteString ZERO_UUID_BYTESTRING = RaftId.toByteString(ZERO_UUID);
    private static final int BYTE_LENGTH = 16;
    private final UUID uuid;
    private final Supplier<ByteString> uuidBytes;
    private final Supplier<String> uuidString;

    static UUID toUuid(ByteString bytes) {
        Objects.requireNonNull(bytes, "bytes == null");
        Preconditions.assertSame(16, bytes.size(), "bytes.size()");
        ByteBuffer buf = bytes.asReadOnlyByteBuffer();
        return new UUID(buf.getLong(), buf.getLong());
    }

    static ByteString toByteString(UUID uuid) {
        Objects.requireNonNull(uuid, "uuid == null");
        byte[] array = new byte[16];
        ByteBuffer.wrap(array).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits());
        return UnsafeByteOperations.unsafeWrap((byte[])array);
    }

    RaftId(UUID uuid) {
        this.uuid = Preconditions.assertNotNull(uuid, "uuid");
        this.uuidBytes = JavaUtils.memoize(() -> RaftId.toByteString(uuid));
        this.uuidString = JavaUtils.memoize(() -> this.createUuidString(uuid));
        Preconditions.assertTrue(ZERO_UUID == uuid || !uuid.equals(ZERO_UUID), () -> "Failed to create " + JavaUtils.getClassSimpleName(this.getClass()) + ": UUID " + ZERO_UUID + " is reserved.");
    }

    String createUuidString(UUID id) {
        String s = id.toString().toUpperCase();
        int i = s.lastIndexOf(45);
        return s.substring(i + 1);
    }

    public ByteString toByteString() {
        return this.uuidBytes.get();
    }

    public String toString() {
        return this.uuidString.get();
    }

    public boolean equals(Object other) {
        return other == this || other instanceof RaftId && this.getClass() == other.getClass() && this.uuid.equals(((RaftId)other).uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    static abstract class Factory<ID extends RaftId> {
        private final WeakValueCache<UUID, ID> cache;

        Factory(Class<ID> clazz) {
            this.cache = new WeakValueCache<UUID, RaftId>(clazz.getSimpleName() + "_UUID", this::newInstance);
        }

        abstract ID newInstance(UUID var1);

        WeakValueCache<UUID, ID> getCache() {
            return this.cache;
        }

        final ID valueOf(UUID uuid) {
            return (ID)((RaftId)this.cache.getOrCreate(uuid));
        }

        final ID valueOf(ByteString bytes) {
            return bytes != null ? this.valueOf(RaftId.toUuid(bytes)) : this.emptyId();
        }

        ID emptyId() {
            return this.valueOf(ZERO_UUID);
        }

        ID randomId() {
            return this.valueOf(UUID.randomUUID());
        }
    }
}

