/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata.view;

import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.statement.IConfigStatement;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.rpc.TSStatusCode;

public class DeleteLogicalViewStatement
extends Statement
implements IConfigStatement {
    List<PartialPath> pathPatternList;

    public DeleteLogicalViewStatement() {
        this.statementType = StatementType.DELETE_LOGICAL_VIEW;
    }

    public DeleteLogicalViewStatement(List<PartialPath> pathPatternList) {
        this();
        this.pathPatternList = pathPatternList;
    }

    public List<PartialPath> getPaths() {
        return this.pathPatternList;
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        if (AuthorityChecker.SUPER_USER.equals(userName)) {
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        List<PartialPath> checkedPaths = this.getPaths();
        return AuthorityChecker.getTSStatus(AuthorityChecker.checkPatternPermission(userName, checkedPaths, PrivilegeType.WRITE_SCHEMA), checkedPaths, PrivilegeType.WRITE_SCHEMA);
    }

    public List<PartialPath> getPathPatternList() {
        return this.pathPatternList;
    }

    public void setPathPatternList(List<PartialPath> pathPatternList) {
        this.pathPatternList = pathPatternList;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitDeleteLogicalView(this, context);
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }
}

