/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.common.block.column;

import java.util.Arrays;
import java.util.Optional;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnEncoding;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.column.ColumnUtil;
import org.apache.tsfile.read.common.block.column.DictionaryColumn;
import org.apache.tsfile.read.common.block.column.DictionaryId;
import org.apache.tsfile.utils.Accountable;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.TsPrimitiveType;

public class BinaryColumn
implements Column {
    private static final int INSTANCE_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(BinaryColumn.class);
    private final int arrayOffset;
    private int positionCount;
    private boolean[] valueIsNull;
    private final Binary[] values;
    private final long retainedSizeInBytes;
    private final long sizeInBytes;

    public BinaryColumn(int initialCapacity) {
        this(0, 0, null, new Binary[initialCapacity]);
    }

    public BinaryColumn(int positionCount, Optional<boolean[]> valueIsNull, Binary[] values) {
        this(0, positionCount, valueIsNull.orElse(null), values);
    }

    BinaryColumn(int arrayOffset, int positionCount, boolean[] valueIsNull, Binary[] values) {
        if (arrayOffset < 0) {
            throw new IllegalArgumentException("arrayOffset is negative");
        }
        this.arrayOffset = arrayOffset;
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        if (values.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("values length is less than positionCount");
        }
        this.values = values;
        if (valueIsNull != null && valueIsNull.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("isNull length is less than positionCount");
        }
        this.valueIsNull = valueIsNull;
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + RamUsageEstimator.sizeOfBooleanArray((int)positionCount) + RamUsageEstimator.sizeOf((Accountable[])values);
        this.sizeInBytes = values.length > 0 ? this.retainedSizeInBytes * (long)positionCount / (long)values.length : 0L;
    }

    private BinaryColumn(int arrayOffset, int positionCount, boolean[] valueIsNull, Binary[] values, long retainedSizeInBytes) {
        if (arrayOffset < 0) {
            throw new IllegalArgumentException("arrayOffset is negative");
        }
        this.arrayOffset = arrayOffset;
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        if (values.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("values length is less than positionCount");
        }
        this.values = values;
        if (valueIsNull != null && valueIsNull.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("isNull length is less than positionCount");
        }
        this.valueIsNull = valueIsNull;
        this.retainedSizeInBytes = retainedSizeInBytes;
        this.sizeInBytes = values.length > 0 ? retainedSizeInBytes * (long)positionCount / (long)values.length : 0L;
    }

    public TSDataType getDataType() {
        return TSDataType.TEXT;
    }

    public ColumnEncoding getEncoding() {
        return ColumnEncoding.BINARY_ARRAY;
    }

    public Binary getBinary(int position) {
        return this.values[position + this.arrayOffset];
    }

    public Binary[] getBinaries() {
        return this.values;
    }

    public Object getObject(int position) {
        return this.getBinary(position);
    }

    public TsPrimitiveType getTsPrimitiveType(int position) {
        return new TsPrimitiveType.TsBinary(this.getBinary(position));
    }

    public boolean mayHaveNull() {
        return this.valueIsNull != null;
    }

    public boolean isNull(int position) {
        return this.values[position + this.arrayOffset] == null || this.valueIsNull != null && this.valueIsNull[position + this.arrayOffset];
    }

    public boolean[] isNull() {
        if (this.valueIsNull == null) {
            boolean[] res = new boolean[this.positionCount];
            Arrays.fill(res, false);
            return res;
        }
        return this.valueIsNull;
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public Column getRegion(int positionOffset, int length) {
        ColumnUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        return new BinaryColumn(positionOffset + this.arrayOffset, length, this.valueIsNull, this.values, this.getRetainedSizeInBytes());
    }

    public Column getRegionCopy(int positionOffset, int length) {
        ColumnUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        int from = positionOffset + this.arrayOffset;
        int to = from + length;
        boolean[] valueIsNullCopy = this.valueIsNull != null ? Arrays.copyOfRange(this.valueIsNull, from, to) : null;
        Binary[] valuesCopy = Arrays.copyOfRange(this.values, from, to);
        return new BinaryColumn(0, length, valueIsNullCopy, valuesCopy);
    }

    public Column subColumn(int fromIndex) {
        if (fromIndex > this.positionCount) {
            throw new IllegalArgumentException("fromIndex is not valid");
        }
        return new BinaryColumn(this.arrayOffset + fromIndex, this.positionCount - fromIndex, this.valueIsNull, this.values);
    }

    public Column subColumnCopy(int fromIndex) {
        if (fromIndex > this.positionCount) {
            throw new IllegalArgumentException("fromIndex is not valid");
        }
        int from = this.arrayOffset + fromIndex;
        boolean[] valueIsNullCopy = this.valueIsNull != null ? Arrays.copyOfRange(this.valueIsNull, from, this.positionCount) : null;
        Binary[] valuesCopy = Arrays.copyOfRange(this.values, from, this.positionCount);
        int length = this.positionCount - fromIndex;
        return new BinaryColumn(0, length, valueIsNullCopy, valuesCopy);
    }

    public void reverse() {
        int j;
        int i = this.arrayOffset;
        for (j = this.arrayOffset + this.positionCount - 1; i < j; ++i, --j) {
            Binary valueTmp = this.values[i];
            this.values[i] = this.values[j];
            this.values[j] = valueTmp;
        }
        if (this.valueIsNull != null) {
            i = this.arrayOffset;
            for (j = this.arrayOffset + this.positionCount - 1; i < j; ++i, --j) {
                boolean isNullTmp = this.valueIsNull[i];
                this.valueIsNull[i] = this.valueIsNull[j];
                this.valueIsNull[j] = isNullTmp;
            }
        }
    }

    public Column getPositions(int[] positions, int offset, int length) {
        ColumnUtil.checkArrayRange(positions, offset, length);
        return DictionaryColumn.createInternal(offset, length, this, positions, DictionaryId.randomDictionaryId());
    }

    public Column copyPositions(int[] positions, int offset, int length) {
        ColumnUtil.checkArrayRange(positions, offset, length);
        boolean[] newValueIsNull = null;
        if (this.valueIsNull != null) {
            newValueIsNull = new boolean[length];
        }
        Binary[] newValues = new Binary[length];
        for (int i = 0; i < length; ++i) {
            int position = positions[offset + i];
            ColumnUtil.checkReadablePosition(this, position);
            if (newValueIsNull != null) {
                newValueIsNull[i] = this.valueIsNull[position + this.arrayOffset];
            }
            newValues[i] = this.values[position + this.arrayOffset];
        }
        return new BinaryColumn(0, length, newValueIsNull, newValues);
    }

    public int getInstanceSize() {
        return INSTANCE_SIZE;
    }

    public void setPositionCount(int count) {
        this.positionCount = count;
    }

    public void setNull(int start, int end) {
        if (this.valueIsNull == null) {
            this.valueIsNull = new boolean[this.values.length];
        }
        Arrays.fill(this.valueIsNull, start, end, true);
    }
}

