/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf;

import org.apache.iotdb.commons.conf.ConfigurationFileUtils;
import org.apache.iotdb.commons.conf.TrimProperties;
import org.apache.iotdb.commons.memory.MemoryConfig;
import org.apache.iotdb.commons.memory.MemoryManager;
import org.apache.iotdb.db.utils.MemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataNodeMemoryConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataNodeMemoryConfig.class);
    private double rejectProportion = 0.8;
    private double walBufferQueueProportion = 0.1;
    private double devicePathCacheProportion = 0.05;
    private double maxDirectBufferOffHeapMemorySizeProportion = 0.8;
    private double bufferedArraysMemoryProportion = 0.6;
    private boolean enableQueryMemoryEstimation = true;
    private boolean metaDataCacheEnable = true;
    private int queryThreadCount = Runtime.getRuntime().availableProcessors();
    private long maxBytesPerFragmentInstance = Runtime.getRuntime().maxMemory() * 3L / 10L * 200L / 1001L / (long)this.queryThreadCount;
    private MemoryManager onHeapMemoryManager;
    private MemoryManager storageEngineMemoryManager;
    private MemoryManager writeMemoryManager;
    private MemoryManager memtableMemoryManager;
    private MemoryManager walBufferQueueMemoryManager;
    private MemoryManager devicePathCacheMemoryManager;
    private MemoryManager bufferedArraysMemoryManager;
    private MemoryManager timePartitionInfoMemoryManager;
    private MemoryManager compactionMemoryManager;
    private MemoryManager queryEngineMemoryManager;
    private MemoryManager bloomFilterCacheMemoryManager;
    private MemoryManager timeSeriesMetaDataCacheMemoryManager;
    private MemoryManager chunkCacheMemoryManager;
    private MemoryManager coordinatorMemoryManager;
    private MemoryManager operatorsMemoryManager;
    private MemoryManager dataExchangeMemoryManager;
    private MemoryManager timeIndexMemoryManager;
    private MemoryManager schemaEngineMemoryManager;
    private MemoryManager schemaRegionMemoryManager;
    private MemoryManager schemaCacheMemoryManager;
    private MemoryManager partitionCacheMemoryManager;
    private MemoryManager consensusMemoryManager;
    private MemoryManager pipeMemoryManager;
    private MemoryManager offHeapMemoryManager;
    private MemoryManager directBufferMemoryManager;

    public void init(TrimProperties properties) {
        String memoryAllocateProportion = properties.getProperty("datanode_memory_proportion", null);
        if (memoryAllocateProportion == null && (memoryAllocateProportion = properties.getProperty("storage_query_schema_consensus_free_memory_proportion")) != null) {
            LOGGER.warn("The parameter storage_query_schema_consensus_free_memory_proportion is deprecated since v1.2.3, please use datanode_memory_proportion instead.");
        }
        long storageEngineMemorySize = Runtime.getRuntime().maxMemory() * 3L / 10L;
        long queryEngineMemorySize = Runtime.getRuntime().maxMemory() * 3L / 10L;
        long schemaEngineMemorySize = Runtime.getRuntime().maxMemory() / 10L;
        long consensusMemorySize = Runtime.getRuntime().maxMemory() / 10L;
        long pipeMemorySize = Runtime.getRuntime().maxMemory() / 10L;
        if (memoryAllocateProportion != null) {
            String[] proportions = memoryAllocateProportion.split(":");
            int proportionSum = 0;
            for (String proportion : proportions) {
                proportionSum += Integer.parseInt(proportion.trim());
            }
            long maxMemoryAvailable = Runtime.getRuntime().maxMemory();
            if (proportionSum != 0) {
                storageEngineMemorySize = maxMemoryAvailable * (long)Integer.parseInt(proportions[0].trim()) / (long)proportionSum;
                queryEngineMemorySize = maxMemoryAvailable * (long)Integer.parseInt(proportions[1].trim()) / (long)proportionSum;
                schemaEngineMemorySize = maxMemoryAvailable * (long)Integer.parseInt(proportions[2].trim()) / (long)proportionSum;
                consensusMemorySize = maxMemoryAvailable * (long)Integer.parseInt(proportions[3].trim()) / (long)proportionSum;
                pipeMemorySize = proportions.length >= 6 ? maxMemoryAvailable * (long)Integer.parseInt(proportions[4].trim()) / (long)proportionSum : (maxMemoryAvailable - storageEngineMemorySize + queryEngineMemorySize + schemaEngineMemorySize + consensusMemorySize) / 2L;
            }
        }
        this.onHeapMemoryManager = MemoryConfig.global().getOrCreateMemoryManager("OnHeap", Runtime.getRuntime().maxMemory());
        this.storageEngineMemoryManager = this.onHeapMemoryManager.getOrCreateMemoryManager("StorageEngine", storageEngineMemorySize);
        this.queryEngineMemoryManager = this.onHeapMemoryManager.getOrCreateMemoryManager("QueryEngine", queryEngineMemorySize);
        this.schemaEngineMemoryManager = this.onHeapMemoryManager.getOrCreateMemoryManager("SchemaEngine", schemaEngineMemorySize);
        this.consensusMemoryManager = this.onHeapMemoryManager.getOrCreateMemoryManager("Consensus", consensusMemorySize);
        this.pipeMemoryManager = this.onHeapMemoryManager.getOrCreateMemoryManager("Pipe", pipeMemorySize);
        LOGGER.info("initial allocateMemoryForWrite = {}", (Object)this.storageEngineMemoryManager.getTotalMemorySizeInBytes());
        LOGGER.info("initial allocateMemoryForRead = {}", (Object)this.queryEngineMemoryManager.getTotalMemorySizeInBytes());
        LOGGER.info("initial allocateMemoryForSchema = {}", (Object)this.schemaEngineMemoryManager.getTotalMemorySizeInBytes());
        LOGGER.info("initial allocateMemoryForConsensus = {}", (Object)this.consensusMemoryManager.getTotalMemorySizeInBytes());
        LOGGER.info("initial allocateMemoryForPipe = {}", (Object)this.pipeMemoryManager.getTotalMemorySizeInBytes());
        this.initSchemaMemoryAllocate(this.schemaEngineMemoryManager, properties);
        this.initStorageEngineAllocate(this.storageEngineMemoryManager, properties);
        this.initQueryEngineMemoryAllocate(this.queryEngineMemoryManager, properties);
        String offHeapMemoryStr = System.getProperty("OFF_HEAP_MEMORY");
        this.offHeapMemoryManager = MemoryConfig.global().getOrCreateMemoryManager("OffHeap", MemUtils.strToBytesCnt(offHeapMemoryStr), false);
        long totalDirectBufferMemorySizeLimit = this.offHeapMemoryManager.getTotalMemorySizeInBytes() == 0L ? Long.MAX_VALUE : (long)((double)this.offHeapMemoryManager.getTotalMemorySizeInBytes() * this.getMaxDirectBufferOffHeapMemorySizeProportion());
        this.directBufferMemoryManager = this.offHeapMemoryManager.getOrCreateMemoryManager("DirectBuffer", totalDirectBufferMemorySizeLimit);
    }

    private void initSchemaMemoryAllocate(MemoryManager schemaEngineMemoryManager, TrimProperties properties) {
        long schemaMemoryTotal = schemaEngineMemoryManager.getTotalMemorySizeInBytes();
        int[] schemaMemoryProportion = new int[]{5, 4, 1};
        String schemaMemoryPortionInput = properties.getProperty("schema_memory_proportion", properties.getProperty("schema_memory_allocate_proportion"));
        if (schemaMemoryPortionInput != null) {
            String[] proportions = schemaMemoryPortionInput.split(":");
            int loadedProportionSum = 0;
            String[] stringArray = proportions;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String proportion = stringArray[i];
                loadedProportionSum += Integer.parseInt(proportion.trim());
            }
            if (loadedProportionSum != 0) {
                for (int i = 0; i < schemaMemoryProportion.length; ++i) {
                    schemaMemoryProportion[i] = Integer.parseInt(proportions[i].trim());
                }
            }
        }
        int proportionSum = 0;
        for (int proportion : schemaMemoryProportion) {
            proportionSum += proportion;
        }
        this.schemaRegionMemoryManager = schemaEngineMemoryManager.getOrCreateMemoryManager("SchemaRegion", schemaMemoryTotal * (long)schemaMemoryProportion[0] / (long)proportionSum);
        this.schemaCacheMemoryManager = schemaEngineMemoryManager.getOrCreateMemoryManager("SchemaCache", schemaMemoryTotal * (long)schemaMemoryProportion[1] / (long)proportionSum);
        this.partitionCacheMemoryManager = schemaEngineMemoryManager.getOrCreateMemoryManager("PartitionCache", schemaMemoryTotal * (long)schemaMemoryProportion[2] / (long)proportionSum);
        LOGGER.info("allocateMemoryForSchemaRegion = {}", (Object)this.schemaRegionMemoryManager.getTotalMemorySizeInBytes());
        LOGGER.info("allocateMemoryForSchemaCache = {}", (Object)this.schemaCacheMemoryManager.getTotalMemorySizeInBytes());
        LOGGER.info("allocateMemoryForPartitionCache = {}", (Object)this.partitionCacheMemoryManager.getTotalMemorySizeInBytes());
    }

    private void initStorageEngineAllocate(MemoryManager storageEngineMemoryManager, TrimProperties properties) {
        double devicePathCacheProportion;
        double walBufferQueueProportion;
        double rejectProportion = Double.parseDouble(properties.getProperty("reject_proportion", Double.toString(this.getRejectProportion())));
        if (rejectProportion + (walBufferQueueProportion = Double.parseDouble(properties.getProperty("wal_buffer_queue_proportion", Double.toString(this.getWalBufferQueueProportion())))) + (devicePathCacheProportion = Double.parseDouble(properties.getProperty("device_path_cache_proportion", Double.toString(this.getDevicePathCacheProportion())))) >= 1.0) {
            LOGGER.warn("The sum of reject_proportion, wal_buffer_queue_proportion and device_path_cache_proportion is too large, use default values 0.8, 0.1 and 0.05.");
        } else {
            this.setRejectProportion(rejectProportion);
            this.setWalBufferQueueProportion(walBufferQueueProportion);
            this.setDevicePathCacheProportion(devicePathCacheProportion);
        }
        this.setBufferedArraysMemoryProportion(Double.parseDouble(properties.getProperty("buffered_arrays_memory_proportion", Double.toString(this.getBufferedArraysMemoryProportion()))));
        long storageMemoryTotal = storageEngineMemoryManager.getTotalMemorySizeInBytes();
        String valueOfStorageEngineMemoryProportion = properties.getProperty("storage_engine_memory_proportion");
        long writeMemorySize = storageMemoryTotal * 8L / 10L;
        long compactionMemorySize = storageMemoryTotal * 2L / 10L;
        long memtableMemorySize = writeMemorySize * 19L / 20L;
        long timePartitionInfoMemorySize = writeMemorySize / 20L;
        if (valueOfStorageEngineMemoryProportion != null) {
            String[] storageProportionArray = valueOfStorageEngineMemoryProportion.split(":");
            int storageEngineMemoryProportion = 0;
            for (String proportion : storageProportionArray) {
                int proportionValue = Integer.parseInt(proportion.trim());
                if (proportionValue <= 0) {
                    LOGGER.warn("The value of storage_engine_memory_proportion is illegal, use default value 8:2 .");
                    return;
                }
                storageEngineMemoryProportion += proportionValue;
            }
            writeMemorySize = storageMemoryTotal * (long)Integer.parseInt(storageProportionArray[0].trim()) / (long)storageEngineMemoryProportion;
            compactionMemorySize = storageMemoryTotal * (long)Integer.parseInt(storageProportionArray[1].trim()) / (long)storageEngineMemoryProportion;
            String valueOfWriteMemoryProportion = properties.getProperty("write_memory_proportion");
            if (valueOfWriteMemoryProportion != null) {
                String[] writeProportionArray = valueOfWriteMemoryProportion.split(":");
                int writeMemoryProportion = 0;
                for (String proportion : writeProportionArray) {
                    int proportionValue = Integer.parseInt(proportion.trim());
                    writeMemoryProportion += proportionValue;
                    if (proportionValue > 0) continue;
                    LOGGER.warn("The value of write_memory_proportion is illegal, use default value 19:1 .");
                    return;
                }
                memtableMemorySize = writeMemorySize * (long)Integer.parseInt(writeProportionArray[0].trim()) / (long)writeMemoryProportion;
                timePartitionInfoMemorySize = writeMemorySize * (long)Integer.parseInt(writeProportionArray[1].trim()) / (long)writeMemoryProportion;
            }
        }
        this.writeMemoryManager = storageEngineMemoryManager.getOrCreateMemoryManager("Write", writeMemorySize);
        this.compactionMemoryManager = storageEngineMemoryManager.getOrCreateMemoryManager("Compaction", compactionMemorySize);
        this.memtableMemoryManager = this.writeMemoryManager.getOrCreateMemoryManager("Memtable", memtableMemorySize);
        this.timePartitionInfoMemoryManager = this.writeMemoryManager.getOrCreateMemoryManager("TimePartitionInfo", timePartitionInfoMemorySize);
        long devicePathCacheMemorySize = (long)((double)memtableMemorySize * this.getDevicePathCacheProportion());
        this.devicePathCacheMemoryManager = this.memtableMemoryManager.getOrCreateMemoryManager("DevicePathCache", devicePathCacheMemorySize);
        long bufferedArraysMemorySize = (long)((double)storageMemoryTotal * this.getBufferedArraysMemoryProportion());
        this.bufferedArraysMemoryManager = this.memtableMemoryManager.getOrCreateMemoryManager("BufferedArray", bufferedArraysMemorySize);
        long walBufferQueueMemorySize = (long)((double)memtableMemorySize * this.getWalBufferQueueProportion());
        this.walBufferQueueMemoryManager = this.memtableMemoryManager.getOrCreateMemoryManager("WalBufferQueue", walBufferQueueMemorySize);
    }

    private void initQueryEngineMemoryAllocate(MemoryManager queryEngineMemoryManager, TrimProperties properties) {
        this.setEnableQueryMemoryEstimation(Boolean.parseBoolean(properties.getProperty("enable_query_memory_estimation", Boolean.toString(this.isEnableQueryMemoryEstimation()))));
        this.setMetaDataCacheEnable(Boolean.parseBoolean(properties.getProperty("meta_data_cache_enable", Boolean.toString(this.isMetaDataCacheEnable()))));
        this.setQueryThreadCount(Integer.parseInt(properties.getProperty("query_thread_count", Integer.toString(this.getQueryThreadCount()))));
        if (this.getQueryThreadCount() <= 0) {
            this.setQueryThreadCount(Runtime.getRuntime().availableProcessors());
        }
        try {
            this.setEnableQueryMemoryEstimation(Boolean.parseBoolean(properties.getProperty("enable_query_memory_estimation", ConfigurationFileUtils.getConfigurationDefaultValue((String)"enable_query_memory_estimation"))));
        }
        catch (Exception e) {
            LOGGER.error(String.format("Fail to reload configuration because %s", e));
        }
        String queryMemoryAllocateProportion = properties.getProperty("chunk_timeseriesmeta_free_memory_proportion");
        long maxMemoryAvailable = queryEngineMemoryManager.getTotalMemorySizeInBytes();
        long bloomFilterCacheMemorySize = maxMemoryAvailable / 1001L;
        long chunkCacheMemorySize = maxMemoryAvailable * 100L / 1001L;
        long timeSeriesMetaDataCacheMemorySize = maxMemoryAvailable * 200L / 1001L;
        long coordinatorMemorySize = maxMemoryAvailable * 50L / 1001L;
        long operatorsMemorySize = maxMemoryAvailable * 200L / 1001L;
        long dataExchangeMemorySize = maxMemoryAvailable * 200L / 1001L;
        long timeIndexMemorySize = maxMemoryAvailable * 200L / 1001L;
        if (queryMemoryAllocateProportion != null) {
            String[] proportions = queryMemoryAllocateProportion.split(":");
            int proportionSum = 0;
            for (String proportion : proportions) {
                proportionSum += Integer.parseInt(proportion.trim());
            }
            if (proportionSum != 0) {
                try {
                    bloomFilterCacheMemorySize = maxMemoryAvailable * (long)Integer.parseInt(proportions[0].trim()) / (long)proportionSum;
                    chunkCacheMemorySize = maxMemoryAvailable * (long)Integer.parseInt(proportions[1].trim()) / (long)proportionSum;
                    timeSeriesMetaDataCacheMemorySize = maxMemoryAvailable * (long)Integer.parseInt(proportions[2].trim()) / (long)proportionSum;
                    coordinatorMemorySize = maxMemoryAvailable * (long)Integer.parseInt(proportions[3].trim()) / (long)proportionSum;
                    operatorsMemorySize = maxMemoryAvailable * (long)Integer.parseInt(proportions[4].trim()) / (long)proportionSum;
                    dataExchangeMemorySize = maxMemoryAvailable * (long)Integer.parseInt(proportions[5].trim()) / (long)proportionSum;
                    timeIndexMemorySize = maxMemoryAvailable * (long)Integer.parseInt(proportions[6].trim()) / (long)proportionSum;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Each subsection of configuration item chunkmeta_chunk_timeseriesmeta_free_memory_proportion should be an integer, which is " + queryMemoryAllocateProportion, e);
                }
            }
        }
        if (!this.isMetaDataCacheEnable()) {
            long sum = bloomFilterCacheMemorySize + chunkCacheMemorySize + timeSeriesMetaDataCacheMemorySize;
            bloomFilterCacheMemorySize = 0L;
            chunkCacheMemorySize = 0L;
            timeSeriesMetaDataCacheMemorySize = 0L;
            long partForDataExchange = sum / 2L;
            long partForOperators = sum - partForDataExchange;
            dataExchangeMemorySize += partForDataExchange;
            operatorsMemorySize += partForOperators;
        }
        this.setMaxBytesPerFragmentInstance(dataExchangeMemorySize / (long)this.getQueryThreadCount());
        this.bloomFilterCacheMemoryManager = queryEngineMemoryManager.getOrCreateMemoryManager("BloomFilterCache", bloomFilterCacheMemorySize);
        this.chunkCacheMemoryManager = queryEngineMemoryManager.getOrCreateMemoryManager("ChunkCache", chunkCacheMemorySize);
        this.timeSeriesMetaDataCacheMemoryManager = queryEngineMemoryManager.getOrCreateMemoryManager("TimeSeriesMetaDataCache", timeSeriesMetaDataCacheMemorySize);
        this.coordinatorMemoryManager = queryEngineMemoryManager.getOrCreateMemoryManager("Coordinator", coordinatorMemorySize);
        this.operatorsMemoryManager = queryEngineMemoryManager.getOrCreateMemoryManager("Operators", operatorsMemorySize);
        this.dataExchangeMemoryManager = queryEngineMemoryManager.getOrCreateMemoryManager("DataExchange", dataExchangeMemorySize);
        this.timeIndexMemoryManager = queryEngineMemoryManager.getOrCreateMemoryManager("TimeIndex", timeIndexMemorySize);
    }

    public double getRejectProportion() {
        return this.rejectProportion;
    }

    public void setRejectProportion(double rejectProportion) {
        this.rejectProportion = rejectProportion;
    }

    public double getWalBufferQueueProportion() {
        return this.walBufferQueueProportion;
    }

    public void setWalBufferQueueProportion(double walBufferQueueProportion) {
        this.walBufferQueueProportion = walBufferQueueProportion;
    }

    public double getMaxDirectBufferOffHeapMemorySizeProportion() {
        return this.maxDirectBufferOffHeapMemorySizeProportion;
    }

    public void setMaxDirectBufferOffHeapMemorySizeProportion(double maxDirectBufferOffHeapMemorySizeProportion) {
        this.maxDirectBufferOffHeapMemorySizeProportion = maxDirectBufferOffHeapMemorySizeProportion;
    }

    public double getBufferedArraysMemoryProportion() {
        return this.bufferedArraysMemoryProportion;
    }

    public void setBufferedArraysMemoryProportion(double bufferedArraysMemoryProportion) {
        this.bufferedArraysMemoryProportion = bufferedArraysMemoryProportion;
    }

    public double getDevicePathCacheProportion() {
        return this.devicePathCacheProportion;
    }

    public void setDevicePathCacheProportion(double devicePathCacheProportion) {
        this.devicePathCacheProportion = devicePathCacheProportion;
    }

    public boolean isEnableQueryMemoryEstimation() {
        return this.enableQueryMemoryEstimation;
    }

    public void setEnableQueryMemoryEstimation(boolean enableQueryMemoryEstimation) {
        this.enableQueryMemoryEstimation = enableQueryMemoryEstimation;
    }

    public boolean isMetaDataCacheEnable() {
        return this.metaDataCacheEnable;
    }

    public void setMetaDataCacheEnable(boolean metaDataCacheEnable) {
        this.metaDataCacheEnable = metaDataCacheEnable;
    }

    public int getQueryThreadCount() {
        return this.queryThreadCount;
    }

    public void setQueryThreadCount(int queryThreadCount) {
        if (queryThreadCount <= 0) {
            queryThreadCount = Runtime.getRuntime().availableProcessors();
        }
        this.queryThreadCount = queryThreadCount;
        if (this.getDataExchangeMemoryManager() != null) {
            this.maxBytesPerFragmentInstance = this.getDataExchangeMemoryManager().getTotalMemorySizeInBytes() / (long)queryThreadCount;
        }
    }

    public long getMaxBytesPerFragmentInstance() {
        return this.maxBytesPerFragmentInstance;
    }

    public void setMaxBytesPerFragmentInstance(long maxBytesPerFragmentInstance) {
        this.maxBytesPerFragmentInstance = maxBytesPerFragmentInstance;
    }

    public MemoryManager getOnHeapMemoryManager() {
        return this.onHeapMemoryManager;
    }

    public MemoryManager getStorageEngineMemoryManager() {
        return this.storageEngineMemoryManager;
    }

    public MemoryManager getWriteMemoryManager() {
        return this.writeMemoryManager;
    }

    public MemoryManager getMemtableMemoryManager() {
        return this.memtableMemoryManager;
    }

    public MemoryManager getWalBufferQueueMemoryManager() {
        return this.walBufferQueueMemoryManager;
    }

    public MemoryManager getDevicePathCacheMemoryManager() {
        return this.devicePathCacheMemoryManager;
    }

    public MemoryManager getBufferedArraysMemoryManager() {
        return this.bufferedArraysMemoryManager;
    }

    public MemoryManager getTimePartitionInfoMemoryManager() {
        return this.timePartitionInfoMemoryManager;
    }

    public MemoryManager getCompactionMemoryManager() {
        return this.compactionMemoryManager;
    }

    public MemoryManager getQueryEngineMemoryManager() {
        return this.queryEngineMemoryManager;
    }

    public MemoryManager getBloomFilterCacheMemoryManager() {
        return this.bloomFilterCacheMemoryManager;
    }

    public MemoryManager getTimeSeriesMetaDataCacheMemoryManager() {
        return this.timeSeriesMetaDataCacheMemoryManager;
    }

    public MemoryManager getChunkCacheMemoryManager() {
        return this.chunkCacheMemoryManager;
    }

    public MemoryManager getCoordinatorMemoryManager() {
        return this.coordinatorMemoryManager;
    }

    public MemoryManager getOperatorsMemoryManager() {
        return this.operatorsMemoryManager;
    }

    public MemoryManager getDataExchangeMemoryManager() {
        return this.dataExchangeMemoryManager;
    }

    public MemoryManager getTimeIndexMemoryManager() {
        return this.timeIndexMemoryManager;
    }

    public MemoryManager getSchemaEngineMemoryManager() {
        return this.schemaEngineMemoryManager;
    }

    public MemoryManager getSchemaRegionMemoryManager() {
        return this.schemaRegionMemoryManager;
    }

    public MemoryManager getSchemaCacheMemoryManager() {
        return this.schemaCacheMemoryManager;
    }

    public void setSchemaCacheMemoryManager(MemoryManager schemaCacheMemoryManager) {
        this.schemaCacheMemoryManager = schemaCacheMemoryManager;
    }

    public MemoryManager getPartitionCacheMemoryManager() {
        return this.partitionCacheMemoryManager;
    }

    public MemoryManager getConsensusMemoryManager() {
        return this.consensusMemoryManager;
    }

    public MemoryManager getPipeMemoryManager() {
        return this.pipeMemoryManager;
    }

    public MemoryManager getOffHeapMemoryManager() {
        return this.offHeapMemoryManager;
    }

    public MemoryManager getDirectBufferMemoryManager() {
        return this.directBufferMemoryManager;
    }
}

