#!/bin/bash

# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

set -xe

# Include base script
source setup.sh

# Copy TA and host binary
cp ../examples/secure_storage-rs/ta/target/$TARGET_TA/release/*.ta shared
cp ../examples/secure_storage-rs/host/target/$TARGET_HOST/release/secure_storage-rs shared

# Run script specific commands in QEMU
run_in_qemu "cp *.ta /lib/optee_armtz/\n"
run_in_qemu "./secure_storage-rs\n"
run_in_qemu "^C"

# Script specific checks
{
    grep -q "Test on object \"object#1\"" screenlog.0 &&
    grep -q "\- Create and load object in the TA secure storage" screenlog.0 &&
    grep -q "\- Read back the object" screenlog.0 &&
    grep -q "\- Content read-out correctly" screenlog.0 &&
    grep -q "\- Delete the object" screenlog.0 &&

    grep -q "Test on object \"object#2\"" screenlog.0 &&
    #miss the read correctly output
    grep -Eq "\- Object not found in TA secure storage, create it|\- Object found in TA secure storage, delete it" screenlog.0 &&

    grep -q "We're done, close and release TEE resources" screenlog.0
} || {
        cat -v screenlog.0
        cat -v /tmp/serial.log
        false
}

rm screenlog.0