/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.seata.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Set;

public class CustomConfigurationForTest extends AbstractConfiguration {
    private Properties properties;

    public CustomConfigurationForTest(String name) {
        try (InputStream input = CustomConfigurationForTest.class.getClassLoader().getResourceAsStream(name)) {
            properties = new Properties();
            properties.load(input);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getTypeName() {
        return "forTest";
    }

    @Override
    public String getLatestConfig(String dataId, String defaultValue, long timeoutMills) {
        return properties.getProperty(dataId, defaultValue);
    }

    @Override
    public boolean putConfig(String dataId, String content, long timeoutMills) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean putConfigIfAbsent(String dataId, String content, long timeoutMills) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeConfig(String dataId, long timeoutMills) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addConfigListener(String dataId, ConfigurationChangeListener listener) {
    }

    @Override
    public void removeConfigListener(String dataId, ConfigurationChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<ConfigurationChangeListener> getConfigListeners(String dataId) {
        throw new UnsupportedOperationException();
    }
}
