/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.store;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.util.IsolationLevel;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.core.store.db.AbstractDataSourceProvider;

@LoadLevel(name="hikari")
public class HikariDataSourceProvider
extends AbstractDataSourceProvider {
    public DataSource doGenerate() {
        Properties properties = new Properties();
        properties.setProperty("dataSource.cachePrepStmts", "true");
        properties.setProperty("dataSource.prepStmtCacheSize", "250");
        properties.setProperty("dataSource.prepStmtCacheSqlLimit", "2048");
        properties.setProperty("dataSource.useServerPrepStmts", "true");
        properties.setProperty("dataSource.useLocalSessionState", "true");
        properties.setProperty("dataSource.rewriteBatchedStatements", "true");
        properties.setProperty("dataSource.cacheResultSetMetadata", "true");
        properties.setProperty("dataSource.cacheServerConfiguration", "true");
        properties.setProperty("dataSource.elideSetAutoCommits", "true");
        properties.setProperty("dataSource.maintainTimeStats", "false");
        HikariConfig config = new HikariConfig(properties);
        config.setDriverClassName(this.getDriverClassName());
        config.setJdbcUrl(this.getUrl());
        config.setUsername(this.getUser());
        config.setPassword(this.getPassword());
        config.setMaximumPoolSize(this.getMaxConn());
        config.setMinimumIdle(this.getMinConn());
        config.setAutoCommit(true);
        config.setConnectionTimeout(this.getMaxWait().longValue());
        config.setInitializationFailTimeout(-1L);
        config.setTransactionIsolation(IsolationLevel.TRANSACTION_READ_COMMITTED.name());
        config.setConnectionTestQuery(this.getValidationQuery(this.getDBType()));
        long idleTimeout = CONFIG.getLong("store.db.hikari.idleTimeout", 600000L);
        config.setIdleTimeout(idleTimeout < 0L ? 600000L : idleTimeout);
        long keepaliveTime = CONFIG.getLong("store.db.hikari.keepaliveTime", 120000L);
        config.setKeepaliveTime(keepaliveTime < 0L ? 120000L : keepaliveTime);
        long maxLifeTime = CONFIG.getLong("store.db.hikari.maxLifetime", 1800000L);
        config.setMaxLifetime(maxLifeTime < 0L ? 1800000L : maxLifeTime);
        long validationTimeout = CONFIG.getLong("store.db.hikari.validationTimeout", 5000L);
        config.setValidationTimeout(validationTimeout < 0L ? 5000L : validationTimeout);
        return new HikariDataSource(config);
    }
}

