/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.storage.db.store;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.seata.common.exception.ErrorCode;
import org.apache.seata.common.exception.SeataRuntimeException;
import org.apache.seata.common.metadata.Instance;
import org.apache.seata.common.util.IOUtil;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.store.MappingDO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VGroupMappingDataBaseDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger(VGroupMappingDataBaseDAO.class);
    protected DataSource vGroupMappingDataSource;
    protected final String vMapping;
    protected static final Configuration CONFIG = ConfigurationFactory.getInstance();

    public VGroupMappingDataBaseDAO(DataSource vGroupMappingDataSource) {
        this.vGroupMappingDataSource = vGroupMappingDataSource;
        this.vMapping = CONFIG.getConfig("store.db..vgroup-table", "vgroup_table");
    }

    public boolean insertMappingDO(MappingDO mappingDO) {
        boolean bl;
        String sql = "INSERT INTO " + this.vMapping + " (vgroup,namespace, cluster) VALUES (?, ?, ?)";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            int index = 1;
            conn = this.vGroupMappingDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            ps.setString(index++, mappingDO.getVGroup());
            ps.setString(index++, mappingDO.getNamespace());
            ps.setString(index++, mappingDO.getCluster());
            bl = ps.executeUpdate() > 0;
        }
        catch (SQLException e) {
            try {
                throw new SeataRuntimeException(ErrorCode.ERR_CONFIG, (Throwable)e, new String[0]);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
        return bl;
    }

    public boolean clearMappingDOByVGroup(String vGroup) {
        boolean bl;
        String sql = "DELETE FROM " + this.vMapping + " WHERE vGroup = ?";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.vGroupMappingDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            ps.setString(1, vGroup);
            bl = ps.executeUpdate() > 0;
        }
        catch (SQLException e) {
            try {
                throw new SeataRuntimeException(ErrorCode.ERR_CONFIG, (Throwable)e, new String[0]);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
        return bl;
    }

    public boolean deleteMappingDOByVGroup(String vGroup) {
        boolean bl;
        String sql = "DELETE FROM " + this.vMapping + " WHERE vGroup = ? and cluster = ?";
        Instance instance = Instance.getInstance();
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.vGroupMappingDataSource.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setString(1, vGroup);
            ps.setString(2, instance.getClusterName());
            bl = ps.executeUpdate() > 0;
        }
        catch (SQLException e) {
            try {
                throw new SeataRuntimeException(ErrorCode.ERROR_SQL, (Throwable)e, new String[0]);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
        return bl;
    }

    public List<MappingDO> queryMappingDO() {
        String sql = "SELECT vgroup,namespace, cluster FROM " + this.vMapping + " WHERE cluster = ?";
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<MappingDO> result = new ArrayList<MappingDO>();
        try {
            conn = this.vGroupMappingDataSource.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setString(1, CONFIG.getConfig("registry.seata.cluster"));
            rs = ps.executeQuery();
            while (rs.next()) {
                MappingDO mappingDO = new MappingDO();
                mappingDO.setNamespace(rs.getString("namespace"));
                mappingDO.setCluster(rs.getString("cluster"));
                mappingDO.setVGroup(rs.getString("vGroup"));
                result.add(mappingDO);
            }
        }
        catch (SQLException e) {
            try {
                throw new SeataRuntimeException(ErrorCode.ERR_CONFIG, (Throwable)e, new String[0]);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps, conn});
        return result;
    }
}

