/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.console.security;

import javax.annotation.PostConstruct;
import org.apache.seata.console.security.CustomUserDetails;
import org.apache.seata.console.security.User;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class CustomUserDetailsServiceImpl
implements UserDetailsService {
    @Value(value="${console.user.username}")
    private String username;
    @Value(value="${console.user.password}")
    private String password;
    private User user;

    @PostConstruct
    public void init() {
        this.user = new User();
        this.user.setUsername(this.username);
        this.user.setPassword(new BCryptPasswordEncoder().encode((CharSequence)this.password));
    }

    public UserDetails loadUserByUsername(String userName) throws UsernameNotFoundException {
        if (!this.user.getUsername().equals(userName)) {
            throw new UsernameNotFoundException(userName);
        }
        return new CustomUserDetails(this.user);
    }
}

