/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.extension.doris;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.trace.etl.common.TimeConverter;
import org.apache.ozhera.trace.etl.domain.jaegeres.JaegerAttribute;
import org.apache.ozhera.trace.etl.domain.jaegeres.JaegerLogs;
import org.apache.ozhera.trace.etl.domain.jaegeres.JaegerProcess;
import org.apache.ozhera.trace.etl.domain.jaegeres.JaegerReferences;
import org.apache.ozhera.trace.etl.domain.tracequery.Span;
import org.apache.ozhera.trace.etl.domain.tracequery.Trace;
import org.apache.ozhera.trace.etl.domain.tracequery.TraceIdQueryVo;
import org.apache.ozhera.trace.etl.domain.tracequery.TraceListQueryVo;
import org.apache.ozhera.trace.etl.domain.tracequery.TraceQueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import run.mone.doris.DorisService;

public class QueryDorisService {
    private static final Logger log = LoggerFactory.getLogger(QueryDorisService.class);
    @Autowired
    private DorisService dorisService;
    private static final String SOURCE = "HERA";
    private static final String AREA = "all";
    public static final String TRACE_ID = "traceID";
    private static final String SERVICE_ENV = "service.env";
    private static final String OPERATION_NAME = "operationName";
    public static final String START_TIME_MILLIS = "startTimeMillis";
    public static final String START_TIME = "startTime";
    public static final String DURATION = "duration";
    public static final String TAGS = "tags";
    public static final String NESTED_PROCESS_TAGS = "process";
    public static final String NESTED_LOG_FIELDS = "logs";
    public static final String[] NESTED_TAG_FIELD_LIST = new String[]{"tags", "process", "logs"};
    private static final Gson GSON = new GsonBuilder().create();
    private static final Type MAP_TYPE = new TypeToken<Map<String, String>>(){}.getType();
    private static final Type TAGS_TYPE = new TypeToken<List<JaegerAttribute>>(){}.getType();
    private static final Type LOGS_TYPE = new TypeToken<List<JaegerLogs>>(){}.getType();
    private static final Type PROCESS_TYPE = new TypeToken<JaegerProcess>(){}.getType();
    private static final Type REFERENCES_TYPE = new TypeToken<List<JaegerReferences>>(){}.getType();

    public TraceQueryResult<List<String>> getOperations(String service, String index) {
        try {
            log.info("search operations by serviceName param : service=" + service + " index=" + index);
            String sql = "select distinct operationName from hera_trace_service where serviceName='" + service + "' limit 10000";
            log.info("search operations by serviceName sql : " + sql);
            List result = this.dorisService.query(sql);
            log.info("search operations by serviceName result : " + String.valueOf(result));
            ArrayList<String> services = new ArrayList<String>();
            for (Map operation : result) {
                services.add(String.valueOf(operation.get(OPERATION_NAME)));
            }
            return new TraceQueryResult(services, services.size());
        }
        catch (Throwable t) {
            log.error("search operations error : ", t);
            return null;
        }
    }

    public TraceQueryResult<List<Trace>> getList(TraceListQueryVo vo) {
        try {
            log.info("search trace list param : " + String.valueOf(vo));
            Object sql = "select traceID , MAX(startTimeMillis) max_startTimeMillis from hera_trace_span";
            long startTime = vo.getStart() == null ? 0L : TimeUnit.MICROSECONDS.toMillis(vo.getStart());
            long endTime = vo.getEnd() == null ? 0L : TimeUnit.MICROSECONDS.toMillis(vo.getEnd());
            long minDuration = StringUtils.isEmpty((CharSequence)vo.getMinDuration()) ? 0L : TimeConverter.getMicro((String)vo.getMinDuration());
            long maxDuration = StringUtils.isEmpty((CharSequence)vo.getMaxDuration()) ? 0L : TimeConverter.getMicro((String)vo.getMaxDuration());
            List<JaegerAttribute> tags = this.getTags(vo.getTags());
            tags = this.dealServerEnv(tags, vo.getServerEnv());
            Object condition = "";
            if (startTime != 0L && endTime != 0L) {
                condition = (String)condition + this.appendWhereAnd((String)condition) + "startTimeMillis > " + startTime + " and startTimeMillis < " + endTime;
            }
            if (minDuration != 0L) {
                condition = (String)condition + this.appendWhereAnd((String)condition) + "duration > " + minDuration;
            }
            if (maxDuration != 0L) {
                condition = (String)condition + this.appendWhereAnd((String)condition) + "duration < " + maxDuration;
            }
            if (!Strings.isNullOrEmpty((String)vo.getOperation())) {
                condition = (String)condition + this.appendWhereAnd((String)condition) + "operationName = '" + vo.getOperation() + "'";
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getService())) {
                condition = (String)condition + this.appendWhereAnd((String)condition) + "process like '%" + vo.getService() + "%'";
            }
            if (tags != null && tags.size() > 0) {
                for (JaegerAttribute tag : tags) {
                    condition = (String)condition + this.appendWhereAnd(this.buildTagQuery(tag));
                }
            }
            sql = (String)sql + (String)condition;
            sql = (String)sql + " group by traceID";
            sql = (String)sql + " order by max_startTimeMillis desc";
            sql = (String)sql + " limit " + vo.getLimit();
            log.info("get traceIds sql : " + (String)sql);
            List query = this.dorisService.query((String)sql);
            log.info("query traceIds result : " + String.valueOf(query));
            ArrayList<String> traceIds = new ArrayList<String>(20);
            for (Map traceId : query) {
                traceIds.add(String.valueOf(traceId.get(TRACE_ID)));
            }
            List<Trace> traces = this.queryMultiTraceSpans(traceIds, startTime, endTime, vo.getIndex());
            return new TraceQueryResult(traces, traces.size());
        }
        catch (Throwable t) {
            log.error("search traces from es error : ", t);
            return null;
        }
    }

    public TraceQueryResult<List<Trace>> getByTraceId(TraceIdQueryVo vo) {
        String traceId = vo.getTraceId();
        log.info("search by traceId param : " + String.valueOf(vo) + ", traceId : " + traceId);
        String sql = "select * from hera_trace_span where traceID = '" + traceId + "' order by startTime limit 1000";
        log.info("search by traceId sql : " + sql);
        ArrayList<Span> jaegerSpans = new ArrayList<Span>();
        try {
            List result = this.dorisService.query(sql);
            for (Map span : result) {
                Span spanConvert = this.convertSpan(span);
                this.complateSpan(spanConvert);
                jaegerSpans.add(spanConvert);
            }
            Trace trace = this.getTrace(jaegerSpans);
            return new TraceQueryResult(Collections.singletonList(trace), 1);
        }
        catch (Throwable t) {
            log.error("search trace by traceId error : ", t);
            return null;
        }
    }

    private List<Trace> queryMultiTraceSpans(List<String> traceIds, long startTime, long endTime, String index) throws IOException {
        if (traceIds == null || traceIds.size() == 0) {
            return new ArrayList<Trace>();
        }
        ArrayList<Trace> jaegerTraces = new ArrayList<Trace>();
        try {
            for (String traceId : traceIds) {
                String dorisQuery = "SELECT * FROM hera_trace_span WHERE traceID = '" + traceId + "' ORDER BY startTimeMillis DESC LIMIT 1000";
                log.info("query multi trace spans sql : " + dorisQuery);
                List result = this.dorisService.query(dorisQuery);
                ArrayList<Span> jaegerSpans = new ArrayList<Span>();
                for (Map span : result) {
                    Span spanConvert = this.convertSpan(span);
                    this.complateSpan(spanConvert);
                    jaegerSpans.add(spanConvert);
                }
                jaegerTraces.add(this.getTrace(jaegerSpans));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return jaegerTraces;
    }

    private Trace getTrace(List<Span> spans) {
        Trace trace = new Trace();
        trace.setSpans(spans);
        if (!spans.isEmpty()) {
            trace.setTraceID(spans.get(0).getTraceID());
            trace.setProcesses(this.getProcess(spans));
        }
        trace.setSource(SOURCE);
        trace.setArea(AREA);
        return trace;
    }

    private void complateSpan(Span span) {
        span.setProcessID(span.getProcess().getServiceName());
    }

    private Map<String, JaegerProcess> getProcess(List<Span> spans) {
        HashMap<String, JaegerProcess> result = new HashMap<String, JaegerProcess>();
        for (Span span : spans) {
            result.put(span.getProcess().getServiceName(), span.getProcess());
        }
        return result;
    }

    private List<JaegerAttribute> getTags(String tags) {
        if (StringUtils.isEmpty((CharSequence)tags)) {
            return null;
        }
        ArrayList<JaegerAttribute> jaegerAttributes = new ArrayList<JaegerAttribute>();
        try {
            tags = URLDecoder.decode(tags, "UTF-8");
            Map tagMap = (Map)GSON.fromJson(tags, MAP_TYPE);
            for (String key : tagMap.keySet()) {
                JaegerAttribute attr = new JaegerAttribute();
                attr.setKey(key);
                attr.setValue((String)tagMap.get(key));
                jaegerAttributes.add(attr);
            }
        }
        catch (Throwable t) {
            log.error("parse String tags to JaegerAttribute error : ", t);
        }
        return jaegerAttributes;
    }

    private List<JaegerAttribute> dealServerEnv(List<JaegerAttribute> tags, String serverEnv) {
        if (StringUtils.isEmpty((CharSequence)serverEnv)) {
            return tags;
        }
        if (tags == null) {
            tags = new ArrayList<JaegerAttribute>();
        }
        JaegerAttribute attr = new JaegerAttribute();
        attr.setKey(SERVICE_ENV);
        attr.setValue(serverEnv);
        tags.add(attr);
        return tags;
    }

    private String buildTagQuery(JaegerAttribute tag) {
        StringBuilder sb = new StringBuilder();
        for (String nestedTagField : NESTED_TAG_FIELD_LIST) {
            sb.append(nestedTagField + " like '%" + tag.getKey() + "%'");
            sb.append(nestedTagField + " like '%" + tag.getValue() + "%'");
        }
        return sb.toString();
    }

    private String appendWhereAnd(String condition) {
        if (condition.startsWith(" where ")) {
            return " and ";
        }
        return " where ";
    }

    private Span convertSpan(Map<String, Object> map) {
        Span span = new Span();
        span.setSpanID(String.valueOf(map.get("spanID")));
        span.setDuration(Long.parseLong(String.valueOf(map.get(DURATION))));
        span.setTraceID(String.valueOf(map.get(TRACE_ID)));
        span.setFlags(Integer.parseInt(map.get("flags") == null ? "0" : String.valueOf(map.get("flags"))));
        List logs = (List)GSON.fromJson(String.valueOf(map.get(NESTED_LOG_FIELDS)), LOGS_TYPE);
        span.setLogs(logs);
        JaegerProcess process = (JaegerProcess)GSON.fromJson(String.valueOf(map.get(NESTED_PROCESS_TAGS)), PROCESS_TYPE);
        span.setProcess(process);
        List tags = (List)GSON.fromJson(String.valueOf(map.get(TAGS)), TAGS_TYPE);
        span.setTags(tags);
        span.setOperationName(String.valueOf(map.get(OPERATION_NAME)));
        List references = (List)GSON.fromJson(String.valueOf(map.get("references")), REFERENCES_TYPE);
        span.setReferences(references);
        span.setStartTime(Long.parseLong(String.valueOf(map.get(START_TIME))));
        span.setParentSpanID(String.valueOf(map.get("parentSpanID")));
        return span;
    }
}

