/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.mvc.download;

import com.xiaomi.youpin.docean.common.StringUtils;
import com.xiaomi.youpin.docean.exception.DoceanException;
import com.xiaomi.youpin.docean.mvc.download.BaseService;
import com.xiaomi.youpin.docean.mvc.download.DownloadListener;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedFile;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import javax.activation.MimetypesFileTypeMap;

public class DownloadService
extends BaseService {
    public void download(ChannelHandlerContext ctx, FullHttpRequest request, String name, String id) throws IOException {
        String path = DownloadService.path(name);
        File file = new File(path);
        if (file.isHidden() || !file.exists() || !file.isFile() || !file.getPath().startsWith(DATAPATH)) {
            DownloadService.send(ctx, HttpResponseStatus.NOT_FOUND, HttpResponseStatus.NOT_FOUND.reasonPhrase());
            return;
        }
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        long fileLength = raf.length();
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        HttpUtil.setContentLength((HttpMessage)response, (long)fileLength);
        DownloadService.setContentTypeHeader((HttpResponse)response, file);
        if (HttpUtil.isKeepAlive((HttpMessage)request)) {
            response.headers().set("CONNECTION", (Object)HttpHeaderNames.KEEP_ALIVE);
        }
        ctx.write((Object)response);
        ChannelFuture sendFileFuture = ctx.write((Object)new HttpChunkedInput((ChunkedInput)new ChunkedFile(raf, 0L, fileLength, 65536)), (ChannelPromise)ctx.newProgressivePromise());
        sendFileFuture.addListener((GenericFutureListener)new DownloadListener(id, fileLength));
        ChannelFuture lastContentFuture = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        if (!HttpHeaders.isKeepAlive((HttpMessage)request)) {
            lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private static String path(String name) {
        DownloadService.checkFileName(name);
        return DATAPATH + File.separator + name;
    }

    public static void checkFileName(String name) {
        if (StringUtils.isEmpty(name) || name.contains("..") || name.contains("/") || name.contains("\\")) {
            throw new DoceanException();
        }
    }

    private static void setContentTypeHeader(HttpResponse response, File file) throws UnsupportedEncodingException {
        MimetypesFileTypeMap m = new MimetypesFileTypeMap();
        Object contentType = m.getContentType(file.getPath());
        if (!((String)contentType).equals("application/octet-stream")) {
            contentType = (String)contentType + "; charset=utf-8";
        }
        response.headers().set("Content-Disposition", (Object)("attachment;filename=" + new String(file.getName().replaceAll(" ", "_").getBytes("UTF-8"), "ISO-8859-1")));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, contentType);
    }
}

