/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.bytecode.Wrapper;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.ConfigInitializer;
import org.apache.dubbo.config.ConfigPostProcessor;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.bootstrap.DubboBootstrap;
import org.apache.dubbo.config.event.ReferenceConfigDestroyedEvent;
import org.apache.dubbo.config.event.ReferenceConfigInitializedEvent;
import org.apache.dubbo.config.support.Parameter;
import org.apache.dubbo.config.utils.ConfigValidationUtils;
import org.apache.dubbo.event.Event;
import org.apache.dubbo.event.EventDispatcher;
import org.apache.dubbo.registry.client.metadata.MetadataUtils;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProxyFactory;
import org.apache.dubbo.rpc.cluster.Cluster;
import org.apache.dubbo.rpc.cluster.directory.StaticDirectory;
import org.apache.dubbo.rpc.cluster.support.ClusterUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.AsyncMethodInfo;
import org.apache.dubbo.rpc.model.ConsumerModel;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.model.ServiceRepository;
import org.apache.dubbo.rpc.protocol.injvm.InjvmProtocol;
import org.apache.dubbo.rpc.service.GenericService;
import org.apache.dubbo.rpc.support.ProtocolUtils;

public class ReferenceConfig<T>
extends ReferenceConfigBase<T> {
    public static final Logger logger = LoggerFactory.getLogger(ReferenceConfig.class);
    private static final Protocol REF_PROTOCOL = ExtensionLoader.getExtensionLoader(Protocol.class).getAdaptiveExtension();
    private static final Cluster CLUSTER = ExtensionLoader.getExtensionLoader(Cluster.class).getAdaptiveExtension();
    private static final ProxyFactory PROXY_FACTORY = ExtensionLoader.getExtensionLoader(ProxyFactory.class).getAdaptiveExtension();
    private volatile transient T ref;
    private volatile transient Invoker<?> invoker;
    private volatile transient boolean initialized;
    private volatile transient boolean destroyed;
    private final ServiceRepository repository = ApplicationModel.getServiceRepository();
    private DubboBootstrap bootstrap;
    private String services;

    public ReferenceConfig() {
    }

    public ReferenceConfig(Reference reference) {
        super(reference);
    }

    @Deprecated
    @Parameter(key="subscribed-services")
    public String getServices() {
        return this.services;
    }

    @Deprecated
    @Parameter(excluded=true)
    public Set<String> getSubscribedServices() {
        return StringUtils.splitToSet(this.getServices(), ',');
    }

    public void setServices(String services) {
        this.services = services;
    }

    @Override
    public synchronized T get() {
        if (this.destroyed) {
            throw new IllegalStateException("The invoker of ReferenceConfig(" + this.url + ") has already destroyed!");
        }
        if (this.ref == null) {
            this.init();
        }
        return this.ref;
    }

    @Override
    public synchronized void destroy() {
        if (this.ref == null) {
            return;
        }
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        try {
            this.invoker.destroy();
        }
        catch (Throwable t) {
            logger.warn("Unexpected error occurred when destroy invoker of ReferenceConfig(" + this.url + ").", t);
        }
        this.invoker = null;
        this.ref = null;
        this.dispatch(new ReferenceConfigDestroyedEvent(this));
    }

    public synchronized void init() {
        String hostToRegistry;
        if (this.initialized) {
            return;
        }
        if (this.bootstrap == null) {
            this.bootstrap = DubboBootstrap.getInstance();
            if (null != this.getRegistries()) {
                this.bootstrap.registries(this.getRegistries());
            }
            this.bootstrap.initialize();
        }
        this.checkAndUpdateSubConfigs();
        this.checkStubAndLocal(this.interfaceClass);
        ConfigValidationUtils.checkMock(this.interfaceClass, this);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("side", "consumer");
        ReferenceConfigBase.appendRuntimeParameters(map);
        if (!ProtocolUtils.isGeneric(this.generic)) {
            String[] methods;
            String revision = Version.getVersion(this.interfaceClass, this.version);
            if (revision != null && revision.length() > 0) {
                map.put("revision", revision);
            }
            if ((methods = Wrapper.getWrapper(this.interfaceClass).getMethodNames()).length == 0) {
                logger.warn("No method found in service interface " + this.interfaceClass.getName());
                map.put("methods", "*");
            } else {
                map.put("methods", StringUtils.join(new HashSet<String>(Arrays.asList(methods)), ","));
            }
        }
        map.put("interface", this.interfaceName);
        AbstractConfig.appendParameters(map, this.getMetrics());
        AbstractConfig.appendParameters(map, this.getApplication());
        AbstractConfig.appendParameters(map, this.getModule());
        AbstractConfig.appendParameters(map, this.consumer);
        AbstractConfig.appendParameters(map, this);
        MetadataReportConfig metadataReportConfig = this.getMetadataReportConfig();
        if (metadataReportConfig != null && metadataReportConfig.isValid()) {
            map.putIfAbsent("metadata-type", "remote");
        }
        HashMap<String, AsyncMethodInfo> attributes = null;
        if (CollectionUtils.isNotEmpty(this.getMethods())) {
            attributes = new HashMap<String, AsyncMethodInfo>();
            for (MethodConfig methodConfig : this.getMethods()) {
                AsyncMethodInfo asyncMethodInfo;
                String retryValue;
                AbstractConfig.appendParameters(map, methodConfig, methodConfig.getName());
                String retryKey = methodConfig.getName() + ".retry";
                if (map.containsKey(retryKey) && "false".equals(retryValue = (String)map.remove(retryKey))) {
                    map.put(methodConfig.getName() + ".retries", "0");
                }
                if ((asyncMethodInfo = AbstractConfig.convertMethodConfig2AsyncInfo(methodConfig)) == null) continue;
                attributes.put(methodConfig.getName(), asyncMethodInfo);
            }
        }
        if (StringUtils.isEmpty(hostToRegistry = ConfigUtils.getSystemProperty("DUBBO_IP_TO_REGISTRY"))) {
            hostToRegistry = NetUtils.getLocalHost();
        } else if (NetUtils.isInvalidLocalHost(hostToRegistry)) {
            throw new IllegalArgumentException("Specified invalid registry ip from property:DUBBO_IP_TO_REGISTRY, value:" + hostToRegistry);
        }
        map.put("register.ip", hostToRegistry);
        this.serviceMetadata.getAttachments().putAll(map);
        this.ref = this.createProxy(map);
        this.serviceMetadata.setTarget(this.ref);
        this.serviceMetadata.addAttribute("refClass", this.ref);
        ConsumerModel consumerModel = this.repository.lookupReferredService(this.serviceMetadata.getServiceKey());
        consumerModel.setProxyObject(this.ref);
        consumerModel.init(attributes);
        this.initialized = true;
        this.checkInvokerAvailable();
        this.dispatch(new ReferenceConfigInitializedEvent(this, this.invoker));
    }

    private T createProxy(Map<String, String> map) {
        if (this.shouldJvmRefer(map)) {
            URL url = new URL("injvm", "127.0.0.1", 0, this.interfaceClass.getName()).addParameters(map);
            this.invoker = REF_PROTOCOL.refer(this.interfaceClass, url);
            if (logger.isInfoEnabled()) {
                logger.info("Using injvm service " + this.interfaceClass.getName());
            }
        } else {
            Iterator us;
            this.urls.clear();
            if (this.url != null && this.url.length() > 0) {
                us = CommonConstants.SEMICOLON_SPLIT_PATTERN.split(this.url);
                if (us != null && ((String[])us).length > 0) {
                    for (Object u : us) {
                        URL url = URL.valueOf((String)u);
                        if (StringUtils.isEmpty(url.getPath())) {
                            url = url.setPath(this.interfaceName);
                        }
                        if (UrlUtils.isRegistry(url)) {
                            this.urls.add(url.addParameterAndEncoded("refer", StringUtils.toQueryString(map)));
                            continue;
                        }
                        this.urls.add(ClusterUtils.mergeUrl(url, map));
                    }
                }
            } else if (!"injvm".equalsIgnoreCase(this.getProtocol())) {
                this.checkRegistry();
                us = ConfigValidationUtils.loadRegistries(this, false);
                if (CollectionUtils.isNotEmpty(us)) {
                    Iterator iterator = us.iterator();
                    while (iterator.hasNext()) {
                        URL u = (URL)iterator.next();
                        URL monitorUrl = ConfigValidationUtils.loadMonitor(this, u);
                        if (monitorUrl != null) {
                            map.put("monitor", URL.encode(monitorUrl.toFullString()));
                        }
                        this.urls.add(u.addParameterAndEncoded("refer", StringUtils.toQueryString(map)));
                    }
                }
                if (this.urls.isEmpty()) {
                    throw new IllegalStateException("No such any registry to reference " + this.interfaceName + " on the consumer " + NetUtils.getLocalHost() + " use dubbo version " + Version.getVersion() + ", please config <dubbo:registry address=\"...\" /> to your spring config.");
                }
            }
            if (this.urls.size() == 1) {
                this.invoker = REF_PROTOCOL.refer(this.interfaceClass, (URL)this.urls.get(0));
            } else {
                String cluster;
                ArrayList invokers = new ArrayList();
                URL registryURL = null;
                for (URL url : this.urls) {
                    Invoker referInvoker = REF_PROTOCOL.refer(this.interfaceClass, url);
                    if (this.shouldCheck()) {
                        if (referInvoker.isAvailable()) {
                            invokers.add(referInvoker);
                        } else {
                            referInvoker.destroy();
                        }
                    } else {
                        invokers.add(referInvoker);
                    }
                    if (!UrlUtils.isRegistry(url)) continue;
                    registryURL = url;
                }
                if (this.shouldCheck() && invokers.size() == 0) {
                    throw new IllegalStateException("Failed to check the status of the service " + this.interfaceName + ". No provider available for the service " + (this.group == null ? "" : this.group + "/") + this.interfaceName + (this.version == null ? "" : ":" + this.version) + " from the multi registry cluster use dubbo version " + Version.getVersion());
                }
                if (registryURL != null) {
                    cluster = registryURL.getParameter("cluster", "zone-aware");
                    this.invoker = Cluster.getCluster(cluster, false).join(new StaticDirectory(registryURL, invokers));
                } else {
                    cluster = CollectionUtils.isNotEmpty(invokers) ? (((Invoker)invokers.get(0)).getUrl() != null ? ((Invoker)invokers.get(0)).getUrl().getParameter("cluster", "zone-aware") : "failover") : "failover";
                    this.invoker = Cluster.getCluster(cluster).join(new StaticDirectory(invokers));
                }
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("Refer dubbo service " + this.interfaceClass.getName() + " from url " + this.invoker.getUrl());
        }
        URL consumerURL = new URL("consumer", map.remove("register.ip"), 0, map.get("interface"), map);
        MetadataUtils.publishServiceDefinition(consumerURL);
        return (T)PROXY_FACTORY.getProxy(this.invoker, ProtocolUtils.isGeneric(this.generic));
    }

    private void checkInvokerAvailable() throws IllegalStateException {
        if (this.shouldCheck() && !this.invoker.isAvailable()) {
            this.invoker.destroy();
            throw new IllegalStateException("Failed to check the status of the service " + this.interfaceName + ". No provider available for the service " + (this.group == null ? "" : this.group + "/") + this.interfaceName + (this.version == null ? "" : ":" + this.version) + " from the url " + this.invoker.getUrl() + " to the consumer " + NetUtils.getLocalHost() + " use dubbo version " + Version.getVersion());
        }
    }

    public void checkAndUpdateSubConfigs() {
        if (StringUtils.isEmpty(this.interfaceName)) {
            throw new IllegalStateException("<dubbo:reference interface=\"\" /> interface not allow null!");
        }
        this.completeCompoundConfigs(this.consumer);
        this.checkDefault();
        List<ConfigInitializer> configInitializers = ExtensionLoader.getExtensionLoader(ConfigInitializer.class).getActivateExtension(URL.valueOf("configInitializer://"), (String[])null);
        configInitializers.forEach(e -> e.initReferConfig(this));
        this.refresh();
        if (this.getGeneric() == null && this.getConsumer() != null) {
            this.setGeneric(this.getConsumer().getGeneric());
        }
        if (ProtocolUtils.isGeneric(this.generic)) {
            this.interfaceClass = GenericService.class;
        } else {
            try {
                this.interfaceClass = Class.forName(this.interfaceName, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e2) {
                throw new IllegalStateException(e2.getMessage(), e2);
            }
            this.checkInterfaceAndMethods(this.interfaceClass, this.getMethods());
        }
        this.initServiceMetadata(this.consumer);
        this.serviceMetadata.setServiceType(this.getActualInterface());
        this.serviceMetadata.setServiceKey(URL.buildKey(this.interfaceName, this.group, this.version));
        ServiceRepository repository = ApplicationModel.getServiceRepository();
        ServiceDescriptor serviceDescriptor = repository.registerService(this.interfaceClass);
        repository.registerConsumer(this.serviceMetadata.getServiceKey(), serviceDescriptor, this, null, this.serviceMetadata);
        this.resolveFile();
        ConfigValidationUtils.validateReferenceConfig(this);
        this.postProcessConfig();
    }

    protected boolean shouldJvmRefer(Map<String, String> map) {
        URL tmpUrl = new URL("temp", "localhost", 0, map);
        boolean isJvmRefer = this.isInjvm() == null ? (this.url != null && this.url.length() > 0 ? false : InjvmProtocol.getInjvmProtocol().isInjvmRefer(tmpUrl)) : this.isInjvm();
        return isJvmRefer;
    }

    protected void dispatch(Event event) {
        EventDispatcher.getDefaultExtension().dispatch(event);
    }

    public DubboBootstrap getBootstrap() {
        return this.bootstrap;
    }

    public void setBootstrap(DubboBootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }

    private void postProcessConfig() {
        List<ConfigPostProcessor> configPostProcessors = ExtensionLoader.getExtensionLoader(ConfigPostProcessor.class).getActivateExtension(URL.valueOf("configPostProcessor://"), (String[])null);
        configPostProcessors.forEach(component -> component.postProcessReferConfig(this));
    }

    Invoker<?> getInvoker() {
        return this.invoker;
    }
}

