/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.util.IOUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.Locale;

abstract class FieldReaderDateTimeCodec<T>
extends FieldReader<T> {
    DateTimeFormatter formatter;
    ObjectReader dateReader;
    final boolean useSimpleFormatter;
    final boolean formatISO8601;
    final boolean formatUnixTime;
    final boolean formatMillis;
    final boolean formatHasDay;
    final boolean formatHasHour;
    final boolean yyyyMMddhhmmss19;

    public FieldReaderDateTimeCodec(String fieldName, Type fieldType, Class fieldClass, int ordinal, long features, String format, Locale locale, Object defaultValue, JSONSchema schema, Method method, Field field) {
        super(fieldName, fieldType, fieldClass, ordinal, features, format, locale, defaultValue, schema, method, field);
        this.useSimpleFormatter = "yyyyMMddHHmmssSSSZ".equals(format);
        this.yyyyMMddhhmmss19 = "yyyy-MM-dd HH:mm:ss".equals(format);
        boolean formatUnixTime = false;
        boolean formatISO8601 = false;
        boolean formatMillis = false;
        boolean hasDay = false;
        boolean hasHour = false;
        if (format != null) {
            switch (format) {
                case "unixtime": {
                    formatUnixTime = true;
                    break;
                }
                case "iso8601": {
                    formatISO8601 = true;
                    break;
                }
                case "millis": {
                    formatMillis = true;
                    break;
                }
                default: {
                    hasDay = format.indexOf(100) != -1;
                    hasHour = format.indexOf(72) != -1 || format.indexOf(104) != -1 || format.indexOf(75) != -1 || format.indexOf(107) != -1;
                }
            }
        }
        this.formatUnixTime = formatUnixTime;
        this.formatMillis = formatMillis;
        this.formatISO8601 = formatISO8601;
        this.formatHasDay = hasDay;
        this.formatHasHour = hasHour;
    }

    @Override
    public Object readFieldValue(JSONReader jsonReader) {
        Object fieldValue;
        if (jsonReader.isInt()) {
            long millis = jsonReader.readInt64Value();
            if (this.formatUnixTime) {
                millis *= 1000L;
            }
            fieldValue = this.apply(millis);
        } else {
            if (jsonReader.isNull()) {
                jsonReader.readNull();
                return null;
            }
            if (this.useSimpleFormatter) {
                String str = jsonReader.readString();
                try {
                    Date date = new SimpleDateFormat(this.format).parse(str);
                    fieldValue = this.apply(date);
                }
                catch (ParseException e) {
                    throw new JSONException(jsonReader.info("parse error : " + str), e);
                }
            } else if (this.formatISO8601) {
                ZonedDateTime zdt = jsonReader.readZonedDateTime();
                fieldValue = this.apply(zdt);
            } else {
                if (this.yyyyMMddhhmmss19) {
                    long millis = (jsonReader.features(this.features) & JSONReader.Feature.SupportSmartMatch.mask) != 0L && jsonReader.isString() ? jsonReader.readMillisFromString() : jsonReader.readMillis19();
                    return this.apply(millis);
                }
                if (this.format != null) {
                    String str = jsonReader.readString();
                    if ((this.formatUnixTime || this.formatMillis) && IOUtils.isNumber(str)) {
                        long millis = Long.parseLong(str);
                        if (this.formatUnixTime) {
                            millis *= 1000L;
                        }
                        return this.apply(millis);
                    }
                    DateTimeFormatter formatter = this.getFormatter(jsonReader.getLocale());
                    LocalDateTime ldt = !this.formatHasHour ? LocalDateTime.of(LocalDate.parse(str, formatter), LocalTime.MIN) : LocalDateTime.parse(str, formatter);
                    ZonedDateTime zdt = ldt.atZone(jsonReader.getContext().getZoneId());
                    fieldValue = this.apply(zdt);
                } else {
                    long millis = jsonReader.readMillisFromString();
                    fieldValue = this.apply(millis);
                }
            }
        }
        return fieldValue;
    }

    protected DateTimeFormatter getFormatter(Locale locale) {
        if (this.formatter != null && locale == null) {
            return this.formatter;
        }
        String format = this.format.replaceAll("aa", "a");
        if (locale != null && locale != Locale.getDefault()) {
            return DateTimeFormatter.ofPattern(format, locale);
        }
        if (this.locale != null) {
            this.formatter = DateTimeFormatter.ofPattern(format, this.locale);
            return this.formatter;
        }
        this.formatter = DateTimeFormatter.ofPattern(format);
        return this.formatter;
    }

    @Override
    public abstract ObjectReader getObjectReader(JSONReader var1);

    @Override
    public abstract ObjectReader getObjectReader(JSONReader.Context var1);

    protected abstract void accept(T var1, Date var2);

    protected abstract void acceptNull(T var1);

    protected abstract void accept(T var1, Instant var2);

    protected abstract void accept(T var1, LocalDateTime var2);

    protected abstract void accept(T var1, ZonedDateTime var2);

    protected abstract Object apply(Date var1);

    protected abstract Object apply(Instant var1);

    protected abstract Object apply(ZonedDateTime var1);

    protected abstract Object apply(LocalDateTime var1);

    protected abstract Object apply(long var1);

    @Override
    public void accept(T object, Object value) {
        if (value == null) {
            this.acceptNull(object);
            return;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                this.acceptNull(object);
                return;
            }
            if ((this.format == null || this.formatUnixTime || this.formatMillis) && IOUtils.isNumber(str)) {
                long millis = Long.parseLong(str);
                if (this.formatUnixTime) {
                    millis *= 1000L;
                }
                this.accept(object, millis);
                return;
            }
            value = DateUtils.parseDate(str, this.format, DateUtils.DEFAULT_ZONE_ID);
        }
        if (value instanceof Date) {
            this.accept(object, (Date)value);
        } else if (value instanceof Instant) {
            this.accept(object, (Instant)value);
        } else if (value instanceof Long) {
            this.accept(object, (Long)value);
        } else if (value instanceof LocalDateTime) {
            this.accept(object, (LocalDateTime)value);
        } else {
            throw new JSONException("not support value " + value.getClass());
        }
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        Date fieldValue;
        block21: {
            try {
                if (jsonReader.isInt() && (this.format == null || this.formatUnixTime || this.formatMillis)) {
                    long millis = jsonReader.readInt64Value();
                    if (this.formatUnixTime) {
                        millis *= 1000L;
                    }
                    this.accept(object, millis);
                    return;
                }
                if (jsonReader.isNull()) {
                    jsonReader.readNull();
                    fieldValue = null;
                    break block21;
                }
                if (this.useSimpleFormatter) {
                    String str = jsonReader.readString();
                    try {
                        fieldValue = new SimpleDateFormat(this.format).parse(str);
                        break block21;
                    }
                    catch (ParseException e) {
                        throw new JSONException(jsonReader.info("parse error : " + str), e);
                    }
                }
                if (this.format != null) {
                    long millis;
                    String str = jsonReader.readString();
                    if (str.isEmpty() || "null".equals(str)) {
                        fieldValue = null;
                        break block21;
                    }
                    if ((this.formatUnixTime || this.formatMillis) && IOUtils.isNumber(str)) {
                        millis = Long.parseLong(str);
                        if (this.formatUnixTime) {
                            millis *= 1000L;
                        }
                    } else {
                        LocalDateTime ldt;
                        Locale locale = jsonReader.getContext().getLocale();
                        DateTimeFormatter formatter = this.getFormatter(locale);
                        if (!this.formatHasHour) {
                            ldt = LocalDateTime.of(LocalDate.parse(str, formatter), LocalTime.MIN);
                        } else {
                            try {
                                ldt = LocalDateTime.parse(str, formatter);
                            }
                            catch (DateTimeParseException e) {
                                if (jsonReader.isSupportSmartMatch(this.features)) {
                                    ldt = DateUtils.parseZonedDateTime(str).toLocalDateTime();
                                }
                                throw e;
                            }
                        }
                        ZonedDateTime zdt = ldt.atZone(jsonReader.getContext().getZoneId());
                        millis = zdt.toInstant().toEpochMilli();
                    }
                    fieldValue = new Date(millis);
                    break block21;
                }
                if (jsonReader.nextIfNullOrEmptyString()) {
                    fieldValue = null;
                } else {
                    long millis = jsonReader.readMillisFromString();
                    fieldValue = new Date(millis);
                }
            }
            catch (Exception e) {
                if ((jsonReader.features(this.features) & JSONReader.Feature.NullOnError.mask) != 0L) {
                    fieldValue = null;
                }
                throw e;
            }
        }
        this.accept(object, fieldValue);
    }

    @Override
    public boolean supportAcceptType(Class valueClass) {
        return valueClass == Date.class || valueClass == String.class;
    }
}

