/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.impl;

import com.google.common.collect.Lists;
import com.xiaomi.youpin.docean.anno.Service;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ozhera.app.api.response.AppBaseInfo;
import org.apache.ozhera.log.common.Config;
import org.apache.ozhera.log.common.Result;
import org.apache.ozhera.log.exception.CommonError;
import org.apache.ozhera.log.manager.dao.MilogLogTailDao;
import org.apache.ozhera.log.manager.dao.MilogLogstoreDao;
import org.apache.ozhera.log.manager.dao.MilogStoreSpaceAuthDao;
import org.apache.ozhera.log.manager.model.dto.MapDTO;
import org.apache.ozhera.log.manager.model.dto.MilogSpaceTreeDTO;
import org.apache.ozhera.log.manager.model.dto.UnAccessAppDTO;
import org.apache.ozhera.log.manager.model.dto.ValueDTO;
import org.apache.ozhera.log.manager.model.pojo.MilogLogStoreDO;
import org.apache.ozhera.log.manager.model.pojo.MilogLogTailDo;
import org.apache.ozhera.log.manager.model.pojo.MilogStoreSpaceAuth;
import org.apache.ozhera.log.manager.service.HeralogHomePageService;
import org.apache.ozhera.log.manager.service.impl.HeraAppServiceImpl;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class HeralogHomePageServiceImpl
implements HeralogHomePageService {
    private static final Logger log = LoggerFactory.getLogger(HeralogHomePageServiceImpl.class);
    @Resource
    private MilogLogTailDao milogLogtailDao;
    @Resource
    private HeraAppServiceImpl heraAppService;
    @Resource
    private MilogLogstoreDao milogLogstoreDao;
    @Resource
    private MilogStoreSpaceAuthDao milogStoreSpaceAuthDao;
    private List<ValueDTO<String>> milogpattern;

    public HeralogHomePageServiceImpl() {
        String pattern = Config.ins().get("milogpattern", "");
        String[] split = pattern.split(",");
        ArrayList<ValueDTO<String>> valueDTOS = new ArrayList<ValueDTO<String>>();
        for (String s : split) {
            valueDTOS.add(new ValueDTO<String>(s));
        }
        this.milogpattern = valueDTOS;
    }

    @Override
    public Result<Map<String, Object>> milogAccess() {
        Long total = this.heraAppService.getAppCount();
        int access = this.milogLogtailDao.appCount();
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("total", total);
        map.put("access", access);
        return new Result(CommonError.Success.getCode(), CommonError.Success.getMessage(), map);
    }

    @Override
    public Result<List<UnAccessAppDTO>> unAccessAppList() {
        List<AppBaseInfo> appBaseInfos = this.heraAppService.queryAllExistsApp();
        Map<Integer, String> appMap = appBaseInfos.stream().collect(Collectors.toMap(AppBaseInfo::getId, AppBaseInfo::getAppName));
        List<Integer> hasAccessAppId = this.milogLogtailDao.queryAllAppId();
        ArrayList<UnAccessAppDTO> list = new ArrayList<UnAccessAppDTO>();
        for (Map.Entry<Integer, String> app : appMap.entrySet()) {
            if (hasAccessAppId.contains(app.getKey())) continue;
            list.add(new UnAccessAppDTO(app.getKey().longValue(), app.getValue()));
        }
        return new Result(CommonError.Success.getCode(), CommonError.Success.getMessage(), list);
    }

    @Override
    public Result<List<MilogSpaceTreeDTO>> getMilogSpaceTree(Long spaceId) {
        List<MilogLogStoreDO> stores = this.getMilogLogStoreDOS(spaceId);
        List spaceTreeDTOS = stores.stream().map(milogLogstoreDO -> {
            Long logstoreDOId = milogLogstoreDO.getId();
            MilogSpaceTreeDTO milogSpaceTreeDTO = new MilogSpaceTreeDTO();
            milogSpaceTreeDTO.setLabel(milogLogstoreDO.getLogstoreName());
            milogSpaceTreeDTO.setValue(logstoreDOId);
            List<MilogLogTailDo> logTailDos = this.milogLogtailDao.getMilogLogtailByStoreId(logstoreDOId);
            if (CollectionUtils.isNotEmpty(logTailDos)) {
                List<MapDTO<String, Long>> collect = logTailDos.stream().map(logTailDo -> {
                    MapDTO<String, Long> mapDTO = new MapDTO<String, Long>();
                    mapDTO.setValue(logTailDo.getId());
                    mapDTO.setLabel(logTailDo.getTail());
                    return mapDTO;
                }).collect(Collectors.toList());
                milogSpaceTreeDTO.setChildren(collect);
            }
            return milogSpaceTreeDTO;
        }).collect(Collectors.toList());
        return Result.success(spaceTreeDTOS);
    }

    @Override
    @Nullable
    public List<MilogLogStoreDO> getMilogLogStoreDOS(Long spaceId) {
        List<Object> storeDOS = Lists.newArrayList();
        List<MilogLogStoreDO> stores = this.milogLogstoreDao.getMilogLogstoreBySpaceId(spaceId);
        List<MilogStoreSpaceAuth> storeSpaceAuths = this.milogStoreSpaceAuthDao.queryStoreIdsBySpaceId(spaceId);
        if (CollectionUtils.isNotEmpty(stores)) {
            storeDOS = stores;
        }
        if (CollectionUtils.isNotEmpty(storeSpaceAuths)) {
            List collect = storeSpaceAuths.stream().map(storeSpaceAuth -> this.milogLogstoreDao.queryById(storeSpaceAuth.getStoreId())).filter(Objects::nonNull).collect(Collectors.toList());
            storeDOS.addAll(collect);
        }
        return storeDOS;
    }

    @Override
    public Result<List<ValueDTO<String>>> getMiloglogAccessPattern() {
        return new Result(CommonError.Success.getCode(), CommonError.Success.getMessage(), this.milogpattern);
    }
}

