/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.agent.common;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorUtil {
    private static final Logger log = LoggerFactory.getLogger(ExecutorUtil.class);
    public static ScheduledThreadPoolExecutor STP_EXECUTOR = new ScheduledThreadPoolExecutor(20, Thread.ofVirtual().name("ExecutorUtil-STP-Virtual-Thread", 0L).uncaughtExceptionHandler((t, e) -> log.error("ExecutorUtil-STP-Virtual-Thread uncaughtException:{}", (Object)e.getMessage(), (Object)e)).factory());
    public static ExecutorService TP_EXECUTOR = ExecutorUtil.createPool();

    public static ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return STP_EXECUTOR.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    public static ExecutorService createPool() {
        System.setProperty("jdk.virtualThreadScheduler.parallelism", String.valueOf(Runtime.getRuntime().availableProcessors() + 1));
        ThreadFactory factory = Thread.ofVirtual().name("ExecutorUtil-TP-Virtual-Thread", 0L).uncaughtExceptionHandler((t, e) -> log.error("ExecutorUtil-TP-Virtual-Thread uncaughtException:{}", (Object)e.getMessage(), (Object)e)).factory();
        return Executors.newThreadPerTaskExecutor(factory);
    }

    public static Future<?> submit(Runnable task) {
        log.warn("TP_EXECUTOR submit task:{}", (Object)task.toString());
        return TP_EXECUTOR.submit(task);
    }

    static {
        STP_EXECUTOR.scheduleAtFixedRate(() -> {
            log.warn("Executor statistic TP_EXECUTOR:{}", (Object)TP_EXECUTOR.toString());
            log.warn("Executor statistic STP_EXECUTOR:{}", (Object)STP_EXECUTOR.toString());
        }, 17L, 30L, TimeUnit.SECONDS);
    }
}

