/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api.dom.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.mybatis.generator.api.dom.OutputUtilities;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaDomUtils;
import org.mybatis.generator.api.dom.java.JavaElement;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TypeParameter;

public class Method
extends JavaElement {
    private List<String> bodyLines = new ArrayList<String>();
    private boolean constructor;
    private FullyQualifiedJavaType returnType;
    private String name;
    private List<TypeParameter> typeParameters = new ArrayList<TypeParameter>();
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private List<FullyQualifiedJavaType> exceptions = new ArrayList<FullyQualifiedJavaType>();
    private boolean isSynchronized;
    private boolean isNative;
    private boolean isDefault;

    public Method() {
        this("bar");
    }

    public Method(String name) {
        this.name = name;
    }

    public Method(Method original) {
        super(original);
        this.bodyLines.addAll(original.bodyLines);
        this.constructor = original.constructor;
        this.exceptions.addAll(original.exceptions);
        this.name = original.name;
        this.typeParameters.addAll(original.typeParameters);
        this.parameters.addAll(original.parameters);
        this.returnType = original.returnType;
        this.isNative = original.isNative;
        this.isSynchronized = original.isSynchronized;
    }

    public List<String> getBodyLines() {
        return this.bodyLines;
    }

    public void addBodyLine(String line) {
        this.bodyLines.add(line);
    }

    public void addBodyLine(int index, String line) {
        this.bodyLines.add(index, line);
    }

    public void addBodyLines(Collection<String> lines) {
        this.bodyLines.addAll(lines);
    }

    public void addBodyLines(int index, Collection<String> lines) {
        this.bodyLines.addAll(index, lines);
    }

    public String getFormattedContent(int indentLevel, boolean interfaceMethod, CompilationUnit compilationUnit) {
        boolean comma;
        StringBuilder sb = new StringBuilder();
        this.addFormattedJavadoc(sb, indentLevel);
        this.addFormattedAnnotations(sb, indentLevel);
        OutputUtilities.javaIndent(sb, indentLevel);
        if (interfaceMethod) {
            if (this.isStatic()) {
                sb.append("static ");
            } else if (this.isDefault()) {
                sb.append("default ");
            }
        } else {
            sb.append(this.getVisibility().getValue());
            if (this.isStatic()) {
                sb.append("static ");
            }
            if (this.isFinal()) {
                sb.append("final ");
            }
            if (this.isSynchronized()) {
                sb.append("synchronized ");
            }
            if (this.isNative()) {
                sb.append("native ");
            } else if (this.bodyLines.size() == 0) {
                sb.append("abstract ");
            }
        }
        if (!this.getTypeParameters().isEmpty()) {
            sb.append("<");
            comma = false;
            for (TypeParameter typeParameter : this.getTypeParameters()) {
                if (comma) {
                    sb.append(", ");
                } else {
                    comma = true;
                }
                sb.append(typeParameter.getFormattedContent(compilationUnit));
            }
            sb.append("> ");
        }
        if (!this.constructor) {
            if (this.getReturnType() == null) {
                sb.append("void");
            } else {
                sb.append(JavaDomUtils.calculateTypeName(compilationUnit, this.getReturnType()));
            }
            sb.append(' ');
        }
        sb.append(this.getName());
        sb.append('(');
        comma = false;
        for (Parameter parameter : this.getParameters()) {
            if (comma) {
                sb.append(", ");
            } else {
                comma = true;
            }
            sb.append(parameter.getFormattedContent(compilationUnit));
        }
        sb.append(')');
        if (this.getExceptions().size() > 0) {
            sb.append(" throws ");
            comma = false;
            for (FullyQualifiedJavaType fqjt : this.getExceptions()) {
                if (comma) {
                    sb.append(", ");
                } else {
                    comma = true;
                }
                sb.append(JavaDomUtils.calculateTypeName(compilationUnit, fqjt));
            }
        }
        if (this.bodyLines.size() == 0 || this.isNative()) {
            sb.append(';');
        } else {
            sb.append(" {");
            ++indentLevel;
            ListIterator<String> listIter = this.bodyLines.listIterator();
            while (listIter.hasNext()) {
                String line = listIter.next();
                if (line.startsWith("}")) {
                    --indentLevel;
                }
                OutputUtilities.newLine(sb);
                OutputUtilities.javaIndent(sb, indentLevel);
                sb.append(line);
                if (line.endsWith("{") && !line.startsWith("switch") || line.endsWith(":")) {
                    ++indentLevel;
                }
                if (!line.startsWith("break")) continue;
                if (listIter.hasNext()) {
                    String nextLine = listIter.next();
                    if (nextLine.startsWith("}")) {
                        ++indentLevel;
                    }
                    listIter.previous();
                }
                --indentLevel;
            }
            OutputUtilities.newLine(sb);
            OutputUtilities.javaIndent(sb, --indentLevel);
            sb.append('}');
        }
        return sb.toString();
    }

    public boolean isConstructor() {
        return this.constructor;
    }

    public void setConstructor(boolean constructor) {
        this.constructor = constructor;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<TypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    public void addTypeParameter(TypeParameter typeParameter) {
        this.typeParameters.add(typeParameter);
    }

    public void addTypeParameter(int index, TypeParameter typeParameter) {
        this.typeParameters.add(index, typeParameter);
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void addParameter(Parameter parameter) {
        this.parameters.add(parameter);
    }

    public void addParameter(int index, Parameter parameter) {
        this.parameters.add(index, parameter);
    }

    public FullyQualifiedJavaType getReturnType() {
        return this.returnType;
    }

    public void setReturnType(FullyQualifiedJavaType returnType) {
        this.returnType = returnType;
    }

    public List<FullyQualifiedJavaType> getExceptions() {
        return this.exceptions;
    }

    public void addException(FullyQualifiedJavaType exception) {
        this.exceptions.add(exception);
    }

    public boolean isSynchronized() {
        return this.isSynchronized;
    }

    public void setSynchronized(boolean isSynchronized) {
        this.isSynchronized = isSynchronized;
    }

    public boolean isNative() {
        return this.isNative;
    }

    public void setNative(boolean isNative) {
        this.isNative = isNative;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }
}

