/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.hertzbeat.alert.dto.ExportAlertDefineDTO;
import org.apache.hertzbeat.alert.service.impl.AlertDefineAbstractImExportServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AlertDefineJsonImExportServiceImpl
extends AlertDefineAbstractImExportServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(AlertDefineJsonImExportServiceImpl.class);
    private final ObjectMapper objectMapper;

    @Override
    public String type() {
        return "JSON";
    }

    @Override
    public String getFileName() {
        return this.fileNamePrefix() + ".json";
    }

    @Override
    public List<ExportAlertDefineDTO> parseImport(InputStream is) {
        try {
            return (List)this.objectMapper.readValue(is, (TypeReference)new TypeReference<List<ExportAlertDefineDTO>>(){});
        }
        catch (IOException ex) {
            log.error("import alertDefine failed.", (Throwable)ex);
            throw new RuntimeException("import alertDefine failed");
        }
    }

    @Override
    public void writeOs(List<ExportAlertDefineDTO> exportAlertDefineList, OutputStream os) {
        try {
            this.objectMapper.writeValue(os, exportAlertDefineList);
        }
        catch (IOException ex) {
            log.error("export alertDefine failed.", (Throwable)ex);
            throw new RuntimeException("export alertDefine failed");
        }
    }

    public AlertDefineJsonImExportServiceImpl(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

