/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.statistics;

import java.util.regex.Pattern;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.format.FieldStats;
import org.apache.paimon.statistics.AbstractFieldStatsCollector;
import org.apache.paimon.utils.Preconditions;

public class TruncateFieldStatsCollector
extends AbstractFieldStatsCollector {
    public static final Pattern TRUNCATE_PATTERN = Pattern.compile("TRUNCATE\\((\\d+)\\)");
    private final int length;
    private boolean failed = false;

    public TruncateFieldStatsCollector(int length) {
        Preconditions.checkArgument(length > 0, "Truncate length should larger than zero.");
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public void collect(Object field, Serializer<Object> fieldSerializer) {
        Object max;
        if (field == null) {
            ++this.nullCount;
            return;
        }
        if (!(field instanceof Comparable)) {
            return;
        }
        Comparable c = (Comparable)field;
        if (this.minValue == null || c.compareTo(this.minValue) < 0) {
            this.minValue = fieldSerializer.copy(this.truncateMin(field));
        }
        if ((this.maxValue == null || c.compareTo(this.maxValue) > 0) && (max = this.truncateMax(field)) != null) {
            this.maxValue = fieldSerializer.copy(this.truncateMax(field));
        }
    }

    @Override
    public FieldStats convert(FieldStats source) {
        Object min = this.truncateMin(source.minValue());
        Object max = this.truncateMax(source.maxValue());
        if (max == null) {
            return new FieldStats(null, null, source.nullCount());
        }
        return new FieldStats(min, max, source.nullCount());
    }

    @Override
    public FieldStats result() {
        if (this.failed) {
            return new FieldStats(null, null, this.nullCount);
        }
        return new FieldStats(this.minValue, this.maxValue, this.nullCount);
    }

    private Object truncateMin(Object field) {
        if (field == null) {
            return null;
        }
        if (field instanceof BinaryString) {
            return ((BinaryString)field).substring(0, this.length);
        }
        return field;
    }

    private Object truncateMax(Object field) {
        if (field == null) {
            return null;
        }
        if (field instanceof BinaryString) {
            BinaryString original = (BinaryString)field;
            BinaryString truncated = original.substring(0, this.length);
            if (original.getSizeInBytes() == truncated.getSizeInBytes()) {
                return field;
            }
            StringBuilder truncatedStringBuilder = new StringBuilder(truncated.toString());
            for (int i = this.length - 1; i >= 0; --i) {
                int offsetByCodePoint = truncatedStringBuilder.offsetByCodePoints(0, i);
                int nextCodePoint = truncatedStringBuilder.codePointAt(offsetByCodePoint) + 1;
                if (nextCodePoint == 0 || !Character.isValidCodePoint(nextCodePoint)) continue;
                truncatedStringBuilder.setLength(offsetByCodePoint);
                truncatedStringBuilder.appendCodePoint(nextCodePoint);
                return BinaryString.fromString(truncatedStringBuilder.toString());
            }
            this.failed = true;
            return null;
        }
        return field;
    }
}

