/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import javax.annotation.Nullable;
import org.apache.paimon.Snapshot;
import org.apache.paimon.table.source.OutOfRangeException;
import org.apache.paimon.utils.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NextSnapshotFetcher {
    public static final Logger LOG = LoggerFactory.getLogger(NextSnapshotFetcher.class);
    private final SnapshotManager snapshotManager;
    private final boolean changelogDecoupled;
    private final boolean changelogAsFollowup;

    public NextSnapshotFetcher(SnapshotManager snapshotManager, boolean changelogDecoupled, boolean changelogAsFollowup) {
        this.snapshotManager = snapshotManager;
        this.changelogDecoupled = changelogDecoupled;
        this.changelogAsFollowup = changelogAsFollowup;
    }

    @Nullable
    public Snapshot getNextSnapshot(long nextSnapshotId) {
        if (this.snapshotManager.snapshotExists(nextSnapshotId)) {
            return this.snapshotManager.snapshot(nextSnapshotId);
        }
        Long earliestSnapshotId = this.snapshotManager.earliestSnapshotId();
        if (earliestSnapshotId == null || earliestSnapshotId <= nextSnapshotId) {
            LOG.debug("Next snapshot id {} does not exist, wait for the snapshot generation.", (Object)nextSnapshotId);
            return null;
        }
        if (!(this.changelogAsFollowup && this.changelogDecoupled && this.snapshotManager.longLivedChangelogExists(nextSnapshotId))) {
            throw new OutOfRangeException(String.format("The snapshot with id %d has expired. You can: 1. increase the snapshot or changelog expiration time. 2. use consumer-id to ensure that unconsumed snapshots will not be expired.", nextSnapshotId));
        }
        return this.snapshotManager.changelog(nextSnapshotId);
    }
}

