/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.UpdateProperties;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.Tasks;

class PropertiesUpdate
implements UpdateProperties {
    private final TableOperations ops;
    private final Map<String, String> updates = Maps.newHashMap();
    private final Set<String> removals = Sets.newHashSet();
    private TableMetadata base;

    PropertiesUpdate(TableOperations ops) {
        this.ops = ops;
        this.base = ops.current();
    }

    public UpdateProperties set(String key, String value) {
        Preconditions.checkNotNull((Object)key, (Object)"Key cannot be null");
        Preconditions.checkNotNull((Object)value, (Object)"Value cannot be null");
        Preconditions.checkArgument((!this.removals.contains(key) ? 1 : 0) != 0, (String)"Cannot remove and update the same key: %s", (Object)key);
        this.updates.put(key, value);
        return this;
    }

    public UpdateProperties remove(String key) {
        Preconditions.checkNotNull((Object)key, (Object)"Key cannot be null");
        Preconditions.checkArgument((!this.updates.keySet().contains(key) ? 1 : 0) != 0, (String)"Cannot remove and update the same key: %s", (Object)key);
        this.removals.add(key);
        return this;
    }

    public UpdateProperties defaultFormat(FileFormat format) {
        this.set("write.format.default", format.name());
        return this;
    }

    public Map<String, String> apply() {
        this.base = this.ops.refresh();
        HashMap newProperties = Maps.newHashMap();
        for (Map.Entry<String, String> entry : this.base.properties().entrySet()) {
            if (this.removals.contains(entry.getKey())) continue;
            newProperties.put(entry.getKey(), entry.getValue());
        }
        newProperties.putAll(this.updates);
        if (this.base != null && this.base.schema() != null) {
            MetricsConfig.fromProperties(newProperties).validateReferencedColumns(this.base.schema());
        }
        return newProperties;
    }

    public void commit() {
        Tasks.foreach(this.ops).retry(this.base.propertyAsInt("commit.retry.num-retries", 4)).exponentialBackoff(this.base.propertyAsInt("commit.retry.min-wait-ms", 100), this.base.propertyAsInt("commit.retry.max-wait-ms", 60000), this.base.propertyAsInt("commit.retry.total-timeout-ms", 1800000), 2.0).onlyRetryOn((Class<Exception>)CommitFailedException.class).run(taskOps -> {
            Object newProperties = this.apply();
            TableMetadata updated = this.base.replaceProperties((Map<String, String>)newProperties);
            taskOps.commit(this.base, updated);
        });
    }
}

