/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.polling;

import com.azure.core.http.rest.Response;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.polling.SyncPollingStrategy;
import com.azure.core.util.serializer.TypeReference;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class SyncChainedPollingStrategy<T, U>
implements SyncPollingStrategy<T, U> {
    private static final ClientLogger LOGGER = new ClientLogger(SyncChainedPollingStrategy.class);
    private final List<SyncPollingStrategy<T, U>> pollingStrategies;
    private SyncPollingStrategy<T, U> pollableStrategy = null;

    public SyncChainedPollingStrategy(List<SyncPollingStrategy<T, U>> strategies) {
        Objects.requireNonNull(strategies, "'strategies' cannot be null.");
        if (strategies.isEmpty()) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'strategies' cannot be empty."));
        }
        this.pollingStrategies = Collections.unmodifiableList(strategies);
    }

    @Override
    public boolean canPoll(Response<?> initialResponse) {
        for (SyncPollingStrategy<T, U> strategy : this.pollingStrategies) {
            if (!strategy.canPoll(initialResponse)) continue;
            this.pollableStrategy = strategy;
            return true;
        }
        return false;
    }

    @Override
    public U getResult(PollingContext<T> context, TypeReference<U> resultType) {
        return this.pollableStrategy.getResult(context, resultType);
    }

    @Override
    public PollResponse<T> onInitialResponse(Response<?> response, PollingContext<T> pollingContext, TypeReference<T> pollResponseType) {
        return this.pollableStrategy.onInitialResponse(response, pollingContext, pollResponseType);
    }

    @Override
    public PollResponse<T> poll(PollingContext<T> context, TypeReference<T> pollResponseType) {
        return this.pollableStrategy.poll(context, pollResponseType);
    }

    @Override
    public T cancel(PollingContext<T> pollingContext, PollResponse<T> initialResponse) {
        return this.pollableStrategy.cancel(pollingContext, initialResponse);
    }
}

