/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers.metadata.source;

import com.google.i18n.phonenumbers.Phonemetadata;
import com.google.i18n.phonenumbers.metadata.source.MetadataContainer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class MapBackedMetadataContainer<T>
implements MetadataContainer {
    private final ConcurrentMap<T, Phonemetadata.PhoneMetadata> metadataMap = new ConcurrentHashMap<T, Phonemetadata.PhoneMetadata>();
    private final KeyProvider<T> keyProvider;

    static MapBackedMetadataContainer<String> byRegionCode() {
        return new MapBackedMetadataContainer<String>(new KeyProvider<String>(){

            @Override
            public String getKeyOf(Phonemetadata.PhoneMetadata phoneMetadata) {
                return phoneMetadata.getId();
            }
        });
    }

    static MapBackedMetadataContainer<Integer> byCountryCallingCode() {
        return new MapBackedMetadataContainer<Integer>(new KeyProvider<Integer>(){

            @Override
            public Integer getKeyOf(Phonemetadata.PhoneMetadata phoneMetadata) {
                return phoneMetadata.getCountryCode();
            }
        });
    }

    private MapBackedMetadataContainer(KeyProvider<T> keyProvider) {
        this.keyProvider = keyProvider;
    }

    Phonemetadata.PhoneMetadata getMetadataBy(T key) {
        return key != null ? (Phonemetadata.PhoneMetadata)this.metadataMap.get(key) : null;
    }

    KeyProvider<T> getKeyProvider() {
        return this.keyProvider;
    }

    @Override
    public void accept(Phonemetadata.PhoneMetadata phoneMetadata) {
        this.metadataMap.put(this.keyProvider.getKeyOf(phoneMetadata), phoneMetadata);
    }

    static interface KeyProvider<T> {
        public T getKeyOf(Phonemetadata.PhoneMetadata var1);
    }
}

