/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hcatalog;

import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.hive.hcatalog.data.schema.HCatFieldSchema;
import org.apache.hive.hcatalog.data.schema.HCatSchemaUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class SchemaUtils {
    private static final @UnknownKeyFor @NonNull @Initialized Map<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized HCatFieldSchema.Type, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType> HCAT_TO_BEAM_TYPES_MAP = ImmutableMap.builder().put((Object)HCatFieldSchema.Type.BOOLEAN, (Object)Schema.FieldType.BOOLEAN).put((Object)HCatFieldSchema.Type.TINYINT, (Object)Schema.FieldType.BYTE).put((Object)HCatFieldSchema.Type.SMALLINT, (Object)Schema.FieldType.INT16).put((Object)HCatFieldSchema.Type.INT, (Object)Schema.FieldType.INT32).put((Object)HCatFieldSchema.Type.BIGINT, (Object)Schema.FieldType.INT64).put((Object)HCatFieldSchema.Type.FLOAT, (Object)Schema.FieldType.FLOAT).put((Object)HCatFieldSchema.Type.DOUBLE, (Object)Schema.FieldType.DOUBLE).put((Object)HCatFieldSchema.Type.DECIMAL, (Object)Schema.FieldType.DECIMAL).put((Object)HCatFieldSchema.Type.STRING, (Object)Schema.FieldType.STRING).put((Object)HCatFieldSchema.Type.CHAR, (Object)Schema.FieldType.STRING).put((Object)HCatFieldSchema.Type.VARCHAR, (Object)Schema.FieldType.STRING).put((Object)HCatFieldSchema.Type.BINARY, (Object)Schema.FieldType.BYTES).put((Object)HCatFieldSchema.Type.DATE, (Object)Schema.FieldType.DATETIME).put((Object)HCatFieldSchema.Type.TIMESTAMP, (Object)Schema.FieldType.DATETIME).build();

    SchemaUtils() {
    }

    static @UnknownKeyFor @NonNull @Initialized Schema toBeamSchema(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldSchema> fields) {
        return (Schema)fields.stream().map(SchemaUtils::toBeamField).collect(Schema.toSchema());
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field toBeamField(@UnknownKeyFor @NonNull @Initialized FieldSchema field) {
        HCatFieldSchema hCatFieldSchema;
        String name = field.getName();
        try {
            hCatFieldSchema = HCatSchemaUtils.getHCatFieldSchema((FieldSchema)field);
        }
        catch (HCatException e) {
            throw new UnsupportedOperationException("Error while converting FieldSchema to HCatFieldSchema", e);
        }
        switch (hCatFieldSchema.getCategory()) {
            case PRIMITIVE: {
                if (!HCAT_TO_BEAM_TYPES_MAP.containsKey(hCatFieldSchema.getType())) {
                    throw new UnsupportedOperationException("The Primitive HCat type '" + field.getType() + "' of field '" + name + "' cannot be converted to Beam FieldType");
                }
                Schema.FieldType fieldType = HCAT_TO_BEAM_TYPES_MAP.get(hCatFieldSchema.getType());
                return Schema.Field.of((String)name, (Schema.FieldType)fieldType).withNullable(true);
            }
        }
        throw new UnsupportedOperationException("The category '" + hCatFieldSchema.getCategory() + "' is not supported.");
    }
}

