/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.reflection.probe.meta;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.pipeline.PipelineHopMeta;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.dummy.DummyMeta;
import org.apache.hop.reflection.probe.meta.DataProbeLocation;
import org.apache.hop.reflection.probe.meta.PipelineProbe;
import org.apache.hop.reflection.probe.transform.PipelineDataProbeMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.pipeline.HopPipelineFileType;
import org.apache.hop.ui.hopgui.perspective.dataorch.HopDataOrchestrationPerspective;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class PipelineProbeEditor
extends MetadataEditor<PipelineProbe> {
    private static final Class<?> PKG = PipelineProbeEditor.class;
    private Text wName;
    private Button wEnabled;
    private TextVar wFilename;
    private TableView wSources;

    public PipelineProbeEditor(HopGui hopGui, MetadataManager<PipelineProbe> manager, PipelineProbe metadata) {
        super(hopGui, manager, (IHopMetadata)metadata);
    }

    public void createControl(Composite parent) {
        PropsUi props = PropsUi.getInstance();
        int middle = props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Label wIcon = new Label(parent, 131072);
        wIcon.setImage(this.getImage());
        FormData fdlIcon = new FormData();
        fdlIcon.top = new FormAttachment(0, 0);
        fdlIcon.right = new FormAttachment(100, 0);
        wIcon.setLayoutData((Object)fdlIcon);
        PropsUi.setLook((Widget)wIcon);
        Label wlName = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlName);
        wlName.setText(BaseMessages.getString(PKG, (String)"PipelineProbeEditor.Name.Label", (String[])new String[0]));
        FormData fdlName = new FormData();
        fdlName.top = new FormAttachment((Control)wIcon, margin);
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, 0);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text(parent, 18436);
        PropsUi.setLook((Widget)this.wName);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment((Control)wlName, 0, 0x1000000);
        fdName.left = new FormAttachment(middle, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Label spacer = new Label(parent, 258);
        FormData fdSpacer = new FormData();
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.top = new FormAttachment((Control)this.wName, 15);
        fdSpacer.right = new FormAttachment(100, 0);
        spacer.setLayoutData((Object)fdSpacer);
        Label lastControl = spacer;
        Label wlEnabled = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlEnabled);
        wlEnabled.setText(BaseMessages.getString(PKG, (String)"PipelineProbeEditor.Enabled.Label", (String[])new String[0]));
        FormData fdlEnabled = new FormData();
        fdlEnabled.left = new FormAttachment(0, 0);
        fdlEnabled.right = new FormAttachment(middle, 0);
        fdlEnabled.top = new FormAttachment((Control)lastControl, margin);
        wlEnabled.setLayoutData((Object)fdlEnabled);
        this.wEnabled = new Button(parent, 16416);
        PropsUi.setLook((Widget)this.wEnabled);
        FormData fdEnabled = new FormData();
        fdEnabled.left = new FormAttachment(middle, margin);
        fdEnabled.right = new FormAttachment(100, 0);
        fdEnabled.top = new FormAttachment((Control)wlEnabled, 0, 0x1000000);
        this.wEnabled.setLayoutData((Object)fdEnabled);
        lastControl = wlEnabled;
        Label wlFilename = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlFilename);
        wlFilename.setText(BaseMessages.getString(PKG, (String)"PipelineProbeEditor.Filename.Label", (String[])new String[0]));
        FormData fdlFilename = new FormData();
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.right = new FormAttachment(middle, 0);
        fdlFilename.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlFilename.setLayoutData((Object)fdlFilename);
        Button wbbFilename = new Button(parent, 8);
        PropsUi.setLook((Widget)wbbFilename);
        wbbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbbFilename = new FormData();
        fdbbFilename.right = new FormAttachment(100, 0);
        fdbbFilename.top = new FormAttachment((Control)wlFilename, 0, 0x1000000);
        wbbFilename.setLayoutData((Object)fdbbFilename);
        wbbFilename.addListener(13, e -> this.selectPipelineFilename(parent));
        Button wbnFilename = new Button(parent, 8);
        PropsUi.setLook((Widget)wbnFilename);
        wbnFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.New", (String[])new String[0]));
        FormData fdbnFilename = new FormData();
        fdbnFilename.right = new FormAttachment((Control)wbbFilename, -margin);
        fdbnFilename.top = new FormAttachment((Control)wlFilename, 0, 0x1000000);
        wbnFilename.setLayoutData((Object)fdbnFilename);
        wbnFilename.addListener(13, e -> this.createPipelineFile(parent));
        Button wboFilename = new Button(parent, 8);
        PropsUi.setLook((Widget)wboFilename);
        wboFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Open", (String[])new String[0]));
        FormData fdboFilename = new FormData();
        fdboFilename.right = new FormAttachment((Control)wbnFilename, -margin);
        fdboFilename.top = new FormAttachment((Control)wlFilename, 0, 0x1000000);
        wboFilename.setLayoutData((Object)fdboFilename);
        wboFilename.addListener(13, e -> this.openPipelineFile(parent));
        this.wFilename = new TextVar(this.manager.getVariables(), parent, 18436);
        PropsUi.setLook((Widget)this.wFilename);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(middle, margin);
        fdFilename.right = new FormAttachment((Control)wboFilename, -margin);
        fdFilename.top = new FormAttachment((Control)wlFilename, 0, 0x1000000);
        this.wFilename.setLayoutData((Object)fdFilename);
        lastControl = wlFilename;
        Label wlSources = new Label(parent, 16384);
        PropsUi.setLook((Widget)wlSources);
        wlSources.setText(BaseMessages.getString(PKG, (String)"PipelineProbeEditor.Sources.Label", (String[])new String[0]));
        FormData fdlSources = new FormData();
        fdlSources.left = new FormAttachment(0, 0);
        fdlSources.right = new FormAttachment(100, 0);
        fdlSources.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlSources.setLayoutData((Object)fdlSources);
        lastControl = wlSources;
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineProbeEditor.SourcesTable.Column.Pipeline", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineProbeEditor.SourcesTable.Column.Transform", (String[])new String[0]), 1, false, false)};
        this.wSources = new TableView(this.manager.getVariables(), parent, 2048, columns, ((PipelineProbe)this.metadata).getDataProbeLocations().size(), e -> this.setChanged(), props);
        FormData fdSources = new FormData();
        fdSources.left = new FormAttachment(0, 0);
        fdSources.top = new FormAttachment((Control)lastControl, margin);
        fdSources.right = new FormAttachment(100, 0);
        fdSources.bottom = new FormAttachment(100, 0);
        this.wSources.setLayoutData((Object)fdSources);
        this.setWidgetsContent();
        Listener modifyListener = e -> this.setChanged();
        this.wName.addListener(24, modifyListener);
        this.wEnabled.addListener(13, modifyListener);
        this.wFilename.addListener(24, modifyListener);
        this.resetChanged();
    }

    private void createPipelineFile(Composite parent) {
        try {
            PipelineMeta pipelineMeta = new PipelineMeta();
            PipelineDataProbeMeta pipelineDataProbeMeta = new PipelineDataProbeMeta();
            pipelineDataProbeMeta.setLoggingTransforms(true);
            TransformMeta pipelineLogging = new TransformMeta("Pipeline Data Probe", (ITransformMeta)pipelineDataProbeMeta);
            pipelineLogging.setLocation(200, 150);
            pipelineMeta.addTransform(pipelineLogging);
            DummyMeta dummyMeta = new DummyMeta();
            TransformMeta dummy = new TransformMeta("Process values here", (ITransformMeta)dummyMeta);
            dummy.setLocation(500, 150);
            pipelineMeta.addTransform(dummy);
            pipelineMeta.addPipelineHop(new PipelineHopMeta(pipelineLogging, dummy));
            HopPipelineFileType type = new HopPipelineFileType();
            String filename = BaseDialog.presentFileDialog((boolean)true, (Shell)parent.getShell(), (TextVar)this.wFilename, (IVariables)this.manager.getVariables(), (String[])type.getFilterExtensions(), (String[])type.getFilterNames(), (boolean)true);
            if (filename != null) {
                String realFilename = this.manager.getVariables().resolve(filename);
                pipelineMeta.setFilename(realFilename);
                pipelineMeta.clearChanged();
                HopDataOrchestrationPerspective perspective = HopGui.getDataOrchestrationPerspective();
                perspective.activate();
                HopGui.getDataOrchestrationPerspective().addPipeline(this.hopGui, pipelineMeta, type);
                this.hopGui.fileDelegate.fileSave();
            }
        }
        catch (Exception e) {
            new ErrorDialog(parent.getShell(), "Error", "Error creating pipeline", e);
        }
    }

    private void openPipelineFile(Composite parent) {
        try {
            String filename = this.manager.getVariables().resolve(this.wFilename.getText());
            if (StringUtils.isNotEmpty((String)filename)) {
                this.hopGui.fileDelegate.fileOpen(filename);
            }
        }
        catch (Exception e) {
            new ErrorDialog(parent.getShell(), "Error", "Error creating pipeline", e);
        }
    }

    private void selectPipelineFilename(Composite parent) {
        HopPipelineFileType type = new HopPipelineFileType();
        BaseDialog.presentFileDialog((Shell)parent.getShell(), (TextVar)this.wFilename, (IVariables)this.manager.getVariables(), (String[])type.getFilterExtensions(), (String[])type.getFilterNames(), (boolean)true);
    }

    public void setWidgetsContent() {
        PipelineProbe pl = (PipelineProbe)this.getMetadata();
        this.wName.setText(Const.NVL((String)pl.getName(), (String)""));
        this.wEnabled.setSelection(pl.isEnabled());
        this.wFilename.setText(Const.NVL((String)pl.getPipelineFilename(), (String)""));
        this.wSources.removeAll();
        List<DataProbeLocation> locations = pl.getDataProbeLocations();
        for (DataProbeLocation location : locations) {
            TableItem item = new TableItem(this.wSources.table, 0);
            item.setText(1, Const.NVL((String)location.getSourcePipelineFilename(), (String)""));
            item.setText(2, Const.NVL((String)location.getSourceTransformName(), (String)""));
        }
        this.wSources.setRowNums();
        this.wSources.optimizeTableView();
    }

    public void getWidgetsContent(PipelineProbe pl) {
        pl.setName(this.wName.getText());
        pl.setEnabled(this.wEnabled.getSelection());
        pl.setPipelineFilename(this.wFilename.getText());
        ArrayList<DataProbeLocation> locations = new ArrayList<DataProbeLocation>();
        List items = this.wSources.getNonEmptyItems();
        for (TableItem item : items) {
            String filename = item.getText(1);
            String transformName = item.getText(2);
            locations.add(new DataProbeLocation(filename, transformName));
        }
        pl.setDataProbeLocations(locations);
    }

    public boolean setFocus() {
        if (this.wName == null || this.wName.isDisposed()) {
            return false;
        }
        return this.wName.setFocus();
    }
}

