/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.BasicTypeComparator;
import org.apache.flink.api.common.typeutils.base.NormalizedKeyUtil;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.MemorySegment;

@Internal
public final class ShortComparator
extends BasicTypeComparator<Short> {
    private static final long serialVersionUID = 1L;

    public ShortComparator(boolean ascending) {
        super(ascending);
    }

    @Override
    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        short s2;
        short s1 = firstSource.readShort();
        int comp = s1 < (s2 = secondSource.readShort()) ? -1 : (s1 == s2 ? 0 : 1);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public boolean supportsNormalizedKey() {
        return true;
    }

    @Override
    public int getNormalizeKeyLen() {
        return 2;
    }

    @Override
    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return keyBytes < 2;
    }

    @Override
    public void putNormalizedKey(Short value, MemorySegment target, int offset, int numBytes) {
        NormalizedKeyUtil.putShortNormalizedKey(value, target, offset, numBytes);
    }

    public ShortComparator duplicate() {
        return new ShortComparator(this.ascendingComparison);
    }
}

