/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IllegalPathNameException;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import com.ibm.as400.resource.ValueMap;
import java.io.Serializable;

class QualifiedValueMap
implements ValueMap,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    public static final int FORMAT_20 = 20;
    public static final int FORMAT_CL = 13;
    private int format_ = -1;
    private String type_ = null;

    public QualifiedValueMap(int format, String type) {
        if (format != 20 && format != 13) {
            throw new ExtendedIllegalArgumentException("format", 2);
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.format_ = format;
        this.type_ = type;
    }

    @Override
    public Object ltop(Object logicalValue, AS400 system) {
        if (logicalValue == null) {
            throw new NullPointerException("logicalValue");
        }
        if (!(logicalValue instanceof String)) {
            throw new ExtendedIllegalArgumentException("logicalValue", 2);
        }
        String asString = (String)logicalValue;
        if (asString.length() == 0) {
            throw new ExtendedIllegalArgumentException("logicalValue", 2);
        }
        StringBuffer buffer = new StringBuffer();
        switch (this.format_) {
            case 20: {
                if (asString.length() <= 10) {
                    buffer.append(QualifiedValueMap.normalize(asString, 20));
                    break;
                }
                try {
                    QSYSObjectPathName asPath = new QSYSObjectPathName(asString);
                    buffer.append(QualifiedValueMap.normalize(asPath.getObjectName(), 10));
                    buffer.append(QualifiedValueMap.normalize(asPath.getLibraryName(), 10));
                    break;
                }
                catch (IllegalPathNameException e) {
                    if (Trace.isTraceOn()) {
                        Trace.log(2, "Bad path name", (Throwable)e);
                    }
                    throw new ExtendedIllegalArgumentException("logicalValue", 2);
                }
            }
            case 13: {
                if (asString.length() <= 10) {
                    buffer.append(asString);
                    break;
                }
                try {
                    QSYSObjectPathName asPath = new QSYSObjectPathName(asString);
                    buffer.append(asPath.getLibraryName());
                    buffer.append('/');
                    buffer.append(asPath.getObjectName());
                    break;
                }
                catch (IllegalPathNameException e) {
                    if (Trace.isTraceOn()) {
                        Trace.log(2, "Bad path name", (Throwable)e);
                    }
                    throw new ExtendedIllegalArgumentException("logicalValue", 2);
                }
            }
            default: {
                throw new ExtendedIllegalStateException("format", 6);
            }
        }
        return buffer.toString();
    }

    @Override
    public Object ptol(Object physicalValue, AS400 system) {
        if (physicalValue == null) {
            throw new NullPointerException("physicalValue");
        }
        if (!(physicalValue instanceof String)) {
            throw new ExtendedIllegalArgumentException("physicalValue", 2);
        }
        String asString = (String)physicalValue;
        switch (this.format_) {
            case 20: {
                if (asString.length() <= 10) {
                    return asString;
                }
                return QSYSObjectPathName.toPath(asString.substring(10).trim(), asString.substring(0, 10).trim(), this.type_);
            }
            case 13: {
                return QSYSObjectPathName.toPath(asString.substring(11, 21).trim(), asString.substring(0, 10).trim(), this.type_);
            }
        }
        throw new ExtendedIllegalStateException("format", 6);
    }

    private static String normalize(String source, int length) {
        int sourceLength = source.length();
        if (sourceLength < length) {
            StringBuffer buffer = new StringBuffer(source);
            for (int i = sourceLength; i < length; ++i) {
                buffer.append(' ');
            }
            return buffer.toString();
        }
        if (sourceLength > length) {
            return source.substring(0, length);
        }
        return source;
    }
}

