/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.plugins;

import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;

public class HopURLClassLoader
extends URLClassLoader {
    private String name;

    public HopURLClassLoader(URL[] url, ClassLoader classLoader) {
        super(url, classLoader);
    }

    public HopURLClassLoader(URL[] url, ClassLoader classLoader, String name) {
        this(url, classLoader);
        this.name = name;
    }

    @Override
    protected void addURL(URL url) {
        super.addURL(url);
    }

    public String toString() {
        return super.toString() + " : " + this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected Class<?> loadClassFromThisLoader(String arg0, boolean arg1) throws ClassNotFoundException {
        Class<?> clz = this.findLoadedClass(arg0);
        if (clz != null) {
            if (arg1) {
                this.resolveClass(clz);
            }
            return clz;
        }
        clz = this.findClass(arg0);
        if (clz != null) {
            if (arg1) {
                this.resolveClass(clz);
            }
            return clz;
        }
        return clz;
    }

    protected Class<?> loadClassFromParent(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clz = this.getParent().loadClass(name);
        if (clz != null) {
            if (resolve) {
                this.resolveClass(clz);
            }
            return clz;
        }
        throw new ClassNotFoundException("Could not find :" + name);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return this.loadClassFromThisLoader(name, resolve);
        }
        catch (ClassNotFoundException | NoClassDefFoundError | SecurityException exception) {
            try {
                return this.loadClassFromParent(name, resolve);
            }
            catch (Exception parentException) {
                throw new ClassNotFoundException("Unable to load class '" + name + "' in this classloader or in the parent", exception);
            }
        }
    }

    public Class<?> loadClass(String name, ProtectionDomain protectionDomain) {
        Class<?> loaded = this.findLoadedClass(name);
        if (loaded == null) {
            String newName = name.replace('.', '/');
            InputStream is = this.getResourceAsStream(newName);
            byte[] driverBytes = this.toBytes(is);
            loaded = super.defineClass(name, driverBytes, 0, driverBytes.length, protectionDomain);
        }
        return loaded;
    }

    private byte[] toBytes(InputStream is) {
        byte[] retval = new byte[]{};
        try {
            int a = is.available();
            while (a > 0) {
                int i;
                byte[] buffer = new byte[a];
                is.read(buffer);
                byte[] newretval = new byte[retval.length + a];
                for (i = 0; i < retval.length; ++i) {
                    newretval[i] = retval[i];
                }
                for (i = 0; i < a; ++i) {
                    newretval[retval.length + i] = buffer[i];
                }
                retval = newretval;
                a = is.available();
            }
            return retval;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url == null && this.getParent() != null) {
            url = this.getParent().getResource(name);
        }
        return url;
    }
}

