/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.aws.sns;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.sns.AmazonSNSClient;
import com.amazonaws.services.sns.AmazonSNSClientBuilder;
import com.amazonaws.services.sns.model.AmazonSNSException;
import com.amazonaws.services.sns.model.PublishRequest;
import com.amazonaws.services.sns.model.PublishResult;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transforms.aws.sns.SnsNotifyMeta;

public class AwsSns {
    private AmazonSNSClient snsClient;
    private SnsNotifyMeta meta;
    private String awsKey;
    private String awsRegion;
    private String awsKeySecret;
    private BaseTransform baseTransform;
    private PipelineMeta pipelineMeta;
    private String awsCredChain;

    public AwsSns(SnsNotifyMeta transformMeta, PipelineMeta pipelineMeta, BaseTransform baseTransform) {
        this.meta = transformMeta;
        this.baseTransform = baseTransform;
        this.pipelineMeta = pipelineMeta;
        this.awsCredChain = this.baseTransform.resolve(this.meta.getAwsCredChain());
        this.awsKey = this.baseTransform.resolve(this.meta.getAwsKey());
        this.awsKeySecret = this.baseTransform.resolve(this.meta.getAwsKeySecret());
        this.awsRegion = this.baseTransform.resolve(this.meta.getAwsRegion());
    }

    public boolean getAWSConnection() {
        try {
            this.baseTransform.logBasic("Starting connection to AWS SNS");
            if (this.awsCredChain.equalsIgnoreCase("N")) {
                BasicAWSCredentials awsCreds = new BasicAWSCredentials(this.awsKey, this.awsKeySecret);
                this.snsClient = (AmazonSNSClient)((AmazonSNSClientBuilder)((AmazonSNSClientBuilder)AmazonSNSClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCreds))).withRegion(this.awsRegion)).build();
                this.baseTransform.logBasic("Connected to SNS in Region " + this.awsRegion + " with API-Key >>" + this.awsKey + "<<");
            } else {
                DefaultAWSCredentialsProviderChain provider = new DefaultAWSCredentialsProviderChain();
                this.snsClient = (AmazonSNSClient)((AmazonSNSClientBuilder)AmazonSNSClientBuilder.standard().withCredentials((AWSCredentialsProvider)provider)).build();
                this.baseTransform.logBasic("Connected to SNS with provided Credentials Chain");
            }
            return true;
        }
        catch (Exception e) {
            this.baseTransform.logError(e.getMessage());
            return false;
        }
    }

    public void disconnectAWSConnection() {
        try {
            this.snsClient.shutdown();
            this.baseTransform.logBasic("Disconnected from SNS in Region " + this.awsRegion);
        }
        catch (AmazonClientException e) {
            this.baseTransform.logError(e.getMessage());
            this.baseTransform.setErrors(1L);
        }
    }

    public String publishToSNS(String tARN, String subj, String msg) throws AmazonSNSException {
        String topicARN = this.baseTransform.resolve(tARN);
        String subject = this.baseTransform.resolve(subj);
        String message = this.baseTransform.resolve(msg);
        PublishRequest publishRequest = new PublishRequest(topicARN, message, subject);
        PublishResult publishResult = this.snsClient.publish(publishRequest);
        String messageId = publishResult.getMessageId();
        this.baseTransform.logBasic(messageId);
        return messageId;
    }
}

