/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.cypher;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataPropertyType;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.neo4j.core.value.ValueMetaGraph;
import org.apache.hop.neo4j.transforms.cypher.Cypher;
import org.apache.hop.neo4j.transforms.cypher.CypherData;
import org.apache.hop.neo4j.transforms.cypher.CypherDialog;
import org.apache.hop.neo4j.transforms.cypher.ParameterMapping;
import org.apache.hop.neo4j.transforms.cypher.ReturnValue;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

@Transform(id="Neo4jCypherOutput", name="i18n::Cypher.Transform.Name", description="i18n::Cypher.Transform.Description", image="neo4j_cypher.svg", categoryDescription="Neo4j", keywords={"i18n::CypherMeta.keyword"}, documentationUrl="/pipeline/transforms/neo4j-cypher.html")
public class CypherMeta
extends BaseTransformMeta<Cypher, CypherData> {
    @HopMetadataProperty(key="connection", injectionKey="connection", injectionKeyDescription="Cypher.Injection.connection", hopMetadataPropertyType=HopMetadataPropertyType.GRAPH_CONNECTION)
    private String connectionName;
    @HopMetadataProperty(key="cypher", injectionKey="cypher", injectionKeyDescription="Cypher.Injection.cypher")
    private String cypher;
    @HopMetadataProperty(key="batch_size", injectionKey="batch_size", injectionKeyDescription="Cypher.Injection.batch_size")
    private String batchSize;
    @HopMetadataProperty(key="read_only", injectionKey="read_only", injectionKeyDescription="Cypher.Injection.read_only")
    private boolean readOnly;
    @HopMetadataProperty(key="retry", injectionKey="retry", injectionKeyDescription="Cypher.Injection.retry")
    private boolean retryingOnDisconnect;
    @HopMetadataProperty(key="nr_retries_on_error", injectionKey="nr_retries_on_error", injectionKeyDescription="Cypher.Injection.nr_retries_on_error")
    private String nrRetriesOnError;
    @HopMetadataProperty(key="cypher_from_field", injectionKey="cypher_from_field", injectionKeyDescription="Cypher.Injection.cypher_from_field")
    private boolean cypherFromField;
    @HopMetadataProperty(key="cypher_field", injectionKey="cypher_field", injectionKeyDescription="Cypher.Injection.cypher_field")
    private String cypherField;
    @HopMetadataProperty(key="unwind", injectionKey="unwind", injectionKeyDescription="Cypher.Injection.unwind")
    private boolean usingUnwind;
    @HopMetadataProperty(key="unwind_map", injectionKey="unwind_map", injectionKeyDescription="Cypher.Injection.unwind_map")
    private String unwindMapName;
    @HopMetadataProperty(key="returning_graph", injectionKey="returning_graph", injectionKeyDescription="Cypher.Injection.returning_graph")
    private boolean returningGraph;
    @HopMetadataProperty(key="return_graph_field", injectionKey="return_graph_field", injectionKeyDescription="Cypher.Injection.return_graph_field")
    private String returnGraphField;
    @HopMetadataProperty(groupKey="mappings", key="mapping", injectionGroupKey="PARAMETERS", injectionGroupDescription="Cypher.Injection.PARAMETERS")
    private List<ParameterMapping> parameterMappings = new ArrayList<ParameterMapping>();
    @HopMetadataProperty(groupKey="returns", key="return", injectionGroupKey="RETURNS", injectionKeyDescription="Cypher.Injection.RETURNS")
    private List<ReturnValue> returnValues = new ArrayList<ReturnValue>();

    public CypherMeta() {
    }

    public CypherMeta(CypherMeta m) {
        this();
        this.connectionName = m.connectionName;
        this.cypher = m.cypher;
        this.batchSize = m.batchSize;
        this.readOnly = m.readOnly;
        this.retryingOnDisconnect = m.retryingOnDisconnect;
        this.nrRetriesOnError = m.nrRetriesOnError;
        this.cypherFromField = m.cypherFromField;
        this.cypherField = m.cypherField;
        this.usingUnwind = m.usingUnwind;
        this.unwindMapName = m.unwindMapName;
        this.returningGraph = m.returningGraph;
        this.returnGraphField = m.returnGraphField;
        m.parameterMappings.forEach(p -> this.parameterMappings.add(new ParameterMapping((ParameterMapping)p)));
        m.returnValues.forEach(v -> this.returnValues.add(new ReturnValue((ReturnValue)v)));
    }

    public CypherMeta clone() {
        return new CypherMeta(this);
    }

    public void setDefault() {
        this.retryingOnDisconnect = true;
    }

    public String getDialogClassName() {
        return CypherDialog.class.getName();
    }

    public void getFields(IRowMeta rowMeta, String name, IRowMeta[] info, TransformMeta nextStep, IVariables space, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (this.usingUnwind) {
            rowMeta.clear();
        }
        if (this.returningGraph) {
            ValueMetaGraph valueMetaGraph = new ValueMetaGraph(Const.NVL((String)this.returnGraphField, (String)"graph"));
            valueMetaGraph.setOrigin(name);
            rowMeta.addValueMeta((IValueMeta)valueMetaGraph);
        } else {
            for (ReturnValue returnValue : this.returnValues) {
                try {
                    int type = ValueMetaFactory.getIdForValueMeta((String)returnValue.getType());
                    IValueMeta valueMeta = ValueMetaFactory.createValueMeta((String)returnValue.getName(), (int)type);
                    valueMeta.setOrigin(name);
                    rowMeta.addValueMeta(valueMeta);
                }
                catch (HopPluginException e) {
                    throw new HopTransformException("Unknown data type '" + returnValue.getType() + "' for value named '" + returnValue.getName() + "'");
                }
            }
        }
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public String getCypher() {
        return this.cypher;
    }

    public void setCypher(String cypher) {
        this.cypher = cypher;
    }

    public String getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(String batchSize) {
        this.batchSize = batchSize;
    }

    public boolean isCypherFromField() {
        return this.cypherFromField;
    }

    public void setCypherFromField(boolean cypherFromField) {
        this.cypherFromField = cypherFromField;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isRetryingOnDisconnect() {
        return this.retryingOnDisconnect;
    }

    public void setRetryingOnDisconnect(boolean retryingOnDisconnect) {
        this.retryingOnDisconnect = retryingOnDisconnect;
    }

    public String getCypherField() {
        return this.cypherField;
    }

    public void setCypherField(String cypherField) {
        this.cypherField = cypherField;
    }

    public boolean isUsingUnwind() {
        return this.usingUnwind;
    }

    public void setUsingUnwind(boolean usingUnwind) {
        this.usingUnwind = usingUnwind;
    }

    public String getUnwindMapName() {
        return this.unwindMapName;
    }

    public boolean isReturningGraph() {
        return this.returningGraph;
    }

    public void setReturningGraph(boolean returningGraph) {
        this.returningGraph = returningGraph;
    }

    public void setUnwindMapName(String unwindMapName) {
        this.unwindMapName = unwindMapName;
    }

    public List<ParameterMapping> getParameterMappings() {
        return this.parameterMappings;
    }

    public void setParameterMappings(List<ParameterMapping> parameterMappings) {
        this.parameterMappings = parameterMappings;
    }

    public List<ReturnValue> getReturnValues() {
        return this.returnValues;
    }

    public void setReturnValues(List<ReturnValue> returnValues) {
        this.returnValues = returnValues;
    }

    public String getReturnGraphField() {
        return this.returnGraphField;
    }

    public void setReturnGraphField(String returnGraphField) {
        this.returnGraphField = returnGraphField;
    }

    public String getNrRetriesOnError() {
        return this.nrRetriesOnError;
    }

    public void setNrRetriesOnError(String nrRetriesOnError) {
        this.nrRetriesOnError = nrRetriesOnError;
    }
}

