/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum DesktopPlatform {
    WINDOWS,
    MAC,
    LINUX,
    OTHER;


    public static class Serializer
    extends UnionSerializer<DesktopPlatform> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(DesktopPlatform value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value) {
                case WINDOWS: {
                    g.writeString("windows");
                    break;
                }
                case MAC: {
                    g.writeString("mac");
                    break;
                }
                case LINUX: {
                    g.writeString("linux");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public DesktopPlatform deserialize(JsonParser p) throws IOException, JsonParseException {
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            DesktopPlatform value = "windows".equals(tag) ? WINDOWS : ("mac".equals(tag) ? MAC : ("linux".equals(tag) ? LINUX : OTHER));
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

