/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.util;

import java.math.BigDecimal;
import java.util.Date;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.xml.XmlHandler;
import org.mozilla.javascript.Context;

public class JavaScriptUtils {
    private static final String CONST_UNDEFINED = "org.mozilla.javascript.Undefined";
    private static final String CONST_NATIVE_JAVA_OBJECT = "org.mozilla.javascript.NativeJavaObject";
    private static final String CONST_NATIVE_NUMBER = "org.mozilla.javascript.NativeNumber";

    public static Object convertFromJs(Object value, int type, String fieldName) throws HopValueException {
        String classType = value.getClass().getName();
        switch (type) {
            case 1: {
                return JavaScriptUtils.jsToNumber(value, classType);
            }
            case 5: {
                return JavaScriptUtils.jsToInteger(value, value.getClass());
            }
            case 2: {
                return JavaScriptUtils.jsToString(value, classType);
            }
            case 3: {
                return JavaScriptUtils.jsToDate(value, classType);
            }
            case 4: {
                return value;
            }
            case 6: {
                return JavaScriptUtils.jsToBigNumber(value, classType);
            }
            case 8: {
                return Context.jsToJava((Object)value, byte[].class);
            }
            case 0: {
                throw new RuntimeException("No data output data type was specified for new field [" + fieldName + "]");
            }
        }
        return Context.jsToJava((Object)value, Object.class);
    }

    public static Number jsToNumber(Object value, String classType) {
        if (classType.equalsIgnoreCase(CONST_UNDEFINED)) {
            return null;
        }
        if (classType.equalsIgnoreCase(CONST_NATIVE_JAVA_OBJECT)) {
            try {
                return (Double)Context.jsToJava((Object)value, Double.class);
            }
            catch (Exception e) {
                String string = Context.toString((Object)value);
                return Double.parseDouble(Const.trim((String)string));
            }
        }
        if (classType.equalsIgnoreCase(CONST_NATIVE_NUMBER)) {
            Double nb = Context.toNumber((Object)value);
            return (double)nb;
        }
        Number nb = (Number)value;
        return nb.doubleValue();
    }

    public static Long jsToInteger(Object value, Class<?> clazz) {
        if (Number.class.isAssignableFrom(clazz)) {
            return ((Number)value).longValue();
        }
        String classType = clazz.getName();
        if (classType.equalsIgnoreCase("java.lang.String")) {
            return Long.valueOf((String)value);
        }
        if (classType.equalsIgnoreCase(CONST_UNDEFINED)) {
            return null;
        }
        if (classType.equalsIgnoreCase(CONST_NATIVE_NUMBER)) {
            Double nb = Context.toNumber((Object)value);
            return ((Number)nb).longValue();
        }
        if (classType.equalsIgnoreCase(CONST_NATIVE_JAVA_OBJECT)) {
            try {
                return (Long)Context.jsToJava((Object)value, Long.class);
            }
            catch (Exception e2) {
                String string = Context.toString((Object)value);
                return Long.parseLong(Const.trim((String)string));
            }
        }
        return Long.parseLong(value.toString());
    }

    public static String jsToString(Object value, String classType) {
        return Context.toString((Object)value);
    }

    public static Date jsToDate(Object value, String classType) throws HopValueException {
        double dbl;
        if (classType.equalsIgnoreCase(CONST_UNDEFINED)) {
            return null;
        }
        if (classType.equalsIgnoreCase("org.mozilla.javascript.NativeDate")) {
            dbl = Context.toNumber((Object)value);
        } else if (classType.equalsIgnoreCase(CONST_NATIVE_JAVA_OBJECT) || classType.equalsIgnoreCase("java.util.Date")) {
            try {
                Date dat = (Date)Context.jsToJava((Object)value, Date.class);
                dbl = dat.getTime();
            }
            catch (Exception e) {
                try {
                    String string = Context.toString((Object)value);
                    return XmlHandler.stringToDate((String)string);
                }
                catch (Exception e3) {
                    throw new HopValueException("Can't convert a string to a date");
                }
            }
        } else if (classType.equalsIgnoreCase("java.lang.Double")) {
            dbl = (Double)value;
        } else {
            String string = (String)Context.jsToJava((Object)value, String.class);
            dbl = Double.parseDouble(string);
        }
        long lng = Math.round(dbl);
        return new Date(lng);
    }

    public static BigDecimal jsToBigNumber(Object value, String classType) {
        if (classType.equalsIgnoreCase(CONST_UNDEFINED)) {
            return null;
        }
        if (classType.equalsIgnoreCase(CONST_NATIVE_NUMBER)) {
            Double nb = Context.toNumber((Object)value);
            return BigDecimal.valueOf(nb);
        }
        if (classType.equalsIgnoreCase(CONST_NATIVE_JAVA_OBJECT)) {
            try {
                return (BigDecimal)Context.jsToJava((Object)value, BigDecimal.class);
            }
            catch (Exception e) {
                String string = (String)Context.jsToJava((Object)value, String.class);
                return new BigDecimal(string);
            }
        }
        if (classType.equalsIgnoreCase("java.lang.Byte")) {
            return BigDecimal.valueOf(((Byte)value).longValue());
        }
        if (classType.equalsIgnoreCase("java.lang.Short")) {
            return BigDecimal.valueOf(((Short)value).longValue());
        }
        if (classType.equalsIgnoreCase("java.lang.Integer")) {
            return BigDecimal.valueOf(((Integer)value).longValue());
        }
        if (classType.equalsIgnoreCase("java.lang.Long")) {
            return BigDecimal.valueOf((Long)value);
        }
        if (classType.equalsIgnoreCase("java.lang.Double")) {
            return BigDecimal.valueOf((Double)value);
        }
        if (classType.equalsIgnoreCase("java.lang.String")) {
            return BigDecimal.valueOf(Long.valueOf((String)value));
        }
        throw new RuntimeException("JavaScript conversion to BigNumber not implemented for " + classType);
    }
}

