/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen.asm.sc;

import groovyjarjarasm.asm.Label;
import groovyjarjarasm.asm.MethodVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.groovy.ast.tools.ClassNodeUtils;
import org.apache.groovy.ast.tools.ExpressionUtils;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.EnumConstantClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.decompiled.DecompiledClassNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.classgen.AsmClassGenerator;
import org.codehaus.groovy.classgen.asm.BytecodeHelper;
import org.codehaus.groovy.classgen.asm.CallSiteWriter;
import org.codehaus.groovy.classgen.asm.CompileStack;
import org.codehaus.groovy.classgen.asm.ExpressionAsVariableSlot;
import org.codehaus.groovy.classgen.asm.InvocationWriter;
import org.codehaus.groovy.classgen.asm.MethodCallerMultiAdapter;
import org.codehaus.groovy.classgen.asm.OperandStack;
import org.codehaus.groovy.classgen.asm.TypeChooser;
import org.codehaus.groovy.classgen.asm.VariableSlotLoader;
import org.codehaus.groovy.classgen.asm.WriterController;
import org.codehaus.groovy.classgen.asm.sc.StaticTypesCallSiteWriter;
import org.codehaus.groovy.classgen.asm.sc.StaticTypesWriterController;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.transform.sc.StaticCompilationMetadataKeys;
import org.codehaus.groovy.transform.sc.StaticCompilationVisitor;
import org.codehaus.groovy.transform.sc.TemporaryVariableExpression;
import org.codehaus.groovy.transform.stc.ExtensionMethodNode;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingVisitor;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;
import org.codehaus.groovy.transform.trait.Traits;

public class StaticInvocationWriter
extends InvocationWriter {
    private final AtomicInteger labelCounter = new AtomicInteger();

    public StaticInvocationWriter(WriterController wc) {
        super(wc);
    }

    Expression getCurrentCall() {
        return this.currentCall;
    }

    @Override
    public void writeInvokeConstructor(ConstructorCallExpression call) {
        List<Expression> argList;
        ConstructorNode cn;
        MethodNode mn = (MethodNode)call.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
        if (mn == null) {
            super.writeInvokeConstructor(call);
            return;
        }
        if (this.writeAICCall(call)) {
            return;
        }
        if (mn instanceof ConstructorNode) {
            cn = (ConstructorNode)mn;
        } else {
            cn = new ConstructorNode(mn.getModifiers(), mn.getParameters(), mn.getExceptions(), mn.getCode());
            cn.setDeclaringClass(mn.getDeclaringClass());
        }
        ClassNode declaringClass = cn.getDeclaringClass();
        ClassNode enclosingClass = this.controller.getClassNode();
        List<Expression> list = argList = call.getArguments() instanceof TupleExpression ? ((TupleExpression)call.getArguments()).getExpressions() : List.of(call.getArguments());
        if (!AsmClassGenerator.isMemberDirectlyAccessible(cn.getModifiers(), declaringClass, enclosingClass)) {
            Map bridgeMethods;
            MethodNode bridge = null;
            if (call.getNodeMetaData((Object)StaticTypesMarker.PV_METHODS_ACCESS) != null && (bridgeMethods = (Map)declaringClass.getNodeMetaData((Object)StaticCompilationMetadataKeys.PRIVATE_BRIDGE_METHODS)) != null) {
                bridge = (MethodNode)bridgeMethods.get(cn);
            }
            if (bridge instanceof ConstructorNode) {
                cn = (ConstructorNode)bridge;
                argList = new ArrayList<Expression>(argList);
                argList.add(0, GeneralUtils.nullX());
            } else {
                this.controller.getSourceUnit().addError(new SyntaxException("Cannot call private constructor for " + declaringClass.toString(false) + " from class " + enclosingClass.toString(false), call));
            }
        }
        String ownerDescriptor = this.prepareConstructorCall(cn);
        int before = this.controller.getOperandStack().getStackLength();
        this.loadArguments(argList, cn.getParameters());
        this.finnishConstructorCall(cn, ownerDescriptor, this.controller.getOperandStack().getStackLength() - before);
    }

    @Override
    public void writeSpecialConstructorCall(ConstructorCallExpression call) {
        ConstructorNode cn;
        MethodNode mn = (MethodNode)call.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
        if (mn == null) {
            super.writeSpecialConstructorCall(call);
            return;
        }
        this.controller.getCompileStack().pushInSpecialConstructorCall();
        if (mn instanceof ConstructorNode) {
            cn = (ConstructorNode)mn;
        } else {
            cn = new ConstructorNode(mn.getModifiers(), mn.getParameters(), mn.getExceptions(), mn.getCode());
            cn.setDeclaringClass(mn.getDeclaringClass());
        }
        this.controller.getMethodVisitor().visitVarInsn(25, 0);
        String ownerDescriptor = BytecodeHelper.getClassInternalName(cn.getDeclaringClass());
        ArgumentListExpression args = StaticInvocationWriter.makeArgumentList(call.getArguments());
        int before = this.controller.getOperandStack().getStackLength();
        this.loadArguments(args.getExpressions(), cn.getParameters());
        this.finnishConstructorCall(cn, ownerDescriptor, this.controller.getOperandStack().getStackLength() - before);
        this.controller.getOperandStack().remove(1);
        this.controller.getCompileStack().pop();
    }

    private Expression thisObjectExpression(ClassNode source, ClassNode target) {
        Expression thisExpr;
        ClassNode thisType = source;
        while (ClassHelper.isGeneratedFunction(thisType)) {
            thisType = thisType.getOuterClass();
        }
        if (Traits.isTrait(thisType.getOuterClass())) {
            thisExpr = GeneralUtils.varX("thisObject");
        } else if (this.controller.isStaticContext()) {
            thisExpr = GeneralUtils.varX("thisObject", GenericsUtils.makeClassSafe0(ClassHelper.CLASS_Type, thisType.asGenericsType()));
        } else {
            FieldNode thisZero;
            thisExpr = GeneralUtils.varX("thisObject", thisType);
            while (!ClassNodeUtils.isSubtype(target, thisType) && (thisZero = thisType.getDeclaredField("this$0")) != null) {
                thisExpr = GeneralUtils.attrX(thisExpr, "this$0");
                thisExpr.setType(thisZero.getType());
                thisType = thisType.getOuterClass();
                if (thisType != null) continue;
            }
        }
        return thisExpr;
    }

    @Deprecated
    protected boolean tryBridgeMethod(MethodNode target, Expression receiver, boolean implicitThis, TupleExpression args) {
        return this.tryBridgeMethod(target, receiver, implicitThis, args, null);
    }

    protected boolean tryBridgeMethod(MethodNode target, Expression receiver, boolean implicitThis, TupleExpression args, ClassNode thisClass) {
        Map bridges;
        MethodNode bridge;
        ClassNode lookupClassNode;
        if (target.isProtected()) {
            for (lookupClassNode = this.controller.getClassNode(); lookupClassNode != null && !ClassNodeUtils.isSubtype(target.getDeclaringClass(), lookupClassNode); lookupClassNode = lookupClassNode.getOuterClass()) {
            }
            if (lookupClassNode == null) {
                return false;
            }
        } else {
            lookupClassNode = target.getDeclaringClass().redirect();
        }
        MethodNode methodNode = bridge = (bridges = (Map)lookupClassNode.getNodeMetaData((Object)StaticCompilationMetadataKeys.PRIVATE_BRIDGE_METHODS)) == null ? null : (MethodNode)bridges.get(target);
        if (bridge != null) {
            Expression newReceiver = receiver;
            if (implicitThis) {
                if (!this.controller.isInGeneratedFunction()) {
                    if (!ClassNodeUtils.isSubtype(lookupClassNode, thisClass)) {
                        newReceiver = GeneralUtils.propX((Expression)GeneralUtils.classX(lookupClassNode), "this");
                    }
                } else if (thisClass != null) {
                    newReceiver = this.thisObjectExpression(thisClass, lookupClassNode);
                }
            }
            ArgumentListExpression newArguments = GeneralUtils.args(target.isStatic() ? GeneralUtils.nullX() : newReceiver);
            for (Expression expression : args.getExpressions()) {
                newArguments.addExpression(expression);
            }
            return this.writeDirectMethodCall(bridge, implicitThis, newReceiver, newArguments);
        }
        return false;
    }

    @Override
    protected boolean writeDirectMethodCall(MethodNode target, boolean implicitThis, Expression receiver, TupleExpression args) {
        ClassNode receiverType;
        if (target == null) {
            return false;
        }
        ClassNode enclosingClass = this.controller.getClassNode();
        ClassNode declaringClass = target.getDeclaringClass();
        if (target instanceof ExtensionMethodNode) {
            ExtensionMethodNode emn = (ExtensionMethodNode)target;
            MethodVisitor mv = this.controller.getMethodVisitor();
            MethodNode mn = emn.getExtensionMethodNode();
            Parameter[] parameters = mn.getParameters();
            ClassNode returnType = mn.getReturnType();
            ArrayList<Expression> argumentList = new ArrayList<Expression>();
            if (emn.isStaticExtension()) {
                argumentList.add(GeneralUtils.nullX());
            } else if (!ExpressionUtils.isThisOrSuper(receiver) || !this.controller.isInGeneratedFunction()) {
                argumentList.add(receiver);
            } else {
                argumentList.add(this.thisObjectExpression(enclosingClass, declaringClass));
            }
            argumentList.addAll(args.getExpressions());
            this.loadArguments(argumentList, parameters);
            String owner = BytecodeHelper.getClassInternalName(mn.getDeclaringClass());
            String desc = BytecodeHelper.getMethodDescriptor(returnType, parameters);
            mv.visitMethodInsn(184, owner, target.getName(), desc, false);
            this.controller.getOperandStack().remove(argumentList.size());
            if (ClassHelper.isPrimitiveVoid(returnType)) {
                if (this.currentCall != null && this.currentCall.getNodeMetaData("_EXPR_VALUE_UNUSED") != null) {
                    return true;
                }
                returnType = ClassHelper.OBJECT_TYPE;
                mv.visitInsn(1);
            }
            this.controller.getOperandStack().push(returnType);
            return true;
        }
        if (target == StaticTypeCheckingVisitor.CLOSURE_CALL_VARGS) {
            ArrayExpression array = new ArrayExpression(ClassHelper.OBJECT_TYPE, args.getExpressions());
            return super.writeDirectMethodCall(target, implicitThis, receiver, GeneralUtils.args(array));
        }
        ClassNode classNode = receiverType = receiver == null ? ClassHelper.OBJECT_TYPE : this.controller.getTypeChooser().resolveType(receiver, this.controller.getThisType());
        if (AsmClassGenerator.isMemberDirectlyAccessible(target.getModifiers(), declaringClass, enclosingClass) && (!target.isProtected() || GeneralUtils.inSamePackage(declaringClass, enclosingClass) || ClassNodeUtils.isSubtype(receiverType, enclosingClass))) {
            boolean isThisImplicit = implicitThis;
            Expression theReceiver = receiver;
            if (implicitThis && ExpressionUtils.isThisExpression(receiver) && !ClassNodeUtils.isSubtype(declaringClass, enclosingClass)) {
                theReceiver = target.isStatic() ? GeneralUtils.classX(declaringClass) : (!this.controller.isInGeneratedFunction() ? GeneralUtils.propX((Expression)GeneralUtils.classX(declaringClass), "this") : this.thisObjectExpression(enclosingClass, declaringClass));
                if (!(theReceiver instanceof VariableExpression)) {
                    isThisImplicit = false;
                }
                theReceiver.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, declaringClass);
            }
            if (theReceiver != null && !ExpressionUtils.isSuperExpression(receiver) && !this.isClassWithSuper(receiver) && this.currentCall.getNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER) == null) {
                theReceiver = new CheckcastReceiverExpression(theReceiver, target);
            }
            return super.writeDirectMethodCall(target, isThisImplicit, theReceiver, args);
        }
        if (this.tryBridgeMethod(target, receiver, implicitThis, args, enclosingClass)) {
            return true;
        }
        this.writeMethodAccessError(target, receiver != null ? receiver : args);
        return false;
    }

    private void writeMethodAccessError(MethodNode target, Expression origin) {
        StringJoiner descriptor = new StringJoiner(", ", target.getName() + "(", ")");
        for (Parameter parameter : target.getParameters()) {
            descriptor.add(ClassNodeUtils.formatTypeName(parameter.getOriginType()));
        }
        String message = "Cannot access method: " + descriptor + " of class: " + ClassNodeUtils.formatTypeName(target.getDeclaringClass());
        this.controller.getSourceUnit().addError(new SyntaxException(message, origin));
    }

    private boolean isClassWithSuper(Expression receiver) {
        if (receiver instanceof PropertyExpression) {
            PropertyExpression pexp = (PropertyExpression)receiver;
            return pexp.getObjectExpression() instanceof ClassExpression && "super".equals(pexp.getPropertyAsString());
        }
        return false;
    }

    protected static boolean isPrivateBridgeMethodsCallAllowed(ClassNode receiver, ClassNode caller) {
        if (receiver == null) {
            return false;
        }
        if (receiver.redirect() == caller) {
            return true;
        }
        if (StaticInvocationWriter.isPrivateBridgeMethodsCallAllowed(receiver.getOuterClass(), caller)) {
            return true;
        }
        return caller.getOuterClass() != null && StaticInvocationWriter.isPrivateBridgeMethodsCallAllowed(receiver, caller.getOuterClass());
    }

    @Override
    protected void loadArguments(List<Expression> argumentList, Parameter[] parameters) {
        int nArgs = argumentList.size();
        int nPrms = parameters.length;
        if (nPrms == 0) {
            return;
        }
        ClassNode classNode = this.controller.getClassNode();
        TypeChooser typeChooser = this.controller.getTypeChooser();
        ClassNode lastArgType = nArgs == 0 ? null : typeChooser.resolveType(argumentList.get(nArgs - 1), classNode);
        ClassNode lastPrmType = parameters[nPrms - 1].getType();
        if (lastPrmType.isArray() && (nArgs > nPrms || nArgs == nPrms - 1 || nArgs == nPrms && !lastArgType.isArray() && (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(lastArgType, lastPrmType.getComponentType()) || ClassHelper.isGStringType(lastArgType) && ClassHelper.isStringType(lastPrmType.getComponentType())))) {
            OperandStack operandStack = this.controller.getOperandStack();
            for (int i = 0; i < nPrms - 1; ++i) {
                this.visitArgument(argumentList.get(i), parameters[i].getType());
            }
            boolean spread = false;
            ArrayList<Expression> lastArgs = new ArrayList<Expression>();
            for (int i = nPrms - 1; i < nArgs; ++i) {
                Expression arg2 = argumentList.get(i);
                lastArgs.add(arg2);
                spread = spread || arg2 instanceof SpreadExpression;
            }
            if (spread) {
                this.controller.getAcg().despreadList(lastArgs, true);
                operandStack.push(ClassHelper.OBJECT_TYPE.makeArray());
                this.controller.getInvocationWriter().coerce(operandStack.getTopOperand(), lastPrmType);
            } else {
                this.controller.getAcg().visitArrayExpression(new ArrayExpression(lastPrmType.getComponentType(), lastArgs));
            }
            if (nArgs == nPrms - 1) {
                operandStack.remove(1);
            } else {
                for (int n = lastArgs.size(); n > 1; --n) {
                    operandStack.push(ClassHelper.OBJECT_TYPE);
                }
            }
        } else if (nArgs == nPrms) {
            for (int i = 0; i < nArgs; ++i) {
                this.visitArgument(argumentList.get(i), parameters[i].getType());
            }
        } else {
            int i;
            Expression[] arguments = new Expression[nPrms];
            int j = 0;
            for (i = 0; i < nPrms; ++i) {
                Parameter p = parameters[i];
                ClassNode pType = p.getType();
                Expression a = j < nArgs ? argumentList.get(j) : null;
                ClassNode aType = a == null ? null : typeChooser.resolveType(a, classNode);
                Expression expression = StaticInvocationWriter.getInitialExpression(p);
                if (expression != null && !StaticInvocationWriter.isCompatibleArgumentType(aType, pType)) {
                    arguments[i] = expression;
                    continue;
                }
                if (a != null) {
                    arguments[i] = a;
                    ++j;
                    continue;
                }
                String errorMessage = "Binding failed for arguments [" + argumentList.stream().map(arg -> typeChooser.resolveType((Expression)arg, classNode).toString(false)).collect(Collectors.joining(", ")) + "] and parameters [" + Arrays.stream(parameters).map(prm -> prm.getType().toString(false)).collect(Collectors.joining(", ")) + "]";
                this.controller.getSourceUnit().addFatalError(errorMessage, this.currentCall);
            }
            for (i = 0; i < nArgs; ++i) {
                this.visitArgument(arguments[i], parameters[i].getType());
            }
        }
    }

    private static Expression getInitialExpression(Parameter parameter) {
        Expression initialExpression = (Expression)parameter.getNodeMetaData((Object)StaticTypesMarker.INITIAL_EXPRESSION);
        if (initialExpression == null && parameter.hasInitialExpression()) {
            initialExpression = parameter.getInitialExpression();
        }
        if (initialExpression == null && parameter.getNodeMetaData("INITIAL_EXPRESSION") != null) {
            initialExpression = (Expression)parameter.getNodeMetaData("INITIAL_EXPRESSION");
        }
        return initialExpression;
    }

    private static boolean isCompatibleArgumentType(ClassNode argumentType, ClassNode parameterType) {
        if (argumentType == null) {
            return false;
        }
        if (ClassHelper.getWrapper(argumentType).equals(ClassHelper.getWrapper(parameterType))) {
            return true;
        }
        if (parameterType.isInterface()) {
            return argumentType.implementsInterface(parameterType);
        }
        if (parameterType.isArray() && argumentType.isArray()) {
            return StaticInvocationWriter.isCompatibleArgumentType(argumentType.getComponentType(), parameterType.getComponentType());
        }
        return ClassHelper.getWrapper(argumentType).isDerivedFrom(ClassHelper.getWrapper(parameterType));
    }

    private void visitArgument(Expression argument, ClassNode parameterType) {
        argument.visit(this.controller.getAcg());
        if (!ExpressionUtils.isNullConstant(argument)) {
            this.controller.getOperandStack().doGroovyCast(parameterType);
        }
    }

    @Override
    public void makeCall(Expression origin, Expression receiver, Expression message, Expression arguments, MethodCallerMultiAdapter adapter, boolean safe, boolean spreadSafe, boolean implicitThis) {
        if (origin.getNodeMetaData((Object)StaticTypesMarker.DYNAMIC_RESOLUTION) != null) {
            StaticTypesWriterController staticController = (StaticTypesWriterController)this.controller;
            if (origin instanceof MethodCallExpression) {
                ((MethodCallExpression)origin).setMethodTarget(null);
            }
            InvocationWriter dynamicInvocationWriter = staticController.getRegularInvocationWriter();
            dynamicInvocationWriter.makeCall(origin, receiver, message, arguments, adapter, safe, spreadSafe, implicitThis);
            return;
        }
        if (implicitThis && this.tryImplicitReceiver(origin, message, arguments, adapter, safe, spreadSafe)) {
            return;
        }
        if (spreadSafe && (origin instanceof MethodCallExpression || origin instanceof PropertyExpression && !this.controller.getCompileStack().isLHS())) {
            Expression nextValue;
            Expression tmpReceiver = receiver;
            if (!(receiver instanceof VariableExpression) && !(receiver instanceof ConstantExpression)) {
                tmpReceiver = new TemporaryVariableExpression(receiver);
            }
            Label nonNull = new Label();
            Label allDone = new Label();
            MethodVisitor mv = this.controller.getMethodVisitor();
            OperandStack operandStack = this.controller.getOperandStack();
            boolean produceResultList = origin.getNodeMetaData("_EXPR_VALUE_UNUSED") == null;
            tmpReceiver.visit(this.controller.getAcg());
            mv.visitJumpInsn(199, nonNull);
            operandStack.remove(1);
            if (produceResultList) {
                mv.visitInsn(1);
            }
            mv.visitJumpInsn(167, allDone);
            mv.visitLabel(nonNull);
            ClassNode resultType = (ClassNode)origin.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
            ClassNode valuesType = (ClassNode)origin.getNodeMetaData((Object)StaticCompilationMetadataKeys.COMPONENT_TYPE);
            if (valuesType == null) {
                valuesType = StaticTypeCheckingVisitor.inferLoopElementType(resultType);
            }
            ConstructorCallExpression cce = GeneralUtils.ctorX(StaticCompilationVisitor.ARRAYLIST_CLASSNODE);
            cce.putNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET, StaticCompilationVisitor.ARRAYLIST_CONSTRUCTOR);
            TemporaryVariableExpression result = new TemporaryVariableExpression(cce);
            if (produceResultList) {
                result.visit(this.controller.getAcg());
            }
            ClassNode elementType = StaticTypeCheckingVisitor.inferLoopElementType(this.controller.getTypeChooser().resolveType(receiver, this.controller.getClassNode()));
            Parameter element = new Parameter(elementType, "for$it$" + this.labelCounter.incrementAndGet());
            if (origin instanceof MethodCallExpression) {
                MethodCallExpression oldMCE = (MethodCallExpression)origin;
                MethodCallExpression newMCE = GeneralUtils.callX((Expression)GeneralUtils.varX(element), oldMCE.getMethod(), oldMCE.getArguments());
                newMCE.setGenericsTypes(oldMCE.getGenericsTypes());
                newMCE.setImplicitThis(false);
                MethodNode target = oldMCE.getMethodTarget();
                newMCE.setMethodTarget(target);
                if (target == null || !target.isVoidMethod()) {
                    newMCE.setNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, valuesType);
                }
                newMCE.setSafe(true);
                nextValue = newMCE;
            } else {
                PropertyExpression oldPE = (PropertyExpression)origin;
                PropertyExpression newPE = origin instanceof AttributeExpression ? new AttributeExpression(GeneralUtils.varX(element), oldPE.getProperty(), true) : new PropertyExpression(GeneralUtils.varX(element), oldPE.getProperty(), true);
                newPE.setImplicitThis(false);
                newPE.setNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, valuesType);
                nextValue = newPE;
            }
            MethodCallExpression addNextValue = GeneralUtils.callX((Expression)result, "add", nextValue);
            addNextValue.setImplicitThis(false);
            addNextValue.setMethodTarget(StaticCompilationVisitor.ARRAYLIST_ADD_METHOD);
            ForStatement stmt = new ForStatement(element, tmpReceiver, GeneralUtils.stmt(produceResultList ? addNextValue : nextValue));
            stmt.visit(this.controller.getAcg());
            if (produceResultList) {
                result.remove(this.controller);
            }
            mv.visitLabel(allDone);
            if (tmpReceiver instanceof TemporaryVariableExpression) {
                ((TemporaryVariableExpression)tmpReceiver).remove(this.controller);
            }
        } else if (safe && origin instanceof MethodCallExpression) {
            CompileStack compileStack = this.controller.getCompileStack();
            OperandStack operandStack = this.controller.getOperandStack();
            MethodVisitor mv = this.controller.getMethodVisitor();
            int counter = this.labelCounter.incrementAndGet();
            Label ifnull = compileStack.createLocalLabel("ifnull_" + counter);
            Label nonull = compileStack.createLocalLabel("nonull_" + counter);
            Label theEnd = compileStack.createLocalLabel("ending_" + counter);
            ExpressionAsVariableSlot slot = new ExpressionAsVariableSlot(this.controller, receiver);
            slot.visit(this.controller.getAcg());
            operandStack.box();
            mv.visitJumpInsn(198, ifnull);
            operandStack.remove(1);
            mv.visitLabel(nonull);
            MethodCallExpression newMCE = (MethodCallExpression)origin.transformExpression(expression -> expression);
            newMCE.setObjectExpression(new VariableSlotLoader(slot.getType(), slot.getIndex(), operandStack));
            newMCE.getObjectExpression().setSourcePosition(((MethodCallExpression)origin).getObjectExpression());
            newMCE.setSafe(false);
            int osl = operandStack.getStackLength();
            newMCE.visit(this.controller.getAcg());
            compileStack.removeVar(slot.getIndex());
            if (operandStack.getStackLength() > osl) {
                operandStack.box();
                mv.visitJumpInsn(167, theEnd);
                mv.visitLabel(ifnull);
                mv.visitInsn(1);
                mv.visitLabel(theEnd);
            } else {
                mv.visitLabel(ifnull);
            }
        } else {
            if (origin instanceof AttributeExpression && (adapter == AsmClassGenerator.getField || adapter == AsmClassGenerator.getGroovyObjectField)) {
                ClassNode receiverType;
                CallSiteWriter callSiteWriter = this.controller.getCallSiteWriter();
                String fieldName = ((AttributeExpression)origin).getPropertyAsString();
                if (fieldName != null && callSiteWriter instanceof StaticTypesCallSiteWriter && ((StaticTypesCallSiteWriter)callSiteWriter).makeGetField(receiver, receiverType = this.controller.getTypeChooser().resolveType(receiver, this.controller.getClassNode()), fieldName, safe, false)) {
                    return;
                }
            }
            super.makeCall(origin, receiver, message, arguments, adapter, safe, spreadSafe, implicitThis);
        }
    }

    private boolean tryImplicitReceiver(Expression origin, Expression message, Expression arguments, MethodCallerMultiAdapter adapter, boolean safe, boolean spreadSafe) {
        Object implicitReceiver = origin.getNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER);
        if (implicitReceiver == null && origin instanceof MethodCallExpression) {
            implicitReceiver = ((MethodCallExpression)origin).getObjectExpression().getNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER);
        }
        if (implicitReceiver != null) {
            String[] path = ((String)implicitReceiver).split("\\.");
            PropertyExpression pexp = GeneralUtils.propX((Expression)GeneralUtils.varX("this", ClassHelper.CLOSURE_TYPE), path[0]);
            pexp.setImplicitThis(true);
            int n = path.length;
            for (int i = 1; i < n; ++i) {
                pexp.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, ClassHelper.CLOSURE_TYPE);
                pexp = GeneralUtils.propX((Expression)pexp, path[i]);
            }
            pexp.putNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER, implicitReceiver);
            origin.removeNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER);
            if (origin instanceof PropertyExpression) {
                PropertyExpression rewritten = GeneralUtils.propX(pexp, ((PropertyExpression)origin).getProperty(), ((PropertyExpression)origin).isSafe());
                rewritten.setSpreadSafe(((PropertyExpression)origin).isSpreadSafe());
                rewritten.visit(this.controller.getAcg());
                rewritten.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, origin.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE));
            } else {
                this.makeCall(origin, pexp, message, arguments, adapter, safe, spreadSafe, false);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean makeCachedCall(Expression origin, ClassExpression sender, Expression receiver, Expression message, Expression arguments, MethodCallerMultiAdapter adapter, boolean safe, boolean spreadSafe, boolean implicitThis, boolean containsSpreadExpression) {
        return false;
    }

    private class CheckcastReceiverExpression
    extends Expression {
        private final Expression receiver;
        private final MethodNode target;

        public CheckcastReceiverExpression(Expression receiver, MethodNode target) {
            this.receiver = receiver;
            this.target = target;
            this.setType(null);
        }

        @Override
        public Expression transformExpression(ExpressionTransformer transformer) {
            return this;
        }

        @Override
        public void visit(GroovyCodeVisitor visitor) {
            this.receiver.visit(visitor);
            if (visitor instanceof AsmClassGenerator) {
                ClassNode topOperand = StaticInvocationWriter.this.controller.getOperandStack().getTopOperand();
                ClassNode type = this.getType();
                if (ClassHelper.isGStringType(topOperand) && ClassHelper.isStringType(type)) {
                    StaticInvocationWriter.this.controller.getOperandStack().doGroovyCast(type);
                    return;
                }
                if (ClassHelper.isPrimitiveType(topOperand) && !ClassHelper.isPrimitiveType(type)) {
                    StaticInvocationWriter.this.controller.getOperandStack().box();
                } else if (!ClassHelper.isPrimitiveType(topOperand) && ClassHelper.isPrimitiveType(type)) {
                    StaticInvocationWriter.this.controller.getOperandStack().doGroovyCast(type);
                }
                if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(topOperand, type)) {
                    return;
                }
                StaticInvocationWriter.this.controller.getMethodVisitor().visitTypeInsn(192, type.isArray() ? BytecodeHelper.getTypeDescription(type) : BytecodeHelper.getClassInternalName(type.getName()));
                StaticInvocationWriter.this.controller.getOperandStack().replace(type);
            }
        }

        @Override
        public ClassNode getType() {
            ClassNode type = super.getType();
            if (type == null) {
                if (this.target instanceof ExtensionMethodNode) {
                    type = ((ExtensionMethodNode)this.target).getExtensionMethodNode().getDeclaringClass();
                } else {
                    type = StaticInvocationWriter.this.controller.getTypeChooser().resolveType(this.receiver, StaticInvocationWriter.this.controller.getClassNode());
                    if (ClassHelper.isPrimitiveType(type)) {
                        type = ClassHelper.getWrapper(type);
                    }
                    ClassNode declaringClass = this.target.getDeclaringClass();
                    Class<?> typeClass = type.getClass();
                    if (typeClass != ClassNode.class && typeClass != InnerClassNode.class && typeClass != DecompiledClassNode.class && typeClass != EnumConstantClassNode.class) {
                        type = declaringClass;
                    }
                    if (ClassHelper.isObjectType(declaringClass)) {
                        type = ClassHelper.OBJECT_TYPE;
                    } else if (ClassHelper.isObjectType(type)) {
                        type = declaringClass;
                    }
                }
                this.setType(type);
            }
            return type;
        }
    }
}

