/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.cache;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.ClientMode;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.FailureMode;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.MemcachedClientIF;
import net.spy.memcached.internal.BulkFuture;
import net.spy.memcached.metrics.MetricCollector;
import net.spy.memcached.metrics.MetricType;
import net.spy.memcached.ops.LinkedOperationQueueFactory;
import net.spy.memcached.ops.OperationQueueFactory;
import net.spy.memcached.transcoders.Transcoder;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheStats;
import org.apache.druid.client.cache.LZ4Transcoder;
import org.apache.druid.client.cache.MemcacheClientPool;
import org.apache.druid.client.cache.MemcachedCacheConfig;
import org.apache.druid.client.cache.MemcachedCustomConnectionFactoryBuilder;
import org.apache.druid.client.cache.MemcachedOperationQueueFactory;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.collections.StupidResourceHolder;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.AbstractMonitor;

public class MemcachedCache
implements Cache {
    private static final Logger log = new Logger(MemcachedCache.class);
    static final HashAlgorithm MURMUR3_128 = new HashAlgorithm(){
        final HashFunction fn = Hashing.murmur3_128();

        public long hash(String k) {
            return this.fn.hashString((CharSequence)k, StandardCharsets.UTF_8).asLong();
        }

        public String toString() {
            return this.fn.toString();
        }
    };
    private final int timeout;
    private final int expiration;
    private final String memcachedPrefix;
    private final Supplier<ResourceHolder<MemcachedClientIF>> client;
    private final AtomicLong hitCount = new AtomicLong(0L);
    private final AtomicLong missCount = new AtomicLong(0L);
    private final AtomicLong timeoutCount = new AtomicLong(0L);
    private final AtomicLong errorCount = new AtomicLong(0L);
    private final AbstractMonitor monitor;
    public static final int MAX_PREFIX_LENGTH = 168;

    public static MemcachedCache create(MemcachedCacheConfig config) {
        final ConcurrentHashMap counters = new ConcurrentHashMap();
        final ConcurrentHashMap meters = new ConcurrentHashMap();
        AbstractMonitor monitor = new AbstractMonitor(){
            final AtomicReference<Map<String, Long>> priorValues = new AtomicReference(new HashMap());

            public boolean doMonitor(ServiceEmitter emitter) {
                Map<String, Long> priorValues = this.priorValues.get();
                Map<String, Long> currentValues = this.getCurrentValues();
                ServiceMetricEvent.Builder builder = ServiceMetricEvent.builder();
                for (Map.Entry<String, Long> entry : currentValues.entrySet()) {
                    emitter.emit((ServiceEventBuilder)builder.setDimension("memcached metric", (Object)entry.getKey()).setMetric("query/cache/memcached/total", (Number)entry.getValue()));
                    Long prior = priorValues.get(entry.getKey());
                    if (prior == null) continue;
                    emitter.emit((ServiceEventBuilder)builder.setDimension("memcached metric", (Object)entry.getKey()).setMetric("query/cache/memcached/delta", (Number)(entry.getValue() - prior)));
                }
                if (!this.priorValues.compareAndSet(priorValues, currentValues)) {
                    log.error("Prior value changed while I was reporting! updating anyways", new Object[0]);
                    this.priorValues.set(currentValues);
                }
                return true;
            }

            private Map<String, Long> getCurrentValues() {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Map.Entry entry : counters.entrySet()) {
                    builder.put((Object)((String)entry.getKey()), (Object)((AtomicLong)entry.getValue()).get());
                }
                for (Map.Entry entry : meters.entrySet()) {
                    builder.put((Object)((String)entry.getKey()), (Object)((AtomicLong)entry.getValue()).get());
                }
                return builder.build();
            }
        };
        try {
            LZ4Transcoder transcoder = new LZ4Transcoder(config.getMaxObjectSize());
            transcoder.setCompressionThreshold(0);
            long maxQueueBytes = config.getMaxOperationQueueSize();
            Object opQueueFactory = maxQueueBytes > 0L ? new MemcachedOperationQueueFactory(maxQueueBytes) : new LinkedOperationQueueFactory();
            Predicate<String> interesting = new Predicate<String>(){
                private final Set<String> interestingMetrics = ImmutableSet.of((Object)"[MEM] Reconnecting Nodes (ReconnectQueue)", (Object)"[MEM] Request Rate: All", (Object)"[MEM] Average Bytes written to OS per write", (Object)"[MEM] Average Bytes read from OS per read", (Object)"[MEM] Average Time on wire for operations (\u00b5s)", (Object)"[MEM] Response Rate: All (Failure + Success + Retry)", (Object[])new String[]{"[MEM] Response Rate: Retry", "[MEM] Response Rate: Failure", "[MEM] Response Rate: Success"});

                public boolean apply(@Nullable String input) {
                    return input != null && this.interestingMetrics.contains(input);
                }
            };
            MetricCollector metricCollector = new MetricCollector(){
                final /* synthetic */ Predicate val$interesting;
                final /* synthetic */ ConcurrentMap val$counters;
                final /* synthetic */ ConcurrentMap val$meters;
                {
                    this.val$interesting = predicate;
                    this.val$counters = concurrentMap;
                    this.val$meters = concurrentMap2;
                }

                public void addCounter(String name) {
                    if (!this.val$interesting.apply((Object)name)) {
                        return;
                    }
                    this.val$counters.putIfAbsent(name, new AtomicLong(0L));
                    if (log.isDebugEnabled()) {
                        log.debug("Add Counter [%s]", new Object[]{name});
                    }
                }

                public void removeCounter(String name) {
                    if (log.isDebugEnabled()) {
                        log.debug("Ignoring request to remove [%s]", new Object[]{name});
                    }
                }

                public void incrementCounter(String name) {
                    if (!this.val$interesting.apply((Object)name)) {
                        return;
                    }
                    AtomicLong counter = (AtomicLong)this.val$counters.get(name);
                    if (counter == null) {
                        this.val$counters.putIfAbsent(name, new AtomicLong(0L));
                        counter = (AtomicLong)this.val$counters.get(name);
                    }
                    counter.incrementAndGet();
                    if (log.isDebugEnabled()) {
                        log.debug("Increment [%s]", new Object[]{name});
                    }
                }

                public void incrementCounter(String name, int amount) {
                    if (!this.val$interesting.apply((Object)name)) {
                        return;
                    }
                    AtomicLong counter = (AtomicLong)this.val$counters.get(name);
                    if (counter == null) {
                        this.val$counters.putIfAbsent(name, new AtomicLong(0L));
                        counter = (AtomicLong)this.val$counters.get(name);
                    }
                    counter.addAndGet(amount);
                    if (log.isDebugEnabled()) {
                        log.debug("Increment [%s] %d", new Object[]{name, amount});
                    }
                }

                public void decrementCounter(String name) {
                    if (!this.val$interesting.apply((Object)name)) {
                        return;
                    }
                    AtomicLong counter = (AtomicLong)this.val$counters.get(name);
                    if (counter == null) {
                        this.val$counters.putIfAbsent(name, new AtomicLong(0L));
                        counter = (AtomicLong)this.val$counters.get(name);
                    }
                    counter.decrementAndGet();
                    if (log.isDebugEnabled()) {
                        log.debug("Decrement [%s]", new Object[]{name});
                    }
                }

                public void decrementCounter(String name, int amount) {
                    if (!this.val$interesting.apply((Object)name)) {
                        return;
                    }
                    AtomicLong counter = (AtomicLong)this.val$counters.get(name);
                    if (counter == null) {
                        this.val$counters.putIfAbsent(name, new AtomicLong(0L));
                        counter = (AtomicLong)this.val$counters.get(name);
                    }
                    counter.addAndGet(-amount);
                    if (log.isDebugEnabled()) {
                        log.debug("Decrement [%s] %d", new Object[]{name, amount});
                    }
                }

                public void addMeter(String name) {
                    if (!this.val$interesting.apply((Object)name)) {
                        return;
                    }
                    this.val$meters.putIfAbsent(name, new AtomicLong(0L));
                    if (log.isDebugEnabled()) {
                        log.debug("Adding meter [%s]", new Object[]{name});
                    }
                }

                public void removeMeter(String name) {
                    if (!this.val$interesting.apply((Object)name)) {
                        return;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Ignoring request to remove meter [%s]", new Object[]{name});
                    }
                }

                public void markMeter(String name) {
                    if (!this.val$interesting.apply((Object)name)) {
                        return;
                    }
                    AtomicLong meter = (AtomicLong)this.val$meters.get(name);
                    if (meter == null) {
                        this.val$meters.putIfAbsent(name, new AtomicLong(0L));
                        meter = (AtomicLong)this.val$meters.get(name);
                    }
                    meter.incrementAndGet();
                    if (log.isDebugEnabled()) {
                        log.debug("Increment counter [%s]", new Object[]{name});
                    }
                }

                public void addHistogram(String name) {
                    log.debug("Ignoring add histogram [%s]", new Object[]{name});
                }

                public void removeHistogram(String name) {
                    log.debug("Ignoring remove histogram [%s]", new Object[]{name});
                }

                public void updateHistogram(String name, int amount) {
                    log.debug("Ignoring update histogram [%s]: %d", new Object[]{name, amount});
                }
            };
            final ConnectionFactory connectionFactory = MemcachedCache.createConnectionFactory(config, transcoder, (OperationQueueFactory)opQueueFactory, metricCollector);
            final List hosts = AddrUtil.getAddresses((String)config.getHosts());
            Supplier clientSupplier = config.getNumConnections() > 1 ? new MemcacheClientPool(config.getNumConnections(), new Supplier<MemcachedClientIF>(){

                public MemcachedClientIF get() {
                    try {
                        return new MemcachedClient(connectionFactory, hosts);
                    }
                    catch (IOException e) {
                        log.error((Throwable)e, "Unable to create memcached client", new Object[0]);
                        throw new RuntimeException(e);
                    }
                }
            }) : Suppliers.ofInstance((Object)StupidResourceHolder.create((Object)new MemcachedClient(connectionFactory, hosts)));
            return new MemcachedCache((Supplier<ResourceHolder<MemcachedClientIF>>)clientSupplier, config, monitor);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
    }

    public static ConnectionFactory createConnectionFactory(MemcachedCacheConfig config, LZ4Transcoder transcoder, OperationQueueFactory opQueueFactory, MetricCollector metricCollector) throws KeyManagementException, KeyStoreException, NoSuchAlgorithmException {
        MemcachedCustomConnectionFactoryBuilder connectionFactoryBuilder = (MemcachedCustomConnectionFactoryBuilder)new MemcachedCustomConnectionFactoryBuilder().setKetamaNodeRepetitions(1000).setHashAlg(MURMUR3_128).setProtocol(ConnectionFactoryBuilder.Protocol.valueOf((String)StringUtils.toUpperCase((String)config.getProtocol()))).setLocatorType(ConnectionFactoryBuilder.Locator.valueOf((String)StringUtils.toUpperCase((String)config.getLocator()))).setDaemon(true).setFailureMode(FailureMode.Cancel).setTranscoder((Transcoder)transcoder).setShouldOptimize(true).setOpQueueMaxBlockTime((long)config.getTimeout()).setOpTimeout((long)config.getTimeout()).setReadBufferSize(config.getReadBufferSize()).setOpQueueFactory(opQueueFactory).setMetricCollector(metricCollector).setEnableMetrics(MetricType.DEBUG);
        if (config.enableTls()) {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init((KeyStore)null);
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, tmf.getTrustManagers(), null);
            connectionFactoryBuilder.setSSLContext(sslContext);
        }
        if ("dynamic".equals(config.getClientMode())) {
            connectionFactoryBuilder.setClientMode(ClientMode.Dynamic);
            connectionFactoryBuilder.setHostnameForTlsVerification(config.getHosts().split(",")[0]);
        } else if ("static".equals(config.getClientMode())) {
            connectionFactoryBuilder.setClientMode(ClientMode.Static);
        } else {
            throw new RuntimeException("Invalid value provided for `druid.cache.clientMode`. Value must be 'static' or 'dynamic'.");
        }
        connectionFactoryBuilder.setSkipTlsHostnameVerification(config.skipTlsHostnameVerification());
        return connectionFactoryBuilder.build();
    }

    MemcachedCache(Supplier<ResourceHolder<MemcachedClientIF>> client, MemcachedCacheConfig config, AbstractMonitor monitor) {
        Preconditions.checkArgument((config.getMemcachedPrefix().length() <= 168 ? 1 : 0) != 0, (String)"memcachedPrefix length [%s] exceeds maximum length [%s]", (int)config.getMemcachedPrefix().length(), (int)168);
        this.monitor = monitor;
        this.timeout = config.getTimeout();
        this.expiration = config.getExpiration();
        this.client = client;
        this.memcachedPrefix = config.getMemcachedPrefix();
    }

    @Override
    public CacheStats getStats() {
        return new CacheStats(this.hitCount.get(), this.missCount.get(), 0L, 0L, 0L, this.timeoutCount.get(), this.errorCount.get());
    }

    @Override
    public byte[] get(Cache.NamedKey key) {
        ResourceHolder clientHolder = (ResourceHolder)this.client.get();
        try {
            Future future;
            try {
                future = ((MemcachedClientIF)clientHolder.get()).asyncGet(MemcachedCache.computeKeyHash(this.memcachedPrefix, key));
            }
            catch (IllegalStateException e) {
                this.errorCount.incrementAndGet();
                log.warn((Throwable)e, "Unable to queue cache operation", new Object[0]);
                byte[] byArray = null;
                if (clientHolder != null) {
                    clientHolder.close();
                }
                return byArray;
            }
            byte[] bytes = (byte[])future.get(this.timeout, TimeUnit.MILLISECONDS);
            if (bytes != null) {
                this.hitCount.incrementAndGet();
            } else {
                this.missCount.incrementAndGet();
            }
            byte[] byArray = bytes == null ? null : MemcachedCache.deserializeValue(key, bytes);
            return byArray;
        }
        finally {
            if (clientHolder != null) {
                try {
                    clientHolder.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    @Override
    public void put(Cache.NamedKey key, byte[] value) {
        try (ResourceHolder clientHolder = (ResourceHolder)this.client.get();){
            ((MemcachedClientIF)clientHolder.get()).set(MemcachedCache.computeKeyHash(this.memcachedPrefix, key), this.expiration, (Object)MemcachedCache.serializeValue(key, value));
        }
        catch (IllegalStateException e) {
            this.errorCount.incrementAndGet();
            log.warn((Throwable)e, "Unable to queue cache operation", new Object[0]);
        }
    }

    private static byte[] serializeValue(Cache.NamedKey key, byte[] value) {
        byte[] keyBytes = key.toByteArray();
        return ByteBuffer.allocate(4 + keyBytes.length + value.length).putInt(keyBytes.length).put(keyBytes).put(value).array();
    }

    private static byte[] deserializeValue(Cache.NamedKey key, byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        int keyLength = buf.getInt();
        byte[] keyBytes = new byte[keyLength];
        buf.get(keyBytes);
        byte[] value = new byte[buf.remaining()];
        buf.get(value);
        Preconditions.checkState((boolean)Arrays.equals(keyBytes, key.toByteArray()), (Object)"Keys do not match, possible hash collision?");
        return value;
    }

    @Override
    public Map<Cache.NamedKey, byte[]> getBulk(Iterable<Cache.NamedKey> keys) {
        ResourceHolder clientHolder = (ResourceHolder)this.client.get();
        try {
            BulkFuture future;
            ImmutableMap keyLookup = Maps.uniqueIndex(keys, (Function)new Function<Cache.NamedKey, String>(){

                public String apply(@Nullable Cache.NamedKey input) {
                    return MemcachedCache.computeKeyHash(MemcachedCache.this.memcachedPrefix, input);
                }
            });
            HashMap<Cache.NamedKey, byte[]> results = new HashMap<Cache.NamedKey, byte[]>();
            try {
                future = ((MemcachedClientIF)clientHolder.get()).asyncGetBulk(keyLookup.keySet());
            }
            catch (IllegalStateException e) {
                this.errorCount.incrementAndGet();
                log.warn((Throwable)e, "Unable to queue cache operation", new Object[0]);
                HashMap<Cache.NamedKey, byte[]> hashMap = results;
                if (clientHolder != null) {
                    clientHolder.close();
                }
                return hashMap;
            }
            Map some = (Map)future.getSome((long)this.timeout, TimeUnit.MILLISECONDS);
            if (future.isTimeout()) {
                future.cancel(false);
                this.timeoutCount.incrementAndGet();
            }
            this.missCount.addAndGet(keyLookup.size() - some.size());
            this.hitCount.addAndGet(some.size());
            for (Map.Entry entry : some.entrySet()) {
                Cache.NamedKey key = (Cache.NamedKey)keyLookup.get(entry.getKey());
                byte[] value = (byte[])entry.getValue();
                if (value == null) continue;
                results.put(key, MemcachedCache.deserializeValue(key, value));
            }
            HashMap<Cache.NamedKey, byte[]> hashMap = results;
            return hashMap;
        }
        finally {
            if (clientHolder != null) {
                try {
                    clientHolder.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    @Override
    public void close(String namespace) {
    }

    @Override
    @LifecycleStop
    public void close() {
        this.monitor.stop();
    }

    private static String computeKeyHash(String memcachedPrefix, Cache.NamedKey key) {
        return memcachedPrefix + ":" + DigestUtils.sha1Hex((String)key.namespace) + ":" + DigestUtils.sha1Hex((byte[])key.key);
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public void doMonitor(ServiceEmitter emitter) {
        this.monitor.doMonitor(emitter);
    }
}

