/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit;

import org.apache.druid.msq.kernel.GlobalSortMaxCountShuffleSpec;
import org.apache.druid.msq.kernel.GlobalSortTargetSizeShuffleSpec;
import org.apache.druid.msq.kernel.MixShuffleSpec;
import org.apache.druid.msq.querykit.ShuffleSpecFactory;

public class ShuffleSpecFactories {
    private ShuffleSpecFactories() {
    }

    public static ShuffleSpecFactory singlePartition() {
        return ShuffleSpecFactories.singlePartitionWithLimit(-1L);
    }

    public static ShuffleSpecFactory singlePartitionWithLimit(long limitHint) {
        return (clusterBy, aggregate) -> {
            if (clusterBy.sortable() && !clusterBy.isEmpty()) {
                return new GlobalSortMaxCountShuffleSpec(clusterBy, 1, aggregate, limitHint);
            }
            return MixShuffleSpec.instance();
        };
    }

    public static ShuffleSpecFactory globalSortWithMaxPartitionCount(int partitions) {
        return (clusterBy, aggregate) -> new GlobalSortMaxCountShuffleSpec(clusterBy, partitions, aggregate, -1L);
    }

    public static ShuffleSpecFactory getGlobalSortWithTargetSize(int targetSize) {
        return (clusterBy, aggregate) -> {
            if (clusterBy.isEmpty()) {
                return MixShuffleSpec.instance();
            }
            return new GlobalSortTargetSizeShuffleSpec(clusterBy, targetSize, aggregate);
        };
    }
}

