/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import org.apache.datasketches.memory.Memory;
import org.apache.druid.frame.field.ReadableFieldPointer;
import org.apache.druid.frame.segment.row.ReadableFrameRowPointer;

public class RowMemoryFieldPointer
implements ReadableFieldPointer {
    private final Memory memory;
    private final ReadableFrameRowPointer rowPointer;
    private final int fieldNumber;
    private final int fieldCount;
    private long rowWithCachedPosition = -1L;
    private long cachedPosition = -1L;
    private long rowWithCachedLength = -1L;
    private long cachedLength = -1L;

    public RowMemoryFieldPointer(Memory memory, ReadableFrameRowPointer rowPointer, int fieldNumber, int fieldCount) {
        this.memory = memory;
        this.rowPointer = rowPointer;
        this.fieldNumber = fieldNumber;
        this.fieldCount = fieldCount;
    }

    @Override
    public long position() {
        this.updatePosition();
        return this.cachedPosition;
    }

    @Override
    public long length() {
        this.updatePositionAndLength();
        return this.cachedLength;
    }

    private void updatePosition() {
        long rowPointerPosition = this.rowPointer.position();
        if (rowPointerPosition == this.rowWithCachedPosition) {
            return;
        }
        this.rowWithCachedPosition = rowPointerPosition;
        this.cachedPosition = this.startPosition(this.fieldNumber);
    }

    private void updatePositionAndLength() {
        this.updatePosition();
        long rowPointerPosition = this.rowWithCachedPosition;
        if (rowPointerPosition == this.rowWithCachedLength) {
            return;
        }
        this.rowWithCachedLength = rowPointerPosition;
        this.cachedLength = this.fieldNumber == this.fieldCount - 1 ? rowPointerPosition + this.rowPointer.length() - this.cachedPosition : this.startPosition(this.fieldNumber + 1) - this.cachedPosition;
    }

    private long startPosition(int fieldNumber) {
        if (fieldNumber == 0) {
            return this.rowPointer.position() + 4L * (long)this.fieldCount;
        }
        return this.rowPointer.position() + (long)this.memory.getInt(this.rowPointer.position() + 4L * (long)(fieldNumber - 1));
    }
}

