/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.util;

import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.apache.torque.ConstraintViolationException;
import org.apache.torque.DeadlockException;
import org.apache.torque.TorqueException;
import org.apache.torque.util.ExceptionMapper;

public class ExceptionMapperImpl
extends ExceptionMapper {
    private static final int ORACLE_DEADLOCK_ERROR_CODE = 60;

    @Override
    public TorqueException toTorqueException(SQLException sqlException) {
        if (StringUtils.startsWith((CharSequence)sqlException.getSQLState(), (CharSequence)"23")) {
            return new ConstraintViolationException(sqlException);
        }
        if (StringUtils.equals((CharSequence)sqlException.getSQLState(), (CharSequence)"40001")) {
            return new DeadlockException(sqlException);
        }
        if (StringUtils.equals((CharSequence)sqlException.getSQLState(), (CharSequence)"40P01")) {
            return new DeadlockException(sqlException);
        }
        if (StringUtils.equals((CharSequence)sqlException.getSQLState(), (CharSequence)"61000") && sqlException.getErrorCode() == 60) {
            return new DeadlockException(sqlException);
        }
        return new TorqueException(sqlException);
    }
}

