/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.ij;

import java.io.IOException;
import java.io.Reader;
import org.apache.derby.iapi.tools.i18n.LocalizedInput;
import org.apache.derby.iapi.tools.i18n.LocalizedOutput;
import org.apache.derby.impl.tools.ij.ijException;
import org.apache.derby.impl.tools.ij.utilMain;

public class StatementFinder {
    private Reader source;
    private StringBuffer statement = new StringBuffer();
    private int state;
    private boolean atEOF = false;
    private boolean peekEOF = false;
    private char peekChar;
    private boolean peeked = false;
    private LocalizedOutput promptwriter;
    private boolean doPrompt;
    private boolean continuedStatement;
    private static final int IN_STATEMENT = 0;
    private static final int IN_STRING = 1;
    private static final int IN_SQLCOMMENT = 2;
    private static final int END_OF_STATEMENT = 3;
    private static final int END_OF_INPUT = 4;
    private static final char MINUS = '-';
    private static final char SINGLEQUOTE = '\'';
    private static final char DOUBLEQUOTE = '\"';
    private static final char SEMICOLON = ';';
    private static final char NEWLINE = '\n';
    private static final char RETURN = '\r';
    private static final char SPACE = ' ';
    private static final char TAB = '\t';
    private static final char FORMFEED = '\f';
    private static final char SLASH = '/';
    private static final char ASTERISK = '*';

    public StatementFinder(LocalizedInput s, LocalizedOutput promptDest) {
        this.source = s;
        if (promptDest != null && s.isStandardInput()) {
            this.promptwriter = promptDest;
            this.doPrompt = true;
        } else {
            this.doPrompt = false;
        }
    }

    public void ReInit(LocalizedInput s) {
        try {
            this.source.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.source = s;
        this.state = 0;
        this.atEOF = false;
        this.peekEOF = false;
        this.peeked = false;
        this.doPrompt = s.isStandardInput() && this.promptwriter != null;
    }

    public void close() throws IOException {
        this.source.close();
    }

    public String nextStatement() {
        boolean haveSemi = false;
        this.statement.setLength(0);
        if (this.state == 4) {
            return null;
        }
        this.state = 0;
        char nextChar = this.peekChar();
        if (this.peekEOF()) {
            this.state = 4;
            return null;
        }
        if (this.whiteSpace(nextChar)) {
            while (this.whiteSpace(this.peekChar()) && !this.peekEOF()) {
            }
            if (this.peekEOF()) {
                this.state = 4;
                return null;
            }
        }
        while (this.state != 3 && this.state != 4) {
            nextChar = this.readChar();
            if (this.atEOF()) {
                this.state = 4;
                break;
            }
            if (nextChar != '-') {
                this.continuedStatement = true;
            }
            switch (nextChar) {
                case '-': {
                    this.readSingleLineComment(nextChar);
                    break;
                }
                case '/': {
                    this.readBracketedComment();
                    break;
                }
                case '\"': 
                case '\'': {
                    this.readString(nextChar);
                    break;
                }
                case ';': {
                    haveSemi = true;
                    this.state = 3;
                    this.continuedStatement = false;
                    break;
                }
                case '\n': 
                case '\r': {
                    if (!this.doPrompt) break;
                    utilMain.doPrompt(false, this.promptwriter, "");
                    if (nextChar != '\r' || this.peekChar() != '\n') break;
                    this.readChar();
                }
            }
        }
        if (haveSemi) {
            this.statement.setLength(this.statement.length() - 1);
        }
        return this.statement.toString();
    }

    private boolean whiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\f';
    }

    private void readBracketedComment() {
        char nextChar = this.peekChar();
        if (this.peekEOF()) {
            return;
        }
        if (nextChar != '*') {
            this.continuedStatement = true;
            return;
        }
        this.readChar();
        int nestingLevel = 1;
        while (true) {
            nextChar = this.readChar();
            if (this.atEOF()) {
                this.state = 0;
                return;
            }
            char peek = this.peekChar();
            if (nextChar == '/' && peek == '*') {
                this.readChar();
                ++nestingLevel;
                continue;
            }
            if (nextChar == '*' && peek == '/') {
                this.readChar();
                if (--nestingLevel != 0) continue;
                this.state = 0;
                return;
            }
            if (nextChar != '\n' && nextChar != '\r' || !this.doPrompt) continue;
            utilMain.doPrompt(false, this.promptwriter, "");
            if (nextChar != '\r' || peek != '\n') continue;
            this.readChar();
        }
    }

    private void readSingleLineComment(char commentChar) {
        char nextChar = this.peekChar();
        if (this.peekEOF()) {
            return;
        }
        if (nextChar != commentChar) {
            this.continuedStatement = true;
            return;
        }
        this.readChar();
        this.state = 2;
        do {
            nextChar = this.peekChar();
            if (this.peekEOF()) {
                this.state = 0;
                return;
            }
            switch (nextChar) {
                case '\n': 
                case '\r': {
                    this.readChar();
                    this.state = 0;
                    if (this.doPrompt) {
                        if (this.continuedStatement) {
                            utilMain.doPrompt(false, this.promptwriter, "");
                        } else {
                            utilMain.doPrompt(true, this.promptwriter, "");
                        }
                        if (nextChar == '\r' && this.peekChar() == '\n') {
                            this.readChar();
                        }
                    }
                    return;
                }
            }
            this.readChar();
        } while (this.state == 2);
    }

    private void readString(char stringDelimiter) {
        this.state = 1;
        do {
            char nextChar = this.readChar();
            if (this.atEOF()) {
                this.state = 4;
                return;
            }
            if (nextChar != stringDelimiter) continue;
            this.state = 0;
            return;
        } while (this.state == 1);
    }

    private boolean atEOF() {
        return this.atEOF;
    }

    private boolean peekEOF() {
        return this.peekEOF;
    }

    private char readChar() {
        if (!this.peeked) {
            this.peekChar();
        }
        this.peeked = false;
        this.atEOF = this.peekEOF;
        if (!this.atEOF) {
            this.statement.append(this.peekChar);
        }
        return this.peekChar;
    }

    private char peekChar() {
        this.peeked = true;
        char c = '\u0000';
        try {
            int cInt = this.source.read();
            boolean bl = this.peekEOF = cInt == -1;
            if (!this.peekEOF) {
                c = (char)cInt;
            }
        }
        catch (IOException ie) {
            throw ijException.iOException(ie);
        }
        this.peekChar = c;
        return c;
    }
}

