/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.impl.store.raw.log.LogToFile;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_Generic;
import org.apache.derbyTesting.unitTests.store.T_RawStoreRow;
import org.apache.derbyTesting.unitTests.store.T_TWC;
import org.apache.derbyTesting.unitTests.store.T_Util;

public class T_RecoverFullLog
extends T_Generic {
    private static final String testService = "FullLogTest";
    static final String REC_001 = "McLaren";
    static final String REC_002 = "Ferrari";
    static final String REC_003 = "Benetton";
    static final String REC_004 = "Prost";
    static final String REC_005 = "Tyrell";
    static final String REC_006 = "Derby, Natscape, Goatscape, the popular names";
    static final String REC_UNDO = "Lotus";
    static final String SP1 = "savepoint1";
    static final String SP2 = "savepoint2";
    private RandomAccessFile infofile = null;
    private static final String infoPath = "extinout/T_RecoverFullLog.info";
    private boolean fillLog;
    private boolean recoveryFail;
    private boolean logSwitchFail;
    private boolean recover;
    private String TEST_FILL_LOG = "TestFillLog";
    private String TEST_FULL_RECOVER_FAIL = "TestFullRecoveryFail";
    private String TEST_LOG_SWITCH_FAIL = "TestLogSwitchFail";
    private String TEST_FULL_RECOVER = "TestFullRecover";
    private static final String TEST_FULL_LOG_INFO = "TestFullLogInfo";
    RawStoreFactory factory;
    LockFactory lf;
    ContextService contextService;
    T_Util t_util;

    @Override
    public String getModuleToTestProtocolName() {
        return "org.apache.derby.iapi.store.raw.RawStoreFactory";
    }

    private void getConfig() {
        String param = PropertyUtil.getSystemProperty((String)this.TEST_FILL_LOG);
        this.fillLog = Boolean.valueOf(param);
        param = PropertyUtil.getSystemProperty((String)this.TEST_FULL_RECOVER_FAIL);
        this.recoveryFail = Boolean.valueOf(param);
        param = PropertyUtil.getSystemProperty((String)this.TEST_FULL_RECOVER);
        this.recover = Boolean.valueOf(param);
        param = PropertyUtil.getSystemProperty((String)this.TEST_LOG_SWITCH_FAIL);
        this.logSwitchFail = Boolean.valueOf(param);
    }

    @Override
    public void runTests() throws T_Fail {
        block32: {
            this.getConfig();
            int tests = 0;
            if (this.fillLog) {
                ++tests;
            }
            if (this.recoveryFail) {
                ++tests;
            }
            if (this.recover) {
                ++tests;
            }
            if (this.logSwitchFail) {
                ++tests;
            }
            if (tests != 1) {
                throw T_Fail.testFailMsg("One & only one of the full log recovery test should be run, now " + tests + " set");
            }
            try {
                this.contextService = T_RecoverFullLog.getContextService();
                File ifile = new File(infoPath);
                File ifdir = new File("extinout");
                if (!ifdir.exists()) {
                    ifdir.mkdirs();
                }
                this.startParams = T_Util.setEncryptionParam(this.startParams);
                if (this.fillLog) {
                    this.REPORT("_______________________________________________________");
                    this.REPORT("\n\t\tcleaning up database for recovering from filled log");
                    this.REPORT("_______________________________________________________");
                    if (this.startParams == null) {
                        this.startParams = new Properties();
                    }
                    this.startParams.put("derby.database.noAutoBoot", Boolean.TRUE.toString());
                    this.startParams.put("derby.__deleteOnCreate", Boolean.TRUE.toString());
                    this.factory = (RawStoreFactory)T_RecoverFullLog.createPersistentService(this.getModuleToTestProtocolName(), testService, this.startParams);
                    if (ifile.exists()) {
                        ifile.delete();
                    }
                    try {
                        this.infofile = new RandomAccessFile(ifile, "rw");
                        break block32;
                    }
                    catch (IOException ioe) {
                        System.out.println("Cannot write to temporary file extinout/T_RecoverFullLog.info.  Please make sure it is correct, if not, please set the property TestFullLogInfo=<where temp files should go>");
                        throw T_Fail.exceptionFail(ioe);
                    }
                }
                this.REPORT("_______________________________________________________");
                if (this.recoveryFail) {
                    this.REPORT("\n\t\trecovering database - recovery will fill up log");
                } else {
                    this.REPORT("\n\t\trecovering database - recovery should succeed");
                }
                this.REPORT("_______________________________________________________");
                try {
                    this.infofile = new RandomAccessFile(ifile, "rw");
                }
                catch (IOException ioe) {
                    throw T_Fail.exceptionFail(ioe);
                }
                if (this.recoveryFail) {
                    SanityManager.DEBUG_SET((String)LogToFile.TEST_LOG_FULL);
                    System.setProperty(LogToFile.TEST_RECORD_TO_FILL_LOG, "10");
                }
                if (!T_RecoverFullLog.startPersistentService(testService, this.startParams)) {
                    throw T_Fail.testFailMsg("Monitor didn't know how to restart service: FullLogTest");
                }
                this.factory = (RawStoreFactory)T_RecoverFullLog.findService(this.getModuleToTestProtocolName(), testService);
                if (this.recoveryFail) {
                    throw T_Fail.testFailMsg("recovery should have failed but did not - did you run the test in order?");
                }
            }
            catch (StandardException mse) {
                if (this.recoveryFail) {
                    this.REPORT("_______________________________________________________");
                    this.REPORT("\n\tRecovery failed due to log full as requested ");
                    this.REPORT("\texception was " + mse.toString());
                    this.REPORT("_______________________________________________________");
                    return;
                }
                throw T_Fail.exceptionFail(mse);
            }
            catch (NullPointerException npe) {
                if (this.recoveryFail) {
                    this.REPORT("_______________________________________________________");
                    this.REPORT("\n\tRecovery failed due to log full as requested ");
                    this.REPORT("\texception was " + npe.toString());
                    this.REPORT("_______________________________________________________");
                    return;
                }
                throw T_Fail.exceptionFail(npe);
            }
        }
        if (this.factory == null) {
            throw T_Fail.testFailMsg(this.getModuleToTestProtocolName() + " service not started.");
        }
        this.lf = this.factory.getLockFactory();
        if (this.lf == null) {
            throw T_Fail.testFailMsg("LockFactory.MODULE not found");
        }
        this.t_util = new T_Util(this.factory, this.lf, this.contextService);
        try {
            if (this.fillLog) {
                this.testBasic(1);
                this.fillUpLog();
            } else if (this.logSwitchFail) {
                this.testBasic(2);
                this.logSwitchFail1();
                this.testBasic(3);
                this.logSwitchFail2();
            } else if (!this.recoveryFail) {
                this.checkRecovery();
            }
        }
        catch (StandardException se) {
            throw T_Fail.exceptionFail(se);
        }
    }

    private long find(long inkey) {
        if (this.infofile == null) {
            return -1L;
        }
        try {
            this.infofile.seek(0L);
            while (true) {
                long key;
                if ((key = this.infofile.readLong()) == inkey) {
                    long value = this.infofile.readLong();
                    return value;
                }
                this.infofile.readLong();
            }
        }
        catch (IOException ioe) {
            return -1L;
        }
    }

    private long key(int test, int param) {
        long i = test;
        return (i << 32) + (long)param;
    }

    private void register(long key, long value) throws T_Fail {
        try {
            this.infofile.seek(this.infofile.length());
            this.infofile.writeLong(key);
            this.infofile.writeLong(value);
        }
        catch (IOException ioe) {
            T_Fail.exceptionFail(ioe);
        }
    }

    protected void testBasic(int testNumber) throws T_Fail, StandardException {
        int j;
        int i;
        int numtrans = 7;
        int numpages = 7;
        T_TWC[] t = new T_TWC[numtrans];
        for (i = 0; i < numtrans; ++i) {
            t[i] = this.t_util.t_startTransactionWithContext();
        }
        long[] cid = new long[numtrans];
        ContainerHandle[] c = new ContainerHandle[numtrans];
        for (i = 0; i < numtrans; ++i) {
            cid[i] = this.t_util.t_addContainer(t[i], 0L);
            this.t_util.t_commit(t[i]);
            c[i] = this.t_util.t_openContainer(t[i], 0L, cid[i], true);
        }
        Page[][] page = new Page[numtrans][numpages];
        long[][] pagenum = new long[numtrans][numpages];
        for (i = 0; i < numtrans; ++i) {
            for (j = 0; j < numpages; ++j) {
                t[i].switchTransactionContext();
                page[i][j] = this.t_util.t_addPage(c[i]);
                pagenum[i][j] = page[i][j].getPageNumber();
                t[i].resetContext();
            }
        }
        RecordHandle[][] rh = new RecordHandle[numtrans][numpages];
        T_RawStoreRow row1 = new T_RawStoreRow(REC_001);
        for (i = 0; i < numtrans; ++i) {
            for (j = 0; j < numpages; ++j) {
                t[i].switchTransactionContext();
                rh[i][j] = T_Util.t_insert(page[i][j], row1);
                t[i].resetContext();
            }
        }
        t[0].setSavePoint(SP1, null);
        T_RawStoreRow row2 = new T_RawStoreRow(REC_002);
        for (i = 0; i < numtrans; ++i) {
            for (j = 0; j < numpages; ++j) {
                t[i].switchTransactionContext();
                int slot = page[i][j].getSlotNumber(rh[i][j]);
                page[i][j].updateAtSlot(slot, (Object[])row2.getRow(), null);
                t[i].resetContext();
            }
        }
        for (i = 1; i < numtrans; ++i) {
            t[i].setSavePoint(SP1, null);
        }
        T_RawStoreRow row3 = new T_RawStoreRow(REC_003);
        for (i = 0; i < numtrans; ++i) {
            for (j = 0; j < numpages; ++j) {
                int slot = page[i][j].getSlotNumber(rh[i][j]);
                page[i][j].updateAtSlot(slot, (Object[])row3.getRow(), null);
            }
        }
        for (i = 0; i < numtrans; ++i) {
            t[i].setSavePoint(SP2, null);
        }
        T_RawStoreRow row4 = new T_RawStoreRow(REC_004);
        for (i = 0; i < numtrans; ++i) {
            t[i].switchTransactionContext();
            for (j = 0; j < numpages; ++j) {
                int slot = page[i][j].getSlotNumber(rh[i][j]);
                page[i][j].updateAtSlot(slot, (Object[])row4.getRow(), null);
            }
            t[i].resetContext();
        }
        t[0].switchTransactionContext();
        for (j = 0; j < numpages; ++j) {
            page[0][j].unlatch();
        }
        t[0].rollbackToSavePoint(SP1, null);
        for (j = 0; j < numpages; ++j) {
            page[0][j] = this.t_util.t_getPage(c[0], pagenum[0][j]);
        }
        t[0].resetContext();
        for (i = 1; i < numtrans; ++i) {
            t[i].switchTransactionContext();
            for (j = 0; j < numpages; ++j) {
                T_Util.t_checkFetch(page[i][j], rh[i][j], REC_004);
            }
            t[i].resetContext();
        }
        t[0].switchTransactionContext();
        for (j = 0; j < numpages; ++j) {
            T_Util.t_checkFetch(page[0][j], rh[0][j], REC_001);
        }
        t[0].resetContext();
        T_RawStoreRow row5 = new T_RawStoreRow(REC_005);
        for (i = 0; i < numtrans; ++i) {
            t[i].switchTransactionContext();
            for (j = 0; j < numpages; ++j) {
                int slot = page[i][j].getSlotNumber(rh[i][j]);
                page[i][j].updateAtSlot(slot, (Object[])row5.getRow(), null);
            }
            t[i].resetContext();
        }
        for (i = 1; i < numtrans; ++i) {
            t[i].switchTransactionContext();
            for (j = 0; j < numpages; ++j) {
                page[i][j].unlatch();
            }
            t[i].rollbackToSavePoint(SP2, null);
            for (j = 0; j < numpages; ++j) {
                page[i][j] = this.t_util.t_getPage(c[i], pagenum[i][j]);
            }
            t[i].resetContext();
        }
        for (i = 1; i < numtrans; ++i) {
            t[i].switchTransactionContext();
            for (j = 0; j < numpages; ++j) {
                T_Util.t_checkFetch(page[i][j], rh[i][j], REC_003);
            }
            t[i].resetContext();
        }
        t[0].switchTransactionContext();
        for (j = 0; j < numpages; ++j) {
            T_Util.t_checkFetch(page[0][j], rh[0][j], REC_005);
        }
        t[0].resetContext();
        T_RawStoreRow row6 = new T_RawStoreRow(REC_006);
        for (i = 0; i < numtrans; ++i) {
            t[i].switchTransactionContext();
            for (j = 0; j < numpages; ++j) {
                int slot = page[i][j].getSlotNumber(rh[i][j]);
                page[i][j].updateAtSlot(slot, (Object[])row6.getRow(), null);
            }
            t[i].resetContext();
        }
        t[0].switchTransactionContext();
        for (j = 0; j < numpages; ++j) {
            page[0][j].unlatch();
        }
        t[0].rollbackToSavePoint(SP1, null);
        for (j = 0; j < numpages; ++j) {
            page[0][j] = this.t_util.t_getPage(c[0], pagenum[0][j]);
        }
        t[0].resetContext();
        for (i = 1; i < numtrans; ++i) {
            t[i].switchTransactionContext();
            for (j = 0; j < numpages; ++j) {
                T_Util.t_checkFetch(page[i][j], rh[i][j], REC_006);
                T_Util.t_checkRecordCount(page[i][j], 1, 1);
            }
            t[i].resetContext();
        }
        t[0].switchTransactionContext();
        for (j = 0; j < numpages; ++j) {
            T_Util.t_checkFetch(page[0][j], rh[0][j], REC_001);
            T_Util.t_checkRecordCount(page[0][j], 1, 1);
        }
        t[0].resetContext();
        for (i = 0; i < numtrans; ++i) {
            t[i].switchTransactionContext();
            for (j = 0; j < numpages; ++j) {
                page[i][j].unlatch();
            }
            t[i].resetContext();
        }
        this.t_util.t_abort(t[1]);
        this.t_util.t_commit(t[2]);
        this.t_util.t_commit(t[4]);
        c[1] = this.t_util.t_openContainer(t[1], 0L, cid[1], false);
        c[2] = this.t_util.t_openContainer(t[2], 0L, cid[2], false);
        c[4] = this.t_util.t_openContainer(t[4], 0L, cid[4], false);
        for (j = 0; j < numpages; ++j) {
            t[0].switchTransactionContext();
            this.t_util.t_checkFetch(c[0], rh[0][j], REC_001);
            t[0].resetContext();
            t[1].switchTransactionContext();
            page[1][j] = this.t_util.t_getPage(c[1], pagenum[1][j]);
            T_Util.t_checkRecordCount(page[1][j], 1, 0);
            T_Util.t_checkFetchBySlot(page[1][j], 0, REC_001, true, false);
            page[1][j].unlatch();
            t[1].resetContext();
            t[2].switchTransactionContext();
            this.t_util.t_checkFetch(c[2], rh[2][j], REC_006);
            t[2].resetContext();
            t[3].switchTransactionContext();
            this.t_util.t_checkFetch(c[3], rh[3][j], REC_006);
            t[3].resetContext();
            t[4].switchTransactionContext();
            this.t_util.t_checkFetch(c[4], rh[4][j], REC_006);
            t[4].resetContext();
        }
        for (i = 0; i < numtrans; ++i) {
            this.register(this.key(testNumber, i + 10), cid[i]);
            String str = "container " + i + ":" + this.find(this.key(testNumber, i + 10)) + " pages: ";
            for (j = 0; j < numpages; ++j) {
                str = str + pagenum[i][j] + " ";
                this.register(this.key(testNumber, (i + 1) * 1000 + j), pagenum[i][j]);
            }
            this.REPORT("\t" + str);
        }
        this.register(this.key(testNumber, 1), numtrans);
        this.register(this.key(testNumber, 2), numpages);
    }

    protected void fillUpLog() throws T_Fail, StandardException {
        SanityManager.DEBUG_SET((String)LogToFile.TEST_LOG_FULL);
        System.setProperty(LogToFile.TEST_RECORD_TO_FILL_LOG, "1");
        Transaction t = this.t_util.t_startTransaction();
        try {
            long l = this.t_util.t_addContainer(t, 0L);
        }
        catch (StandardException se) {
            this.REPORT("_______________________________________________________");
            this.REPORT("\n\tlog filled up as requested");
            this.REPORT("_______________________________________________________");
            return;
        }
        catch (NullPointerException npe) {
            this.REPORT("_______________________________________________________");
            this.REPORT("\n\tlog filled up as requested");
            this.REPORT("_______________________________________________________");
            return;
        }
        throw T_Fail.testFailMsg("log should have filled but did not");
    }

    protected void logSwitchFail1() throws T_Fail, StandardException {
        SanityManager.DEBUG_SET((String)LogToFile.TEST_SWITCH_LOG_FAIL1);
        this.factory.checkpoint();
        SanityManager.DEBUG_CLEAR((String)LogToFile.TEST_SWITCH_LOG_FAIL1);
    }

    protected void logSwitchFail2() throws T_Fail, StandardException {
        SanityManager.DEBUG_SET((String)LogToFile.TEST_SWITCH_LOG_FAIL2);
        int tries = 10;
        try {
            for (int i = 10; i < 110 + tries; ++i) {
                this.factory.checkpoint();
                this.testBasic(i);
            }
        }
        catch (StandardException se) {
            this.REPORT("_______________________________________________________");
            this.REPORT("\n\tlog switch failed as requested");
            this.REPORT("_______________________________________________________");
            return;
        }
        catch (NullPointerException npe) {
            this.REPORT("_______________________________________________________");
            this.REPORT("\n\tlog switch failed as requested");
            this.REPORT("_______________________________________________________");
            return;
        }
        finally {
            SanityManager.DEBUG_CLEAR((String)LogToFile.TEST_SWITCH_LOG_FAIL2);
        }
        throw T_Fail.testFailMsg("log switch should have failed but did not even after " + tries + " tries");
    }

    protected void checkRecovery() throws T_Fail, StandardException {
        for (int numTest = 1; numTest <= 3; ++numTest) {
            int j;
            int i;
            int numtrans = (int)this.find(this.key(numTest, 1));
            int numpages = (int)this.find(this.key(numTest, 2));
            if (numtrans < 5 || numpages < 1) {
                this.REPORT("full log test " + numTest + " not run");
                continue;
            }
            this.REPORT("Test recovery of test " + numTest);
            Transaction t = this.t_util.t_startTransaction();
            long[] cid = new long[numtrans];
            ContainerHandle[] c = new ContainerHandle[numtrans];
            long[][] pagenum = new long[numtrans][numpages];
            Page[][] page = new Page[numtrans][numpages];
            for (i = 0; i < numtrans; ++i) {
                cid[i] = this.find(this.key(numTest, i + 10));
                c[i] = this.t_util.t_openContainer(t, 0L, cid[i], true);
                for (j = 0; j < numpages; ++j) {
                    pagenum[i][j] = this.find(this.key(numTest, (i + 1) * 1000 + j));
                    page[i][j] = this.t_util.t_getPage(c[i], pagenum[i][j]);
                }
            }
            for (j = 0; j < numpages; ++j) {
                T_Util.t_checkRecordCount(page[0][j], 1, 0);
                T_Util.t_checkFetchBySlot(page[0][j], 0, REC_001, true, true);
                T_Util.t_checkRecordCount(page[1][j], 1, 0);
                T_Util.t_checkFetchBySlot(page[1][j], 0, REC_001, true, true);
                T_Util.t_checkRecordCount(page[2][j], 1, 1);
                T_Util.t_checkFetchBySlot(page[2][j], 0, REC_006, false, true);
                T_Util.t_checkRecordCount(page[3][j], 1, 0);
                T_Util.t_checkFetchBySlot(page[3][j], 0, REC_001, true, true);
                T_Util.t_checkRecordCount(page[4][j], 1, 1);
                T_Util.t_checkFetchBySlot(page[4][j], 0, REC_006, false, true);
            }
            for (i = 0; i < numtrans; ++i) {
                String str = "container " + i + ":" + cid[i] + " pages: ";
                for (j = 0; j < numpages; ++j) {
                    str = str + pagenum[i][j] + " ";
                }
                this.REPORT("\t" + str);
            }
            this.t_util.t_commit(t);
            t.close();
        }
    }

    private static ContextService getContextService() {
        return AccessController.doPrivileged(new PrivilegedAction<ContextService>(){

            @Override
            public ContextService run() {
                return ContextService.getFactory();
            }
        });
    }

    private static Object findService(final String factoryInterface, final String serviceName) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return Monitor.findService((String)factoryInterface, (String)serviceName);
            }
        });
    }

    private static boolean startPersistentService(final String serviceName, final Properties properties) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws StandardException {
                    return Monitor.startPersistentService((String)serviceName, (Properties)properties);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw StandardException.plainWrapException((Throwable)pae);
        }
    }

    private static Object createPersistentService(final String factoryInterface, final String serviceName, final Properties properties) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.createPersistentService((String)factoryInterface, (String)serviceName, (Properties)properties);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw StandardException.plainWrapException((Throwable)pae);
        }
    }
}

