/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.harness;

import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_Generic;

public abstract class T_MultiIterations
extends T_Generic {
    protected T_MultiIterations() {
    }

    @Override
    protected void runTests() throws T_Fail {
        this.setupTest();
        int iterations = 1;
        String myClass = this.getClass().getName();
        String noPackage = myClass.substring(myClass.lastIndexOf(46) + 1);
        String propertyName = "derby." + noPackage + ".iterations";
        String iter = PropertyUtil.getSystemProperty((String)propertyName);
        if (iter != null) {
            try {
                iterations = Integer.parseInt(iter);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (iterations <= 0) {
                iterations = 1;
            }
        }
        for (int i = 0; i < iterations; ++i) {
            Runtime.getRuntime().gc();
            long btm = Runtime.getRuntime().totalMemory();
            long bfm = Runtime.getRuntime().freeMemory();
            long bum = btm - bfm;
            long start = System.currentTimeMillis();
            this.runTestSet();
            long end = System.currentTimeMillis();
            Runtime.getRuntime().gc();
            long atm = Runtime.getRuntime().totalMemory();
            long afm = Runtime.getRuntime().freeMemory();
            long aum = atm - afm;
            this.out.println("Iteration " + i + " took " + (end - start) + "ms");
            this.out.println("Total memory increased by " + (atm - btm) + " is " + atm);
            this.out.println("Used  memory increased by " + (aum - bum) + " is " + aum);
        }
    }

    protected abstract void setupTest() throws T_Fail;

    protected abstract void runTestSet() throws T_Fail;
}

