/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.tools;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;

public class SysinfoLocaleTest
extends BaseTestCase {
    private static final String SYSINFO_CLASS_NAME = "org.apache.derby.tools.sysinfo";
    private static final String ENCODING = "UTF-8";
    private final Locale defaultLocale;
    private final Properties _props;
    private final boolean localizedToGerman;
    private final String name;
    private Locale savedLocale;
    private static final String[] GERMAN_STRINGS = new String[]{"BS-Name", "Java-Benutzername", "Derby-Informationen", "Informationen zum Gebietsschema"};
    private static final String[] ITALIAN_STRINGS = new String[]{"Nome SO", "Home utente Java", "Informazioni su Derby", "Informazioni sulle impostazioni nazionali"};

    private SysinfoLocaleTest(Locale defaultLocale, boolean german, String info, Properties props) {
        super("testSysinfoLocale");
        this.defaultLocale = defaultLocale;
        this.localizedToGerman = german;
        this._props = props;
        this.name = super.getName() + ":" + info;
    }

    public String getName() {
        return this.name;
    }

    protected void setUp() {
        this.savedLocale = Locale.getDefault();
        Locale.setDefault(this.defaultLocale);
    }

    protected void tearDown() throws Exception {
        Locale.setDefault(this.savedLocale);
        this.savedLocale = null;
        super.tearDown();
    }

    public static Test suite() {
        if (!Derby.hasTools()) {
            return new BaseTestSuite("empty: no tools support");
        }
        BaseTestSuite suite = new BaseTestSuite("SysinfoLocaleTest");
        suite.addTest(SysinfoLocaleTest.createTest(Locale.ITALY, null, false));
        suite.addTest(SysinfoLocaleTest.createTest(Locale.ITALY, "it_IT", false));
        suite.addTest(SysinfoLocaleTest.createTest(Locale.ITALY, "de_DE", true));
        suite.addTest(SysinfoLocaleTest.createTest(Locale.GERMANY, null, true));
        suite.addTest(SysinfoLocaleTest.createTest(Locale.GERMANY, "it_IT", false));
        suite.addTest(SysinfoLocaleTest.createTest(Locale.GERMANY, "de_DE", true));
        return SecurityManagerSetup.noSecurityManager((Test)suite);
    }

    private static Test createTest(Locale loc, String ui, boolean german) {
        Properties prop = new Properties();
        if (ui != null) {
            prop.setProperty("derby.ui.locale", ui);
        }
        prop.setProperty("derby.ui.codeset", ENCODING);
        String info = "defaultLocale=" + loc + ",uiLocale=" + ui;
        SysinfoLocaleTest test = new SysinfoLocaleTest(loc, german, info, prop);
        return new SystemPropertyTestSetup((Test)test, prop);
    }

    private static void runSysinfo() throws Exception {
        URL sysinfoURL = SecurityManagerSetup.getURL(SYSINFO_CLASS_NAME);
        URL emmaURL = SysinfoLocaleTest.getEmmaJar();
        URL[] urls = null;
        urls = emmaURL != null ? new URL[]{sysinfoURL, emmaURL} : new URL[]{sysinfoURL};
        ClassLoader platformLoader = Connection.class.getClassLoader();
        URLClassLoader loader = new URLClassLoader(urls, platformLoader);
        Class<?> copy = Class.forName(SYSINFO_CLASS_NAME, true, loader);
        Method main = copy.getMethod("main", String[].class);
        main.invoke(null, new Object[]{new String[0]});
    }

    private static String getSysinfoOutput() throws Exception {
        PrintStream savedSystemOut = System.out;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            System.setOut(new PrintStream((OutputStream)bytes, true, ENCODING));
            SysinfoLocaleTest.runSysinfo();
        }
        finally {
            System.setOut(savedSystemOut);
        }
        return bytes.toString(ENCODING);
    }

    private String getSysinfoOutputWithModules() throws Exception {
        String language;
        String modulePath = JVMInfo.getSystemModulePath();
        ArrayList<Object> args = new ArrayList<Object>();
        String country = this.defaultLocale.getCountry();
        if (country != null && country.length() > 0) {
            args.add("-Duser.country=" + country);
        }
        if ((language = this.defaultLocale.getLanguage()) != null && language.length() > 0) {
            args.add("-Duser.language=" + language);
        }
        for (Object key : this._props.keySet()) {
            String keyName = (String)key;
            String value = this._props.getProperty(keyName);
            args.add("-D" + key + "=" + value);
        }
        args.add("-m");
        args.add("org.apache.derby.tools/org.apache.derby.tools.sysinfo");
        String[] command = new String[args.size()];
        args.toArray(command);
        Process sysinfoProcess = BaseTestCase.execJavaCmd(null, modulePath, command, null, true, true);
        String retval = SysinfoLocaleTest.readProcessOutput(sysinfoProcess);
        return retval;
    }

    private void assertContains(String[] expectedSubstrings, String output) {
        for (int i = 0; i < expectedSubstrings.length; ++i) {
            String s = expectedSubstrings[i];
            if (output.indexOf(s) != -1) continue;
            SysinfoLocaleTest.fail((String)("Substring '" + s + "' not found in output: " + output));
        }
    }

    public void testSysinfoLocale() throws Exception {
        String output = JVMInfo.isModuleAware() ? this.getSysinfoOutputWithModules() : SysinfoLocaleTest.getSysinfoOutput();
        String[] expectedSubstrings = this.localizedToGerman ? GERMAN_STRINGS : ITALIAN_STRINGS;
        this.assertContains(expectedSubstrings, output);
    }
}

