/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.harness;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.util.Vector;

public class SimpleDiff {
    PrintWriter pw;
    boolean debugOn = Boolean.getBoolean("simplediff.debug");
    int debugLevel = 1;
    boolean diffsFound = true;
    int lookAhead = 20;
    public static String usage = "java SimpleDiff <file1> <file2>";

    public void debug(int level, String msg) {
        if (this.debugLevel >= level) {
            this.debug(msg);
        }
    }

    public void debug(String msg) {
        if (this.debugOn) {
            System.out.println("DEBUG: " + msg);
        }
    }

    int lineCount(String file) throws IOException {
        BufferedReader input = new BufferedReader(new FileReader(file));
        int count = 0;
        String aLine = input.readLine();
        while (aLine != null) {
            ++count;
            aLine = input.readLine();
        }
        input.close();
        return count;
    }

    public String[] readFile(BufferedReader input) throws IOException {
        Vector<String> vec = new Vector<String>();
        String aLine = "";
        aLine = input.readLine();
        while (aLine != null) {
            vec.addElement(aLine);
            aLine = input.readLine();
        }
        input.close();
        Object[] rV = new String[vec.size()];
        this.debug(2, vec.size() + " lines in input");
        vec.copyInto(rV);
        return rV;
    }

    public void printFile(String[] file) {
        for (int i = 0; i < file.length; ++i) {
            this.pw.println(i + ": " + file[i]);
            System.out.println(i + ": " + file[i]);
        }
    }

    public String[] diffFiles(DiffBuffer file1, DiffBuffer file2) throws IOException {
        int currentLine1 = 0;
        int currentLine2 = 0;
        Vector<CallSite> returnVec = new Vector<CallSite>();
        while (file1.isValidOffset(currentLine1) && file2.isValidOffset(currentLine2)) {
            int checkCount;
            String f2;
            String f1 = file1.lineAt(currentLine1);
            if (f1.equals(f2 = file2.lineAt(currentLine2))) {
                this.debug(1, currentLine1 + ": match");
                file1.setLowWater(++currentLine1);
                file2.setLowWater(++currentLine2);
                continue;
            }
            boolean foundMatch = false;
            int checkLine2 = currentLine2;
            for (checkCount = 1; file2.isValidOffset(currentLine2 + checkCount) && checkCount < this.lookAhead; ++checkCount) {
                this.debug(1, "currentLine1 " + currentLine1 + "  currentLine2 " + (currentLine2 + checkCount));
                this.debug(1, "about to reference file2[" + (currentLine2 + checkCount) + "]");
                f2 = file2.lineAt(currentLine2 + checkCount);
                this.debug(2, "did");
                if (!f1.equals(f2)) continue;
                foundMatch = true;
                if (checkCount > 1) {
                    returnVec.addElement((CallSite)((Object)(currentLine1 + "a" + (currentLine2 + 1) + "," + (currentLine2 + checkCount))));
                } else {
                    returnVec.addElement((CallSite)((Object)(currentLine1 + "a" + (currentLine2 + 1))));
                }
                for (int j = 0; j < checkCount; ++j) {
                    returnVec.addElement((CallSite)((Object)("> " + file2.lineAt(currentLine2 + j))));
                }
                currentLine2 += checkCount;
                checkCount = 0;
                break;
            }
            if (!foundMatch && file2.isValidOffset(currentLine2)) {
                int checkLine1 = currentLine1;
                f2 = file2.lineAt(currentLine2);
                for (checkCount = 1; file1.isValidOffset(currentLine1 + checkCount) && checkCount < this.lookAhead; ++checkCount) {
                    this.debug(1, "currentLine2 " + currentLine2 + "  currentLine1 " + (currentLine1 + checkCount));
                    f1 = file1.lineAt(currentLine1 + checkCount);
                    if (!f2.equals(f1)) continue;
                    foundMatch = true;
                    if (checkCount > 1) {
                        returnVec.addElement((CallSite)((Object)(currentLine1 + 1 + "," + (currentLine1 + checkCount) + "d" + currentLine2)));
                    } else {
                        returnVec.addElement((CallSite)((Object)(currentLine1 + 1 + "d" + currentLine2)));
                    }
                    for (int j = 0; j < checkCount; ++j) {
                        returnVec.addElement((CallSite)((Object)("< " + file1.lineAt(currentLine1 + j))));
                    }
                    currentLine1 += checkCount;
                    checkCount = 0;
                    this.debug(1, "continuing");
                    break;
                }
            }
            if (!foundMatch) {
                this.debug(1, currentLine1 + ": NOMATCH");
                returnVec.addElement((CallSite)((Object)(currentLine1 + 1 + " del")));
                returnVec.addElement((CallSite)((Object)("< " + file1.lineAt(currentLine1))));
                ++currentLine1;
                continue;
            }
            file1.setLowWater(++currentLine1);
            file2.setLowWater(++currentLine2);
        }
        if (file1.isValidOffset(currentLine1)) {
            returnVec.addElement((CallSite)((Object)(currentLine2 + " del")));
            int i = currentLine1;
            while (file1.isValidOffset(i)) {
                returnVec.addElement((CallSite)((Object)("< " + file1.lineAt(i))));
                ++i;
            }
        }
        if (file2.isValidOffset(currentLine2)) {
            returnVec.addElement((CallSite)((Object)(currentLine1 + " add")));
            int i = currentLine2;
            while (file2.isValidOffset(i)) {
                returnVec.addElement((CallSite)((Object)("> " + file2.lineAt(i))));
                ++i;
            }
        }
        file1.close();
        file2.close();
        if (returnVec.isEmpty()) {
            return null;
        }
        Object[] returnArray = new String[returnVec.size()];
        returnVec.copyInto(returnArray);
        return returnArray;
    }

    private void reportMemory() {
        this.reportMemory(null);
    }

    private void reportMemory(String header) {
        if (header != null) {
            System.out.println(header);
        }
        long free = Runtime.getRuntime().freeMemory();
        long total = Runtime.getRuntime().totalMemory();
        System.out.println("total:         " + total);
        System.out.println("free:          " + free);
        System.out.println("used:          " + (total - free));
        System.gc();
        System.out.println("used: <postgc> " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
        System.out.println("  ");
    }

    public boolean doWork(BufferedReader in1, BufferedReader in2, PrintWriter localPW) throws IOException {
        this.pw = localPW == null ? new PrintWriter(System.out) : localPW;
        try {
            DiffBuffer db1 = new DiffBuffer(in1, "1");
            DiffBuffer db2 = new DiffBuffer(in2, "2");
            String[] diffs = this.diffFiles(db1, db2);
            if (diffs == null) {
                this.debug(1, "no diff");
                return false;
            }
            for (int i = 0; i < diffs.length; ++i) {
                this.pw.println(diffs[i]);
                System.out.println(diffs[i]);
            }
        }
        catch (IOException ioe) {
            System.err.println("IOException comparing <" + in1 + "> and <" + in2 + ">");
            System.err.println(ioe);
            this.pw.println("IOException comparing <" + in1 + "> and <" + in2 + ">");
            this.pw.println(ioe);
        }
        return true;
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.err.println("Invalid number of arguments");
            System.err.println("Usage: " + usage);
            System.exit(1);
        }
        SimpleDiff me = new SimpleDiff();
        try {
            BufferedReader br1 = new BufferedReader(new FileReader(args[0]));
            BufferedReader br2 = new BufferedReader(new FileReader(args[1]));
            me.doWork(br1, br2, null);
        }
        catch (IOException ioe) {
            System.out.println("IOExeption: " + ioe);
        }
    }

    public void pause() {
        BufferedInputStream bis = new BufferedInputStream(System.in);
        try {
            bis.read();
        }
        catch (IOException ioe) {
            this.pw.println("Error trying to pause...");
            System.out.println("Error trying to pause...");
        }
    }

    class DiffBuffer
    extends Vector<String> {
        public final String EMPTY;
        protected BufferedReader readBuffer;
        protected int currentLowWater;
        protected int currentHighWater;
        private int oldLow;
        protected String myName;
        protected boolean atEnd;
        protected int actualEndOfFile;

        public boolean atEOF() {
            return this.atEnd;
        }

        public DiffBuffer(BufferedReader rb) {
            this(rb, "");
        }

        public DiffBuffer(BufferedReader rb, String name) {
            this(rb, name, 1024);
        }

        public DiffBuffer(BufferedReader rb, String name, int size) {
            super(size);
            this.EMPTY = null;
            this.readBuffer = rb;
            this.currentLowWater = 0;
            this.currentHighWater = -1;
            this.oldLow = 0;
            this.myName = name;
            this.atEnd = false;
        }

        public boolean isValidOffset(int lineNumber) throws IOException {
            if (this.atEnd) {
                return lineNumber <= this.actualEndOfFile;
            }
            return this.lineAt(lineNumber) != null;
        }

        public String lineAt(int offset) throws IOException {
            if (offset > this.currentHighWater) {
                for (int i = 0; i < offset - this.currentHighWater; ++i) {
                    String aLine = this.readBuffer.readLine();
                    this.addElement(aLine);
                    if (aLine != null || this.atEnd) continue;
                    this.actualEndOfFile = this.currentHighWater + i;
                    this.atEnd = true;
                }
                this.currentHighWater = offset;
            }
            return (String)this.elementAt(offset);
        }

        public void setLowWater(int newLow) {
            for (int i = this.oldLow; i < newLow; ++i) {
                this.setElementAt(this.EMPTY, i);
            }
            this.currentLowWater = newLow;
            this.oldLow = newLow - 1;
        }

        public void iterate(boolean verbose) {
            int nulls = 0;
            int nonnulls = 0;
            for (int i = 0; i < this.size(); ++i) {
                if (this.elementAt(i) == null) {
                    if (verbose) {
                        System.out.print("[" + i + "] ");
                        System.out.println("null");
                    }
                    ++nulls;
                    continue;
                }
                if (verbose) {
                    System.out.print("[" + i + "] ");
                    System.out.println("NotNULL");
                }
                ++nonnulls;
            }
            System.out.println("nulls: " + nulls + "  nonNull: " + nonnulls);
        }

        public void close() throws IOException {
            this.readBuffer.close();
            this.readBuffer = null;
        }
    }
}

