/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.lib.util;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.daffodil.lib.util.Logger$;
import org.apache.daffodil.lib.util.Misc$;
import org.apache.daffodil.lib.util.SimpleNamedLoadableService;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Growable;
import scala.package$;
import scala.runtime.BoxedUnit;

public final class SimpleNamedServiceLoader$ {
    public static final SimpleNamedServiceLoader$ MODULE$ = new SimpleNamedServiceLoader$();

    public <T extends SimpleNamedLoadableService> Map<String, T> loadClass(Class<T> clazz) {
        String thingName = Misc$.MODULE$.getNameGivenAClassObject(clazz);
        Iterator<T> iter = ServiceLoader.load(clazz).iterator();
        ArrayBuffer instanceBuf = new ArrayBuffer();
        while (iter.hasNext()) {
            Growable growable;
            try {
                growable = instanceBuf.$plus$eq(iter.next());
            }
            catch (ServiceConfigurationError e) {
                BoxedUnit boxedUnit;
                if (Logger$.MODULE$.log().underlying().isWarnEnabled()) {
                    Logger$.MODULE$.log().underlying().warn("Named service {} failed to load: {}. Enable debug logging for more details", new Object[]{thingName, e.getMessage()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                if (Logger$.MODULE$.log().underlying().isDebugEnabled()) {
                    Logger logger = Logger$.MODULE$.log().underlying();
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter((Writer)sw, true);
                    e.printStackTrace(pw);
                    pw.close();
                    logger.debug(sw.toString());
                    growable = BoxedUnit.UNIT;
                }
                growable = BoxedUnit.UNIT;
            }
            Growable compilerOpt = growable;
        }
        Map instancesFound = instanceBuf.toSeq().groupBy((Function1 & Serializable)x$1 -> x$1.name());
        Map instanceMap = ((IterableOnceOps)instancesFound.toSeq().flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                SeqOps seqOps;
                String name = (String)tuple2._1();
                Seq seq = (Seq)tuple2._2();
                if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
                    SimpleNamedLoadableService lc = (SimpleNamedLoadableService)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                    return new Some((Object)new Tuple2((Object)name, (Object)lc));
                }
            }
            if (tuple2 != null) {
                BoxedUnit boxedUnit;
                Seq seq = (Seq)tuple2._2();
                if (Logger$.MODULE$.log().underlying().isWarnEnabled()) {
                    Logger$.MODULE$.log().underlying().warn("Duplicate classes for {} found. Ignored: {}.", new Object[]{thingName, ((IterableOnceOps)seq.map((Function1 & Serializable)x$2 -> Misc$.MODULE$.getNameFromClass(x$2))).mkString(", ")});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return None$.MODULE$;
            }
            throw new MatchError((Object)tuple2);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return instanceMap;
    }

    private SimpleNamedServiceLoader$() {
    }
}

