/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.io.processors.charset;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import org.apache.daffodil.io.processors.charset.BitsCharset;
import org.apache.daffodil.io.processors.charset.BitsCharsetDefinition;
import org.apache.daffodil.io.processors.charset.BitsCharsetDefinitionRegistry$;
import org.apache.daffodil.lib.exceptions.Assert$;
import scala.Function0;

public final class CharsetUtils$ {
    public static final CharsetUtils$ MODULE$ = new CharsetUtils$();
    private static boolean hasJava7DecoderBug;
    private static final char unicodeReplacementChar;
    private static volatile boolean bitmap$0;

    static {
        unicodeReplacementChar = (char)65533;
    }

    public BitsCharset getCharset(String name) {
        BitsCharsetDefinition cs = (BitsCharsetDefinition)BitsCharsetDefinitionRegistry$.MODULE$.find(name.toUpperCase()).getOrElse((Function0 & Serializable)() -> null);
        if (cs == null) {
            return null;
        }
        return cs.charset();
    }

    public String supportedEncodingsString() {
        return BitsCharsetDefinitionRegistry$.MODULE$.supportedEncodingsString();
    }

    private boolean hasJava7DecoderBug$lzycompute() {
        CharsetUtils$ charsetUtils$ = this;
        synchronized (charsetUtils$) {
            if (!bitmap$0) {
                boolean bl;
                CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
                decoder.onMalformedInput(CodingErrorAction.REPORT);
                decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
                ByteBuffer bb = ByteBuffer.allocate(6);
                bb.put((byte)-16);
                bb.limit(6).position(0);
                CharBuffer cb = CharBuffer.allocate(1);
                CoderResult cr = decoder.decode(bb, cb, true);
                if (cr.isOverflow() && cb.position() == 0 && bb.position() == 0) {
                    bl = true;
                } else if (cr.isError()) {
                    bl = false;
                } else {
                    throw Assert$.MODULE$.invariantFailed(new StringBuilder(29).append("Unexpected decoder behavior. ").append(cr).toString());
                }
                hasJava7DecoderBug = bl;
                bitmap$0 = true;
            }
        }
        return hasJava7DecoderBug;
    }

    public boolean hasJava7DecoderBug() {
        if (!bitmap$0) {
            return this.hasJava7DecoderBug$lzycompute();
        }
        return hasJava7DecoderBug;
    }

    public char unicodeReplacementChar() {
        return unicodeReplacementChar;
    }

    private CharsetUtils$() {
    }
}

