/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.unparsers.runtime1;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.daffodil.io.DataOutputStream;
import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.runtime1.processors.ElementRuntimeData;
import org.apache.daffodil.runtime1.processors.unparsers.UState;
import org.apache.daffodil.unparsers.runtime1.PackedBinaryBaseUnparser;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005Q3QAB\u0004\u0002\u0002IA\u0011b\u0006\u0001\u0003\u0002\u0003\u0006I\u0001G\u0010\t\u0011\u0005\u0002!\u0011!Q\u0001\n\tBQ\u0001\u000b\u0001\u0005\u0002%BQ!\f\u0001\u0005B9BQA\u0010\u0001\u0005B}\u0012q\u0004U1dW\u0016$')\u001b8bef$UmY5nC2\u0014\u0015m]3V]B\f'o]3s\u0015\tA\u0011\"\u0001\u0005sk:$\u0018.\\32\u0015\tQ1\"A\u0005v]B\f'o]3sg*\u0011A\"D\u0001\tI\u00064gm\u001c3jY*\u0011abD\u0001\u0007CB\f7\r[3\u000b\u0003A\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\n\u0011\u0005Q)R\"A\u0004\n\u0005Y9!\u0001\u0007)bG.,GMQ5oCJL()Y:f+:\u0004\u0018M]:fe\u0006\tQ\r\u0005\u0002\u001a;5\t!D\u0003\u0002\u001c9\u0005Q\u0001O]8dKN\u001cxN]:\u000b\u0005!Y\u0011B\u0001\u0010\u001b\u0005I)E.Z7f]R\u0014VO\u001c;j[\u0016$\u0015\r^1\n\u0005\u0001*\u0012aB2p]R,\u0007\u0010^\u0001\u001aE&t\u0017M]=EK\u000eLW.\u00197WSJ$X/\u00197Q_&tG\u000f\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CEA\u0002J]R\fa\u0001P5oSRtDc\u0001\u0016,YA\u0011A\u0003\u0001\u0005\u0006/\r\u0001\r\u0001\u0007\u0005\u0006C\r\u0001\rAI\u0001\u000fO\u0016$h*^7cKJ$v\u000eU;u)\tys\u0007\u0005\u00021k5\t\u0011G\u0003\u00023g\u0005!A.\u00198h\u0015\u0005!\u0014\u0001\u00026bm\u0006L!AN\u0019\u0003\r9+XNY3s\u0011\u0015AD\u00011\u0001:\u0003\u0019)8\u000f^1uKB\u0011!\bP\u0007\u0002w)\u0011!BG\u0005\u0003{m\u0012a!V*uCR,\u0017!\u00039vi:+XNY3s)\u0015\u00015iS'P!\t\u0019\u0013)\u0003\u0002CI\t9!i\\8mK\u0006t\u0007\"\u0002#\u0006\u0001\u0004)\u0015a\u00013pgB\u0011a)S\u0007\u0002\u000f*\u0011\u0001jC\u0001\u0003S>L!AS$\u0003!\u0011\u000bG/Y(viB,Ho\u0015;sK\u0006l\u0007\"\u0002'\u0006\u0001\u0004y\u0013A\u00028v[\n,'\u000fC\u0003O\u000b\u0001\u0007!%A\u0003o\u0005&$8\u000fC\u0003Q\u000b\u0001\u0007\u0011+A\u0003gS:4w\u000e\u0005\u0002G%&\u00111k\u0012\u0002\u000b\r>\u0014X.\u0019;J]\u001a|\u0007")
public abstract class PackedBinaryDecimalBaseUnparser
extends PackedBinaryBaseUnparser {
    private final int binaryDecimalVirtualPoint;

    @Override
    public Number getNumberToPut(UState ustate) {
        Number number = super.getNumberToPut(ustate);
        BigDecimal bigDec = (BigDecimal)number;
        if (bigDec.movePointRight(this.binaryDecimalVirtualPoint).scale() != 0) {
            throw super.context().schemaDefinitionError("Decimal point of number '%s' does not match the binaryVirtualDecmialPoint: %d", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{bigDec, BoxesRunTime.boxToInteger((int)this.binaryDecimalVirtualPoint)}));
        }
        return bigDec.unscaledValue();
    }

    @Override
    public boolean putNumber(DataOutputStream dos, Number number, int nBits, FormatInfo finfo) {
        byte[] packedNum = this.fromBigInteger((BigInteger)number, nBits);
        return dos.putByteArray(packedNum, (long)(packedNum.length * 8), finfo, dos.putByteArray$default$4());
    }

    public PackedBinaryDecimalBaseUnparser(ElementRuntimeData e, int binaryDecimalVirtualPoint) {
        this.binaryDecimalVirtualPoint = binaryDecimalVirtualPoint;
        super(e);
    }
}

